//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeducation

import "time"

// Amount - The amount.
type Amount struct {
	// The type of currency being used for the value.
	Currency *string

	// Amount value.
	Value *float32
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// Error code
	Code *string

	// Error message indicating why the operation failed.
	Message *string
}

// ErrorResponseBody - Error response indicates that the service is not able to process the incoming request. The reason is
// provided in the error message.
type ErrorResponseBody struct {
	// The details of the error.
	Error *ErrorResponse
}

// GrantDetailProperties - Grant detail properties
type GrantDetailProperties struct {
	// READ-ONLY; allocated budget
	AllocatedBudget *Amount

	// READ-ONLY; Grant Effective Date
	EffectiveDate *time.Time

	// READ-ONLY; Expiration Date
	ExpirationDate *time.Time

	// READ-ONLY; Offer Cap
	OfferCap *Amount

	// READ-ONLY; Grant Offer Type
	OfferType *GrantType

	// READ-ONLY; Grant status
	Status *GrantStatus
}

// GrantDetails - Grant details.
type GrantDetails struct {
	// Grant detail properties.
	Properties *GrantDetailProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GrantListResponse - List of Grants info.
type GrantListResponse struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of labs.
	Value []*GrantDetails
}

// InviteCodeGenerateRequest - invite code generate request.
type InviteCodeGenerateRequest struct {
	// the total number of students that can be accepted to the lab.
	MaxStudentCount *float32
}

// JoinRequestDetails - join requests.
type JoinRequestDetails struct {
	// join request properties.
	Properties *JoinRequestProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// JoinRequestList - list of join requests.
type JoinRequestList struct {
	// READ-ONLY; the link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of requests.
	Value []*JoinRequestDetails
}

// JoinRequestProperties - Join request properties.
type JoinRequestProperties struct {
	// join request email
	Email *string

	// First Name
	FirstName *string

	// Last Name
	LastName *string

	// Join request status
	Status *JoinRequestStatus
}

// LabDetails - Lab details.
type LabDetails struct {
	// Get lab response properties.
	Properties *LabProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LabListResult - List of labs.
type LabListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of labs.
	Value []*LabDetails
}

// LabProperties - Lab detail result properties.
type LabProperties struct {
	// REQUIRED; Default monetary cap for each student in this lab
	BudgetPerStudent *Amount

	// REQUIRED; Detail description of this lab
	Description *string

	// REQUIRED; Lab Display Name
	DisplayName *string

	// REQUIRED; Default expiration date for each student in this lab
	ExpirationDate *time.Time

	// READ-ONLY; Lab creation date
	EffectiveDate *time.Time

	// READ-ONLY; invitation code for redeemable lab
	InvitationCode *string

	// READ-ONLY; the total number of students that can be accepted to the lab.
	MaxStudentCount *float32

	// READ-ONLY; The status of this lab
	Status *LabStatus

	// READ-ONLY; Total allocated budget
	TotalAllocatedBudget *Amount

	// READ-ONLY; Total budget
	TotalBudget *Amount
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// RedeemRequest - redeem request.
type RedeemRequest struct {
	// REQUIRED; first name of requester
	FirstName *string

	// REQUIRED; last name of requester
	LastName *string

	// REQUIRED; redeem code
	RedeemCode *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// StudentDetails - Student details.
type StudentDetails struct {
	// Get student response properties.
	Properties *StudentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// StudentLabDetails - Student lab details.
type StudentLabDetails struct {
	// Student lab properties.
	Properties *StudentLabProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// StudentLabListResult - List of labs.
type StudentLabListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of labs.
	Value []*StudentLabDetails
}

// StudentLabProperties - Student lab detail properties
type StudentLabProperties struct {
	// READ-ONLY; Student Budget
	Budget *Amount

	// READ-ONLY; Detail description of this lab
	Description *string

	// READ-ONLY; Student lab Display Name
	DisplayName *string

	// READ-ONLY; User Added Date
	EffectiveDate *time.Time

	// READ-ONLY; Date the lab will expire and by default will be the expiration date for each student in this lab
	ExpirationDate *time.Time

	// READ-ONLY; Lab Scope. /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default
	LabScope *string

	// READ-ONLY; Student Role
	Role *StudentRole

	// READ-ONLY; Student Lab Status
	Status *StudentLabStatus

	// READ-ONLY; Subscription Id
	SubscriptionID *string
}

// StudentListResult - List of students.
type StudentListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of students.
	Value []*StudentDetails
}

// StudentProperties - Student detail properties
type StudentProperties struct {
	// REQUIRED; Student Budget
	Budget *Amount

	// REQUIRED; Student Email
	Email *string

	// REQUIRED; Date this student is set to expire from the lab.
	ExpirationDate *time.Time

	// REQUIRED; First Name
	FirstName *string

	// REQUIRED; Last Name
	LastName *string

	// REQUIRED; Student Role
	Role *StudentRole

	// Subscription alias
	SubscriptionAlias *string

	// subscription invite last sent date
	SubscriptionInviteLastSentDate *time.Time

	// READ-ONLY; Date student was added to the lab
	EffectiveDate *time.Time

	// READ-ONLY; Student Lab Status
	Status *StudentLabStatus

	// READ-ONLY; Subscription Id
	SubscriptionID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}
