//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armintegrationspaces

import "time"

// Application - An integration application under space.
type Application struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The resource-specific properties for this resource.
	Properties *ApplicationProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ApplicationListResult - The response of a Application list operation.
type ApplicationListResult struct {
	// REQUIRED; The Application items on this page
	Value []*Application

	// The link to the next page of items
	NextLink *string
}

// ApplicationProperties - The properties of application.
type ApplicationProperties struct {
	// REQUIRED; The tracking data stores.
	TrackingDataStores map[string]*TrackingDataStore

	// The description of the resource.
	Description *string

	// READ-ONLY; The status of the last operation.
	ProvisioningState *ProvisioningState
}

// ApplicationResource - A resource under application.
type ApplicationResource struct {
	// The resource-specific properties for this resource.
	Properties *ApplicationResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ApplicationResourceListResult - The response of a ApplicationResource list operation.
type ApplicationResourceListResult struct {
	// REQUIRED; The ApplicationResource items on this page
	Value []*ApplicationResource

	// The link to the next page of items
	NextLink *string
}

// ApplicationResourceProperties - The properties of application resource.
type ApplicationResourceProperties struct {
	// REQUIRED; The Arm id of the application resource.
	ResourceID *string

	// REQUIRED; The type of the application resource.
	ResourceType *string

	// The kind of the application resource.
	ResourceKind *string

	// READ-ONLY; The status of the last operation.
	ProvisioningState *ProvisioningState
}

// ApplicationResourceUpdate - The type used for update operations of the ApplicationResource.
type ApplicationResourceUpdate struct {
	// The updatable properties of the ApplicationResource.
	Properties *ApplicationResourceUpdateProperties
}

// ApplicationResourceUpdateProperties - The updatable properties of the ApplicationResource.
type ApplicationResourceUpdateProperties struct {
	// The Arm id of the application resource.
	ResourceID *string

	// The kind of the application resource.
	ResourceKind *string

	// The type of the application resource.
	ResourceType *string
}

// ApplicationUpdate - The type used for update operations of the Application.
type ApplicationUpdate struct {
	// The updatable properties of the Application.
	Properties *ApplicationUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// ApplicationUpdateProperties - The updatable properties of the Application.
type ApplicationUpdateProperties struct {
	// The description of the resource.
	Description *string

	// The tracking data stores.
	TrackingDataStores map[string]*TrackingDataStore
}

// BusinessProcess - A business process under application.
type BusinessProcess struct {
	// The resource-specific properties for this resource.
	Properties *BusinessProcessProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BusinessProcessDevelopmentArtifactProperties - The properties of business process development artifact.
type BusinessProcessDevelopmentArtifactProperties struct {
	// The business process mapping.
	BusinessProcessMapping map[string]*BusinessProcessMappingItem

	// The business process stages.
	BusinessProcessStages map[string]*BusinessProcessStage

	// The description of the business process.
	Description *string

	// The business process identifier.
	Identifier *BusinessProcessIdentifier

	// The tracking profile for the business process.
	TrackingProfiles map[string]*TrackingProfileDefinition
}

// BusinessProcessIdentifier - The properties of business process identifier.
type BusinessProcessIdentifier struct {
	// The property name of the business process identifier.
	PropertyName *string

	// The property type of the business process identifier.
	PropertyType *string
}

// BusinessProcessListResult - The response of a BusinessProcess list operation.
type BusinessProcessListResult struct {
	// REQUIRED; The BusinessProcess items on this page
	Value []*BusinessProcess

	// The link to the next page of items
	NextLink *string
}

// BusinessProcessMappingItem - The properties of business process mapping.
type BusinessProcessMappingItem struct {
	// The logic app resource id.
	LogicAppResourceID *string

	// The operation name.
	OperationName *string

	// The mapping item operation type of the business process.
	OperationType *string

	// The workflow name within the logic app.
	WorkflowName *string
}

// BusinessProcessProperties - The properties of business process.
type BusinessProcessProperties struct {
	// The business process mapping.
	BusinessProcessMapping map[string]*BusinessProcessMappingItem

	// The business process stages.
	BusinessProcessStages map[string]*BusinessProcessStage

	// The description of the business process.
	Description *string

	// The business process identifier.
	Identifier *BusinessProcessIdentifier

	// The table name of the business process.
	TableName *string

	// The tracking data store reference name.
	TrackingDataStoreReferenceName *string

	// READ-ONLY; The status of the last operation.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The version of the business process.
	Version *string
}

// BusinessProcessReference - The business process reference.
type BusinessProcessReference struct {
	// The business process name.
	Name *string

	// The business process version.
	Version *string
}

// BusinessProcessStage - The properties of business process stage.
type BusinessProcessStage struct {
	// The description of the business stage.
	Description *string

	// The properties within the properties of the business process stage.
	Properties map[string]*string

	// The property to keep track of stages before current in the business process stage.
	StagesBefore []*string
}

// BusinessProcessUpdate - The type used for update operations of the BusinessProcess.
type BusinessProcessUpdate struct {
	// The updatable properties of the BusinessProcess.
	Properties *BusinessProcessUpdateProperties
}

// BusinessProcessUpdateProperties - The updatable properties of the BusinessProcess.
type BusinessProcessUpdateProperties struct {
	// The business process mapping.
	BusinessProcessMapping map[string]*BusinessProcessMappingItem

	// The business process stages.
	BusinessProcessStages map[string]*BusinessProcessStage

	// The description of the business process.
	Description *string

	// The business process identifier.
	Identifier *BusinessProcessIdentifier

	// The table name of the business process.
	TableName *string

	// The tracking data store reference name.
	TrackingDataStoreReferenceName *string
}

// BusinessProcessVersion - A business process version.
type BusinessProcessVersion struct {
	// The resource-specific properties for this resource.
	Properties *BusinessProcessProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BusinessProcessVersionListResult - The response of a BusinessProcessVersion list operation.
type BusinessProcessVersionListResult struct {
	// REQUIRED; The BusinessProcessVersion items on this page
	Value []*BusinessProcessVersion

	// The link to the next page of items
	NextLink *string
}

// FlowTrackingDefinition - The workflow tracking definition.
type FlowTrackingDefinition struct {
	// The tracking correlation context.
	CorrelationContext *TrackingCorrelationContext

	// The tracking events.
	Events map[string]*TrackingEventDefinition
}

// GetOrDeleteBusinessProcessDevelopmentArtifactRequest - The business process development artifact get or delete request.
type GetOrDeleteBusinessProcessDevelopmentArtifactRequest struct {
	// REQUIRED; The name of the business process development artifact.
	Name *string
}

// InfrastructureResource - An infrastructure resource under Space.
type InfrastructureResource struct {
	// The resource-specific properties for this resource.
	Properties *InfrastructureResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// InfrastructureResourceListResult - The response of a InfrastructureResource list operation.
type InfrastructureResourceListResult struct {
	// REQUIRED; The InfrastructureResource items on this page
	Value []*InfrastructureResource

	// The link to the next page of items
	NextLink *string
}

// InfrastructureResourceProperties - The properties of infrastructure resource.
type InfrastructureResourceProperties struct {
	// REQUIRED; The id of the infrastructure resource.
	ResourceID *string

	// REQUIRED; The type of the infrastructure resource.
	ResourceType *string

	// READ-ONLY; The status of the last operation.
	ProvisioningState *ProvisioningState
}

// InfrastructureResourceUpdate - The type used for update operations of the InfrastructureResource.
type InfrastructureResourceUpdate struct {
	// The updatable properties of the InfrastructureResource.
	Properties *InfrastructureResourceUpdateProperties
}

// InfrastructureResourceUpdateProperties - The updatable properties of the InfrastructureResource.
type InfrastructureResourceUpdateProperties struct {
	// The id of the infrastructure resource.
	ResourceID *string

	// The type of the infrastructure resource.
	ResourceType *string
}

// ListBusinessProcessDevelopmentArtifactsResponse - The business process development artifact get collection response.
type ListBusinessProcessDevelopmentArtifactsResponse struct {
	// REQUIRED; The list of the business process development artifact.
	Value []*SaveOrGetBusinessProcessDevelopmentArtifactResponse
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// SaveOrGetBusinessProcessDevelopmentArtifactResponse - The business process development artifact save or get response.
type SaveOrGetBusinessProcessDevelopmentArtifactResponse struct {
	// REQUIRED; The name of the business process development artifact.
	Name *string

	// The properties of the business process development artifact.
	Properties *BusinessProcessDevelopmentArtifactProperties

	// READ-ONLY; The system data of the business process development artifact.
	SystemData *SystemData
}

// SaveOrValidateBusinessProcessDevelopmentArtifactRequest - The business process development artifact save or validate request.
type SaveOrValidateBusinessProcessDevelopmentArtifactRequest struct {
	// REQUIRED; The name of the business process development artifact.
	Name *string

	// The properties of the business process development artifact.
	Properties *BusinessProcessDevelopmentArtifactProperties
}

// Space - An integration space.
type Space struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The resource-specific properties for this resource.
	Properties *SpaceResourceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SpaceListResult - The response of a Space list operation.
type SpaceListResult struct {
	// REQUIRED; The Space items on this page
	Value []*Space

	// The link to the next page of items
	NextLink *string
}

// SpaceResourceProperties - The properties of space.
type SpaceResourceProperties struct {
	// The description of the resource.
	Description *string

	// READ-ONLY; The status of the last operation.
	ProvisioningState *ProvisioningState
}

// SpaceUpdate - The type used for update operations of the Space.
type SpaceUpdate struct {
	// The updatable properties of the Space.
	Properties *SpaceUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// SpaceUpdateProperties - The updatable properties of the Space.
type SpaceUpdateProperties struct {
	// The description of the resource.
	Description *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrackingCorrelationContext - The tracking correlation context.
type TrackingCorrelationContext struct {
	// The operation name for correlation context.
	OperationName *string

	// The operation type for correlation context.
	OperationType *string

	// The name of the correlation property.
	PropertyName *string

	// The template expression for correlation context property value.
	Value *string
}

// TrackingDataStore - The properties of tracking data store.
type TrackingDataStore struct {
	// REQUIRED; The data store ingestion URI.
	DataStoreIngestionURI *string

	// REQUIRED; The data store resource id.
	DataStoreResourceID *string

	// REQUIRED; The data store URI.
	DataStoreURI *string

	// REQUIRED; The database name.
	DatabaseName *string
}

// TrackingEventDefinition - The tracking event definition.
type TrackingEventDefinition struct {
	// The operation name.
	OperationName *string

	// The operation type.
	OperationType *string

	// The properties to be collected for event.
	Properties map[string]any
}

// TrackingProfileDefinition - The tracking profile for the business process
type TrackingProfileDefinition struct {
	// The business process reference.
	BusinessProcess *BusinessProcessReference

	// The tracking definition schema uri.
	Schema *string

	// The tracking definitions.
	TrackingDefinitions map[string]*FlowTrackingDefinition
}
