//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logic/armlogic"
	"net/http"
	"net/url"
	"regexp"
)

// IntegrationServiceEnvironmentNetworkHealthServer is a fake server for instances of the armlogic.IntegrationServiceEnvironmentNetworkHealthClient type.
type IntegrationServiceEnvironmentNetworkHealthServer struct {
	// Get is the fake for method IntegrationServiceEnvironmentNetworkHealthClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroup string, integrationServiceEnvironmentName string, options *armlogic.IntegrationServiceEnvironmentNetworkHealthClientGetOptions) (resp azfake.Responder[armlogic.IntegrationServiceEnvironmentNetworkHealthClientGetResponse], errResp azfake.ErrorResponder)
}

// NewIntegrationServiceEnvironmentNetworkHealthServerTransport creates a new instance of IntegrationServiceEnvironmentNetworkHealthServerTransport with the provided implementation.
// The returned IntegrationServiceEnvironmentNetworkHealthServerTransport instance is connected to an instance of armlogic.IntegrationServiceEnvironmentNetworkHealthClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIntegrationServiceEnvironmentNetworkHealthServerTransport(srv *IntegrationServiceEnvironmentNetworkHealthServer) *IntegrationServiceEnvironmentNetworkHealthServerTransport {
	return &IntegrationServiceEnvironmentNetworkHealthServerTransport{srv: srv}
}

// IntegrationServiceEnvironmentNetworkHealthServerTransport connects instances of armlogic.IntegrationServiceEnvironmentNetworkHealthClient to instances of IntegrationServiceEnvironmentNetworkHealthServer.
// Don't use this type directly, use NewIntegrationServiceEnvironmentNetworkHealthServerTransport instead.
type IntegrationServiceEnvironmentNetworkHealthServerTransport struct {
	srv *IntegrationServiceEnvironmentNetworkHealthServer
}

// Do implements the policy.Transporter interface for IntegrationServiceEnvironmentNetworkHealthServerTransport.
func (i *IntegrationServiceEnvironmentNetworkHealthServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IntegrationServiceEnvironmentNetworkHealthClient.Get":
		resp, err = i.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IntegrationServiceEnvironmentNetworkHealthServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroup>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logic/integrationServiceEnvironments/(?P<integrationServiceEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/health/network`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroup")])
	if err != nil {
		return nil, err
	}
	integrationServiceEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationServiceEnvironmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupParam, integrationServiceEnvironmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
