//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managednetwork/armmanagednetwork"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// PeeringPoliciesServer is a fake server for instances of the armmanagednetwork.PeeringPoliciesClient type.
type PeeringPoliciesServer struct {
	// BeginCreateOrUpdate is the fake for method PeeringPoliciesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, managedNetworkName string, managedNetworkPeeringPolicyName string, managedNetworkPolicy armmanagednetwork.PeeringPolicy, options *armmanagednetwork.PeeringPoliciesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmanagednetwork.PeeringPoliciesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method PeeringPoliciesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, managedNetworkName string, managedNetworkPeeringPolicyName string, options *armmanagednetwork.PeeringPoliciesClientBeginDeleteOptions) (resp azfake.PollerResponder[armmanagednetwork.PeeringPoliciesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PeeringPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedNetworkName string, managedNetworkPeeringPolicyName string, options *armmanagednetwork.PeeringPoliciesClientGetOptions) (resp azfake.Responder[armmanagednetwork.PeeringPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByManagedNetworkPager is the fake for method PeeringPoliciesClient.NewListByManagedNetworkPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagedNetworkPager func(resourceGroupName string, managedNetworkName string, options *armmanagednetwork.PeeringPoliciesClientListByManagedNetworkOptions) (resp azfake.PagerResponder[armmanagednetwork.PeeringPoliciesClientListByManagedNetworkResponse])
}

// NewPeeringPoliciesServerTransport creates a new instance of PeeringPoliciesServerTransport with the provided implementation.
// The returned PeeringPoliciesServerTransport instance is connected to an instance of armmanagednetwork.PeeringPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPeeringPoliciesServerTransport(srv *PeeringPoliciesServer) *PeeringPoliciesServerTransport {
	return &PeeringPoliciesServerTransport{
		srv:                          srv,
		beginCreateOrUpdate:          newTracker[azfake.PollerResponder[armmanagednetwork.PeeringPoliciesClientCreateOrUpdateResponse]](),
		beginDelete:                  newTracker[azfake.PollerResponder[armmanagednetwork.PeeringPoliciesClientDeleteResponse]](),
		newListByManagedNetworkPager: newTracker[azfake.PagerResponder[armmanagednetwork.PeeringPoliciesClientListByManagedNetworkResponse]](),
	}
}

// PeeringPoliciesServerTransport connects instances of armmanagednetwork.PeeringPoliciesClient to instances of PeeringPoliciesServer.
// Don't use this type directly, use NewPeeringPoliciesServerTransport instead.
type PeeringPoliciesServerTransport struct {
	srv                          *PeeringPoliciesServer
	beginCreateOrUpdate          *tracker[azfake.PollerResponder[armmanagednetwork.PeeringPoliciesClientCreateOrUpdateResponse]]
	beginDelete                  *tracker[azfake.PollerResponder[armmanagednetwork.PeeringPoliciesClientDeleteResponse]]
	newListByManagedNetworkPager *tracker[azfake.PagerResponder[armmanagednetwork.PeeringPoliciesClientListByManagedNetworkResponse]]
}

// Do implements the policy.Transporter interface for PeeringPoliciesServerTransport.
func (p *PeeringPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PeeringPoliciesClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "PeeringPoliciesClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "PeeringPoliciesClient.Get":
		resp, err = p.dispatchGet(req)
	case "PeeringPoliciesClient.NewListByManagedNetworkPager":
		resp, err = p.dispatchNewListByManagedNetworkPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PeeringPoliciesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetwork/managedNetworks/(?P<managedNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managedNetworkPeeringPolicies/(?P<managedNetworkPeeringPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetwork.PeeringPolicy](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkName")])
		if err != nil {
			return nil, err
		}
		managedNetworkPeeringPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkPeeringPolicyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, managedNetworkNameParam, managedNetworkPeeringPolicyNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *PeeringPoliciesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetwork/managedNetworks/(?P<managedNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managedNetworkPeeringPolicies/(?P<managedNetworkPeeringPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkName")])
		if err != nil {
			return nil, err
		}
		managedNetworkPeeringPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkPeeringPolicyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, managedNetworkNameParam, managedNetworkPeeringPolicyNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *PeeringPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetwork/managedNetworks/(?P<managedNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managedNetworkPeeringPolicies/(?P<managedNetworkPeeringPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkName")])
	if err != nil {
		return nil, err
	}
	managedNetworkPeeringPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkPeeringPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, managedNetworkNameParam, managedNetworkPeeringPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PeeringPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PeeringPoliciesServerTransport) dispatchNewListByManagedNetworkPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByManagedNetworkPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagedNetworkPager not implemented")}
	}
	newListByManagedNetworkPager := p.newListByManagedNetworkPager.get(req)
	if newListByManagedNetworkPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetwork/managedNetworks/(?P<managedNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managedNetworkPeeringPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		var options *armmanagednetwork.PeeringPoliciesClientListByManagedNetworkOptions
		if topParam != nil || skiptokenParam != nil {
			options = &armmanagednetwork.PeeringPoliciesClientListByManagedNetworkOptions{
				Top:       topParam,
				Skiptoken: skiptokenParam,
			}
		}
		resp := p.srv.NewListByManagedNetworkPager(resourceGroupNameParam, managedNetworkNameParam, options)
		newListByManagedNetworkPager = &resp
		p.newListByManagedNetworkPager.add(req, newListByManagedNetworkPager)
		server.PagerResponderInjectNextLinks(newListByManagedNetworkPager, req, func(page *armmanagednetwork.PeeringPoliciesClientListByManagedNetworkResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByManagedNetworkPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByManagedNetworkPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagedNetworkPager) {
		p.newListByManagedNetworkPager.remove(req)
	}
	return resp, nil
}
