//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmarketplace

import "time"

// AcknowledgeOfferNotificationDetails - Notification update request payload details
type AcknowledgeOfferNotificationDetails struct {
	// Gets or sets a value indicating whether acknowledge action flag is enabled
	Acknowledge *bool

	// Gets or sets added plans
	AddPlans []*string

	// Gets or sets a value indicating whether dismiss action flag is enabled
	Dismiss *bool

	// Gets or sets a value indicating whether remove offer action flag is enabled
	RemoveOffer *bool

	// Gets or sets remove plans
	RemovePlans []*string
}

// AcknowledgeOfferNotificationProperties - Notification update request payload
type AcknowledgeOfferNotificationProperties struct {
	// Notification update request payload details
	Properties *AcknowledgeOfferNotificationDetails
}

// AdminRequestApprovalProperties - Admin approval request resource properties
type AdminRequestApprovalProperties struct {
	// Gets or sets admin action
	AdminAction *AdminAction

	// Gets or sets admin details
	Administrator *string

	// Gets or sets Approved plans ids, empty in case of rejected
	ApprovedPlans []*string

	// Gets or sets list of associated collection ids
	CollectionIDs []*string

	// Gets or sets admin comment
	Comment *string

	// Gets or sets offer Id
	OfferID *string

	// Gets or sets publisher Id
	PublisherID *string

	// READ-ONLY; Gets display name
	DisplayName *string

	// READ-ONLY; Gets list of plans with requesters details
	Plans []*PlanRequesterDetails
}

// AdminRequestApprovalsList - List of admin request approval resources
type AdminRequestApprovalsList struct {
	Value []*AdminRequestApprovalsResource

	// READ-ONLY; URL to get the next set of notifications list results if there are any.
	NextLink *string
}

// AdminRequestApprovalsResource - Admin request approval resource.
type AdminRequestApprovalsResource struct {
	// The privateStore admin Approval request data structure.
	Properties *AdminRequestApprovalProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// BillingAccountsResponse - Billing accounts response object
type BillingAccountsResponse struct {
	// Billing accounts list
	BillingAccounts []*string
}

// BulkCollectionsDetails - Bulk collection details
type BulkCollectionsDetails struct {
	// Action to perform (For example: EnableCollections, DisableCollections)
	Action *string

	// collection ids list that the action is performed on
	CollectionIDs []*string
}

// BulkCollectionsPayload - Bulk collections action properties
type BulkCollectionsPayload struct {
	// bulk collections properties details
	Properties *BulkCollectionsDetails
}

// BulkCollectionsResponse - The bulk collections response. The response contains two lists that indicate for each collection
// whether the operation succeeded or failed
type BulkCollectionsResponse struct {
	// Failed collections
	Failed []*CollectionsDetails

	// Succeeded collections
	Succeeded []*CollectionsDetails
}

// Collection - The Collection data structure.
type Collection struct {
	// The collection data structure.
	Properties *CollectionProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// CollectionProperties - The collection details
type CollectionProperties struct {
	// Indicating whether all subscriptions are selected (=true) or not (=false).
	AllSubscriptions *bool

	// Gets or sets the association with Commercial's Billing Account.
	Claim *string

	// Gets or sets collection name.
	CollectionName *string

	// Indicating whether the collection is enabled or disabled.
	Enabled *bool

	// Gets or sets subscription ids list. Empty list indicates all subscriptions are selected, null indicates no update is done,
	// explicit list indicates the explicit selected subscriptions. On insert, null
	// is considered as bad request
	SubscriptionsList []*string

	// READ-ONLY; Gets collection Id.
	CollectionID *string

	// READ-ONLY; Gets the number of offers associated with the collection.
	NumberOfOffers *int64
}

// CollectionsDetails - Collection name and id.
type CollectionsDetails struct {
	// Collection id.
	CollectionID *string

	// Collection name.
	CollectionName *string
}

type CollectionsList struct {
	// URL to get the next set of offer list results if there are any.
	NextLink *string
	Value    []*Collection
}

// CollectionsSubscriptionsMappingDetails - Collection name and related subscriptions list
type CollectionsSubscriptionsMappingDetails struct {
	// Collection name
	CollectionName *string

	// Subscriptions ids list
	Subscriptions []*string
}

// CollectionsToSubscriptionsMappingPayload - The subscriptions list to get the related collections
type CollectionsToSubscriptionsMappingPayload struct {
	// Subscriptions ids list
	Properties *CollectionsToSubscriptionsMappingProperties
}

// CollectionsToSubscriptionsMappingProperties - The subscriptions list to get the related collections
type CollectionsToSubscriptionsMappingProperties struct {
	// Subscriptions ids list
	SubscriptionIDs []*string
}

// CollectionsToSubscriptionsMappingResponse - A map of collections subscriptions details
type CollectionsToSubscriptionsMappingResponse struct {
	// The map of collections subscriptions
	Details map[string]*CollectionsSubscriptionsMappingDetails
}

// ErrorResponse - Error response indicates Microsoft.Marketplace service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// The details of the error.
	Error *ErrorResponseError
}

// ErrorResponseError - The details of the error.
type ErrorResponseError struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string
}

// NewNotifications - New plans notification details
type NewNotifications struct {
	// Gets offer display name
	DisplayName *string

	// Gets or sets the icon url
	Icon *string

	// Gets a value indicating whether future plans is enabled.
	IsFuturePlansEnabled *bool

	// Gets or sets the notification message id
	MessageCode *int64

	// Gets offer id
	OfferID *string

	// Gets or sets removed plans notifications
	Plans []*PlanNotificationDetails
}

// NewPlansNotificationsList - List of all new plans notifications for public offers
type NewPlansNotificationsList struct {
	NewPlansNotifications []*NewNotifications
}

// NotificationsSettingsProperties - Describes the json payload for notifications settings
type NotificationsSettingsProperties struct {
	// Gets or sets list of notified recipients for new requests
	Recipients []*Recipient

	// Gets or sets whether to send email to all marketplace admins for new requests
	SendToAllMarketplaceAdmins *bool
}

// Offer - The privateStore offer data structure.
type Offer struct {
	// The privateStore offer data structure.
	Properties *OfferProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

type OfferListResponse struct {
	// URL to get the next set of offer list results if there are any.
	NextLink *string
	Value    []*Offer
}

type OfferProperties struct {
	// Identifier for purposes of race condition
	ETag *string

	// Icon File Uris
	IconFileUris map[string]*string

	// Offer plans
	Plans []*Plan

	// Plan ids limitation for this offer
	SpecificPlanIDsLimitation []*string

	// Indicating whether the offer was not updated to db (true = not updated). If the allow list is identical to the existed
	// one in db, the offer would not be updated.
	UpdateSuppressedDueIdempotence *bool

	// READ-ONLY; Private store offer creation date
	CreatedAt *string

	// READ-ONLY; Private store offer modification date
	ModifiedAt *string

	// READ-ONLY; It will be displayed prominently in the marketplace
	OfferDisplayName *string

	// READ-ONLY; Private store unique id
	PrivateStoreID *string

	// READ-ONLY; Publisher name that will be displayed prominently in the marketplace
	PublisherDisplayName *string

	// READ-ONLY; Offers unique id
	UniqueOfferID *string
}

// OperationListResult - Result of the request to list Marketplace operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationListResult struct {
	// List of Microsoft.Marketplace operations supported by the Microsoft.Marketplace resource provider.
	Value []*SingleOperation

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string
}

type Plan struct {
	// Plan accessibility
	Accessibility *Accessibility

	// READ-ONLY; Alternative stack type
	AltStackReference *string

	// READ-ONLY; Friendly name for the plan for display in the marketplace
	PlanDisplayName *string

	// READ-ONLY; Text identifier for this plan
	PlanID *string

	// READ-ONLY; Identifier for this plan
	SKUID *string

	// READ-ONLY; Stack type (classic or arm)
	StackType *string
}

// PlanDetails - Return plan with request details
type PlanDetails struct {
	// Gets or sets user's justification for the plan's request
	Justification *string

	// Gets or sets Plan Id
	PlanID *string

	// Gets or sets the subscription id that the user is requesting to add the plan to
	SubscriptionID *string

	// Gets or sets the subscription name that the user is requesting to add the plan to
	SubscriptionName *string

	// READ-ONLY; Gets request date
	RequestDate any

	// READ-ONLY; Gets the plan status
	Status *Status
}

// PlanNotificationDetails - Plan notification details
type PlanNotificationDetails struct {
	// Gets or sets the plan display name
	PlanDisplayName *string

	// Gets or sets the plan id
	PlanID *string
}

// PlanRequesterDetails - Plan with requesters details
type PlanRequesterDetails struct {
	// READ-ONLY; Gets the plan display name
	PlanDisplayName *string

	// READ-ONLY; Gets the plan id
	PlanID *string

	// READ-ONLY; Gets requesters details list
	Requesters []*UserRequestDetails
}

// PrivateStore - The PrivateStore data structure.
type PrivateStore struct {
	// The PrivateStore data structure.
	Properties *PrivateStoreProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// PrivateStoreList - Describes the json payload for the list of available private stores (between zero and one, inclusive)
type PrivateStoreList struct {
	// URL to get the next set of PrivateStore list results if there are any.
	NextLink *string
	Value    []*PrivateStore
}

// PrivateStoreNotificationsState - Get private store notifications state
type PrivateStoreNotificationsState struct {
	ApprovalRequests      []*RequestApprovalsDetails
	NewNotifications      []*NewNotifications
	StopSellNotifications []*StopSellNotifications
}

// PrivateStoreProperties - Describes the json payload on whether or not the private store is enabled for a given tenant
type PrivateStoreProperties struct {
	// Indicates private store availability
	Availability *Availability

	// Gets or sets list of branding characteristics
	Branding map[string]*string

	// Identifier for purposes of race condition
	ETag *string

	// Is government
	IsGov *bool

	// Gets or sets notifications settings
	NotificationsSettings *NotificationsSettingsProperties

	// Private Store Name
	PrivateStoreName *string

	// Tenant id
	TenantID *string

	// READ-ONLY; Gets list of associated collection ids
	CollectionIDs []*string

	// READ-ONLY; Private Store id
	PrivateStoreID *string
}

// QueryApprovedPlans - Query approved plans details
type QueryApprovedPlans struct {
	// Offer id
	OfferID *string

	// Offer plan ids
	PlanIDs []*string
}

// QueryApprovedPlansDetails - Query approved plans response
type QueryApprovedPlansDetails struct {
	// Indicates whether all subscriptions are approved for this plan
	AllSubscriptions *bool

	// Plan id
	PlanID *string

	// Approved subscription ids list. In case all subscriptions are approved for a plan, allSubscriptions flag is true and list
	// is empty ( else flag is set to false). In case both subscriptions list is
	// empty and allSubscriptions flag is false, the plan is not approved for any subscription.
	SubscriptionIDs []*string
}

// QueryApprovedPlansPayload - Query approved plans payload
type QueryApprovedPlansPayload struct {
	// Query approved plans details
	Properties *QueryApprovedPlans
}

// QueryApprovedPlansResponse - Query approved plans response
type QueryApprovedPlansResponse struct {
	// A list indicating for each plan which subscriptions are approved. Plan Id is unique
	Details []*QueryApprovedPlansDetails
}

// QueryOffers - List of offers
type QueryOffers struct {
	// URL to get the next set of PrivateStore list results if there are any.
	NextLink *string
	Value    []*OfferProperties
}

// QueryRequestApproval - Gets the request plans with indication on each plan whether is approved by the admin, has pending
// request or not requested yet
type QueryRequestApproval struct {
	// Gets or sets e-tag field
	Etag *string

	// Gets or sets the notification message id
	MessageCode *int64

	// Gets or sets the plans details
	PlansDetails map[string]*PlanDetails

	// Gets or sets unique offer id.
	UniqueOfferID *string
}

// QueryRequestApprovalProperties - The details to get the request plans statuses
type QueryRequestApprovalProperties struct {
	// The details to get the request plans statuses
	Properties *RequestDetails
}

// Recipient - Describes the json payload for a notified recipient for new requests
type Recipient struct {
	// Principal ID
	PrincipalID *string

	// READ-ONLY; Display Name
	DisplayName *string

	// READ-ONLY; Email Address
	EmailAddress *string
}

// RequestApprovalProperties - Approval request resource properties
type RequestApprovalProperties struct {
	// Gets or sets the request approval message code
	MessageCode *int64

	// Gets or sets unique offer id.
	OfferID *string

	// Gets or sets the plans details
	PlansDetails []*PlanDetails

	// The offer's publisher id
	PublisherID *string

	// READ-ONLY; Gets a value indicating whether the request is closed
	IsClosed *bool

	// READ-ONLY; Gets offer display name
	OfferDisplayName *string
}

// RequestApprovalResource - Request approval resource.
type RequestApprovalResource struct {
	// The privateStore approval request data structure.
	Properties *RequestApprovalProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// RequestApprovalsDetails - Request approvals details
type RequestApprovalsDetails struct {
	// Gets offer display name
	DisplayName *string

	// Gets or sets the icon url
	Icon *string

	// Gets or sets the notification message id
	MessageCode *int64

	// Gets offer id
	OfferID *string

	// Gets or sets removed plans notifications
	Plans []*PlanNotificationDetails

	// Gets or sets publisher id
	PublisherID *string
}

// RequestApprovalsList - List of admin request approval resources
type RequestApprovalsList struct {
	Value []*RequestApprovalResource

	// READ-ONLY; URL to get the next set of notifications list results if there are any.
	NextLink *string
}

// RequestDetails - Request details needed to get the plans statuses
type RequestDetails struct {
	// Current plans list
	PlanIDs []*string

	// The offer's publisher id
	PublisherID *string

	// Gets or sets the subscription id
	SubscriptionID *string
}

// Resource - An Azure resource.
type Resource struct {
	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// SingleOperation - Microsoft.Marketplace REST API operation
type SingleOperation struct {
	// The object that represents the operation.
	Display *SingleOperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Operation name: {provider}/{resource}/{operation}
	Name *string

	// Origin of the operation
	Origin *string

	// Properties of the operation
	Properties any
}

// SingleOperationDisplay - The object that represents the operation.
type SingleOperationDisplay struct {
	// READ-ONLY; Friendly description for the operation,
	Description *string

	// READ-ONLY; Operation type
	Operation *string

	// READ-ONLY; Service provider: Microsoft.Marketplace
	Provider *string

	// READ-ONLY; Resource on which the operation is performed
	Resource *string
}

// StopSellNotifications - Stop sell notification details
type StopSellNotifications struct {
	// Gets offer display name
	DisplayName *string

	// Gets or sets the icon url
	Icon *string

	// Gets a value indicating whether entire offer is in stop sell or only few of its plans
	IsEntire *bool

	// Gets or sets the notification message id
	MessageCode *int64

	// Gets offer id
	OfferID *string

	// Gets or sets removed plans notifications
	Plans []*PlanNotificationDetails
}

// StopSellOffersPlansNotificationsList - List of stop sell offers and plans notifications.
type StopSellOffersPlansNotificationsList struct {
	StopSellNotifications []*StopSellOffersPlansNotificationsListProperties
}

// StopSellOffersPlansNotificationsListProperties - List of stop sell offers and plans notifications.
type StopSellOffersPlansNotificationsListProperties struct {
	// READ-ONLY; The offer display name
	DisplayName *string

	// READ-ONLY; The icon url
	Icon *string

	// READ-ONLY; A value indicating whether entire offer is in stop sell or only few of its plans
	IsEntire *bool

	// READ-ONLY; The notification message code
	MessageCode *int64

	// READ-ONLY; The offer id
	OfferID *string

	// READ-ONLY; The list of removed plans notifications
	Plans []*PlanNotificationDetails

	// READ-ONLY; True if the offer has public plans
	PublicContext *bool

	// READ-ONLY; The subscriptions related to private plans
	SubscriptionsIDs []*string
}

// StopSellSubscriptions - Private plans subscriptions
type StopSellSubscriptions struct {
	Subscriptions []*string
}

// Subscription information.
type Subscription struct {
	// READ-ONLY; The subscription display name.
	DisplayName *string

	// READ-ONLY; The fully qualified ID for the subscription. For example, /subscriptions/00000000-0000-0000-0000-000000000000.
	ID *string

	// READ-ONLY; The subscription state. Possible values are Enabled, Warned, PastDue, Disabled, and Deleted.
	State *SubscriptionState

	// READ-ONLY; The subscription ID.
	SubscriptionID *string
}

// SubscriptionsContextList - List of subscription Ids in the private store
type SubscriptionsContextList struct {
	SubscriptionsIDs []*string
}

// SubscriptionsResponse - Subscription list operation response.
type SubscriptionsResponse struct {
	// READ-ONLY; Number of subscriptions on the page
	Count *int64

	// READ-ONLY; The skip token to retrieve the next page.
	SkipToken *string

	// READ-ONLY; An array of subscriptions.
	Value []*Subscription
}

// SystemData - Read only system data
type SystemData struct {
	// The timestamp of resource creation (UTC)
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource
	CreatedByType *IdentityType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource
	LastModifiedByType *IdentityType
}

// TransferOffersDetails - Transfer offers response details
type TransferOffersDetails struct {
	// Offers ids list to transfer from source collection to target collection(s)
	OfferIDsList []*string

	// Operation to perform (For example: Copy or Move)
	Operation *string

	// Target collections ids
	TargetCollections []*string
}

// TransferOffersProperties - Transfer offers properties
type TransferOffersProperties struct {
	// transfer offers properties details
	Properties *TransferOffersDetails
}

// TransferOffersResponse - The transfer items response. The response contains two lists that indicate for each collection
// whether the operation succeeded or failed
type TransferOffersResponse struct {
	// Failed collections
	Failed []*CollectionsDetails

	// Succeeded collections
	Succeeded []*CollectionsDetails
}

// UserRequestDetails - user request details
type UserRequestDetails struct {
	// Gets the subscription id that the user is requesting to add the plan to
	SubscriptionID *string

	// Gets the subscription name that the user is requesting to add the plan to
	SubscriptionName *string

	// READ-ONLY; Gets request date
	Date *string

	// READ-ONLY; Gets justification
	Justification *string

	// READ-ONLY; Gets user id
	User *string
}

// WithdrawDetails - Withdraw properties details
type WithdrawDetails struct {
	// Gets or sets Plan Id
	PlanID *string

	// The offer's publisher id
	PublisherID *string
}

// WithdrawProperties - Withdraw properties
type WithdrawProperties struct {
	// Withdraw properties details
	Properties *WithdrawDetails
}
