//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmediaservices_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/assets-list-in-date-range.json
func ExampleAssetsClient_NewListPager_listAssetCreatedInADateRange() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAssetsClient().NewListPager("contoso", "contosomedia", &armmediaservices.AssetsClientListOptions{Filter: to.Ptr("properties/created gt 2012-06-01 and properties/created lt 2013-07-01"),
		Top:     nil,
		Orderby: to.Ptr("properties/created"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AssetCollection = armmediaservices.AssetCollection{
		// 	Value: []*armmediaservices.Asset{
		// 		{
		// 			Name: to.Ptr("ClimbingMountRainier"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainier"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Mount Rainier"),
		// 				AlternateID: to.Ptr("CLIMB00001"),
		// 				AssetID: to.Ptr("f8eea45c-b814-44c2-9c42-a5174ebdee4c"),
		// 				Container: to.Ptr("asset-f8eea45c-b814-44c2-9c42-a5174ebdee4c"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountAdams"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountAdams"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Mount Adams"),
		// 				AlternateID: to.Ptr("CLIMB00002"),
		// 				AssetID: to.Ptr("1b648c1a-2268-461d-a1da-742bde23db40"),
		// 				Container: to.Ptr("asset-1b648c1a-2268-461d-a1da-742bde23db40"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-02-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountSaintHelens"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountSaintHelens"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Saint Helens"),
		// 				AlternateID: to.Ptr("CLIMB00005"),
		// 				AssetID: to.Ptr("14d58c40-ec1f-446c-b041-f5cff949bd1d"),
		// 				Container: to.Ptr("asset-14d58c40-ec1f-446c-b041-f5cff949bd1d"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-03-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-04-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatMediaStorageClientEncryption),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/assets-list-by-date.json
func ExampleAssetsClient_NewListPager_listAssetOrderedByDate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAssetsClient().NewListPager("contoso", "contosomedia", &armmediaservices.AssetsClientListOptions{Filter: nil,
		Top:     nil,
		Orderby: to.Ptr("properties/created"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AssetCollection = armmediaservices.AssetCollection{
		// 	Value: []*armmediaservices.Asset{
		// 		{
		// 			Name: to.Ptr("ClimbingMountBaker"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountBaker"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Mount Baker"),
		// 				AlternateID: to.Ptr("CLIMB00004"),
		// 				AssetID: to.Ptr("89af1750-e681-4fbe-8c4c-9a5567867a6b"),
		// 				Container: to.Ptr("asset-89af1750-e681-4fbe-8c4c-9a5567867a6b"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2011-02-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingLittleTahoma"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingLittleTahoma"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Little Tahoma"),
		// 				AlternateID: to.Ptr("CLIMB00003"),
		// 				AssetID: to.Ptr("e6c7ee55-d1f5-48bc-9c36-2d2157aadbbe"),
		// 				Container: to.Ptr("asset-e6c7ee55-d1f5-48bc-9c36-2d2157aadbbe"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-04-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountRainier"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainier"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Mount Rainier"),
		// 				AlternateID: to.Ptr("CLIMB00001"),
		// 				AssetID: to.Ptr("f8eea45c-b814-44c2-9c42-a5174ebdee4c"),
		// 				Container: to.Ptr("asset-f8eea45c-b814-44c2-9c42-a5174ebdee4c"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountAdams"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountAdams"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Mount Adams"),
		// 				AlternateID: to.Ptr("CLIMB00002"),
		// 				AssetID: to.Ptr("1b648c1a-2268-461d-a1da-742bde23db40"),
		// 				Container: to.Ptr("asset-1b648c1a-2268-461d-a1da-742bde23db40"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-02-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountSaintHelens"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountSaintHelens"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Saint Helens"),
		// 				AlternateID: to.Ptr("CLIMB00005"),
		// 				AssetID: to.Ptr("14d58c40-ec1f-446c-b041-f5cff949bd1d"),
		// 				Container: to.Ptr("asset-14d58c40-ec1f-446c-b041-f5cff949bd1d"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-03-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-04-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatMediaStorageClientEncryption),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountRainer"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainer"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("descClimbingMountRainer"),
		// 				AlternateID: to.Ptr("altClimbingMountRainer"),
		// 				AssetID: to.Ptr("8cdacfe5-8473-413a-9aec-dd2a478b37c8"),
		// 				Container: to.Ptr("testasset0"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:25.051Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T21:29:25.051Z"); return t}()),
		// 				StorageAccountName: to.Ptr("storage0"),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/assets-list-all.json
func ExampleAssetsClient_NewListPager_listAllAssets() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAssetsClient().NewListPager("contoso", "contosomedia", &armmediaservices.AssetsClientListOptions{Filter: nil,
		Top:     nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AssetCollection = armmediaservices.AssetCollection{
		// 	Value: []*armmediaservices.Asset{
		// 		{
		// 			Name: to.Ptr("ClimbingLittleTahoma"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingLittleTahoma"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Little Tahoma"),
		// 				AlternateID: to.Ptr("CLIMB00003"),
		// 				AssetID: to.Ptr("e6c7ee55-d1f5-48bc-9c36-2d2157aadbbe"),
		// 				Container: to.Ptr("asset-e6c7ee55-d1f5-48bc-9c36-2d2157aadbbe"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-04-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountAdams"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountAdams"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Mount Adams"),
		// 				AlternateID: to.Ptr("CLIMB00002"),
		// 				AssetID: to.Ptr("1b648c1a-2268-461d-a1da-742bde23db40"),
		// 				Container: to.Ptr("asset-1b648c1a-2268-461d-a1da-742bde23db40"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-02-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountBaker"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountBaker"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Mount Baker"),
		// 				AlternateID: to.Ptr("CLIMB00004"),
		// 				AssetID: to.Ptr("89af1750-e681-4fbe-8c4c-9a5567867a6b"),
		// 				Container: to.Ptr("asset-89af1750-e681-4fbe-8c4c-9a5567867a6b"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2011-02-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountRainer"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainer"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("descClimbingMountRainer"),
		// 				AlternateID: to.Ptr("altClimbingMountRainer"),
		// 				AssetID: to.Ptr("258878ef-fe05-4518-988f-052e86dc19f6"),
		// 				Container: to.Ptr("testasset0"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:24.394Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T21:29:24.394Z"); return t}()),
		// 				StorageAccountName: to.Ptr("storage0"),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountRainier"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainier"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Mount Rainier"),
		// 				AlternateID: to.Ptr("CLIMB00001"),
		// 				AssetID: to.Ptr("f8eea45c-b814-44c2-9c42-a5174ebdee4c"),
		// 				Container: to.Ptr("asset-f8eea45c-b814-44c2-9c42-a5174ebdee4c"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ClimbingMountSaintHelens"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountSaintHelens"),
		// 			Properties: &armmediaservices.AssetProperties{
		// 				Description: to.Ptr("A documentary showing the ascent of Saint Helens"),
		// 				AlternateID: to.Ptr("CLIMB00005"),
		// 				AssetID: to.Ptr("14d58c40-ec1f-446c-b041-f5cff949bd1d"),
		// 				Container: to.Ptr("asset-14d58c40-ec1f-446c-b041-f5cff949bd1d"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-03-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-04-01T00:00:00.000Z"); return t}()),
		// 				StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatMediaStorageClientEncryption),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/assets-get-by-name.json
func ExampleAssetsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssetsClient().Get(ctx, "contoso", "contosomedia", "ClimbingMountAdams", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Asset = armmediaservices.Asset{
	// 	Name: to.Ptr("ClimbingMountAdams"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountAdams"),
	// 	Properties: &armmediaservices.AssetProperties{
	// 		Description: to.Ptr("A documentary showing the ascent of Mount Adams"),
	// 		AlternateID: to.Ptr("CLIMB00002"),
	// 		AssetID: to.Ptr("1b648c1a-2268-461d-a1da-742bde23db40"),
	// 		Container: to.Ptr("asset-1b648c1a-2268-461d-a1da-742bde23db40"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-02-01T00:00:00.000Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-01T00:00:00.000Z"); return t}()),
	// 		StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/assets-create.json
func ExampleAssetsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssetsClient().CreateOrUpdate(ctx, "contoso", "contosomedia", "ClimbingMountLogan", armmediaservices.Asset{
		Properties: &armmediaservices.AssetProperties{
			Description:        to.Ptr("A documentary showing the ascent of Mount Logan"),
			StorageAccountName: to.Ptr("storage0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Asset = armmediaservices.Asset{
	// 	Name: to.Ptr("ClimbingMountLogan"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountLogan"),
	// 	Properties: &armmediaservices.AssetProperties{
	// 		Description: to.Ptr("A documentary showing the ascent of Mount Logan"),
	// 		AssetID: to.Ptr("09194258-36ba-4403-abb3-68780e6bc545"),
	// 		Container: to.Ptr("asset-09194258-36ba-4403-abb3-68780e6bc545"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:26.080Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:26.107Z"); return t}()),
	// 		StorageAccountName: to.Ptr("storage0"),
	// 		StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/assets-delete.json
func ExampleAssetsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAssetsClient().Delete(ctx, "contoso", "contosomedia", "ClimbingMountAdams", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/assets-update.json
func ExampleAssetsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssetsClient().Update(ctx, "contoso", "contosomedia", "ClimbingMountBaker", armmediaservices.Asset{
		Properties: &armmediaservices.AssetProperties{
			Description: to.Ptr("A documentary showing the ascent of Mount Baker in HD"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Asset = armmediaservices.Asset{
	// 	Name: to.Ptr("ClimbingMountBaker"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/assets"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountBaker"),
	// 	Properties: &armmediaservices.AssetProperties{
	// 		Description: to.Ptr("A documentary showing the ascent of Mount Baker in HD"),
	// 		AlternateID: to.Ptr("CLIMB00004"),
	// 		AssetID: to.Ptr("89af1750-e681-4fbe-8c4c-9a5567867a6b"),
	// 		Container: to.Ptr("asset-89af1750-e681-4fbe-8c4c-9a5567867a6b"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2011-02-01T00:00:00.000Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:26.503Z"); return t}()),
	// 		StorageEncryptionFormat: to.Ptr(armmediaservices.AssetStorageEncryptionFormatNone),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/assets-list-sas-urls.json
func ExampleAssetsClient_ListContainerSas() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssetsClient().ListContainerSas(ctx, "contoso", "contosomedia", "ClimbingMountBaker", armmediaservices.ListContainerSasInput{
		ExpiryTime:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T10:00:00.007Z"); return t }()),
		Permissions: to.Ptr(armmediaservices.AssetContainerPermissionReadWrite),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AssetContainerSas = armmediaservices.AssetContainerSas{
	// 	AssetContainerSasUrls: []*string{
	// 		to.Ptr("https://storage0.blob.core.windows.net/asset-89af1750-e681-4fbe-8c4c-9a5567867a6b?sr=b&sig=<secret-value-from-key-1>&se=2018-01-01T10:00:00Z&sp=lrw"),
	// 		to.Ptr("https://storage0.blob.core.windows.net/asset-89af1750-e681-4fbe-8c4c-9a5567867a6b?sr=b&sig=<secret-value-from-key-2>&se=2018-01-01T10:00:00Z&sp=lrw")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/assets-get-encryption-keys.json
func ExampleAssetsClient_GetEncryptionKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssetsClient().GetEncryptionKey(ctx, "contoso", "contosomedia", "ClimbingMountSaintHelens", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StorageEncryptedAssetDecryptionData = armmediaservices.StorageEncryptedAssetDecryptionData{
	// 	AssetFileEncryptionMetadata: []*armmediaservices.AssetFileEncryptionMetadata{
	// 		{
	// 			AssetFileID: to.Ptr("a9536fa7-bd5d-4f84-a137-d1290982fe95"),
	// 			AssetFileName: to.Ptr("AssetFile0"),
	// 			InitializationVector: to.Ptr("-988929866"),
	// 		},
	// 		{
	// 			AssetFileID: to.Ptr("f4060046-94ac-422d-824c-3f1d6aa3ecf2"),
	// 			AssetFileName: to.Ptr("AssetFile1"),
	// 			InitializationVector: to.Ptr("1604993689"),
	// 		},
	// 		{
	// 			AssetFileID: to.Ptr("485968d3-ddae-4b13-98e7-901201a9620b"),
	// 			AssetFileName: to.Ptr("AssetFile2"),
	// 			InitializationVector: to.Ptr("100082635"),
	// 	}},
	// 	Key: []byte("AAAAAAAAAAAAAAAAAAAAAA=="),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/assets-list-streaming-locators.json
func ExampleAssetsClient_ListStreamingLocators() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssetsClient().ListStreamingLocators(ctx, "contoso", "contosomedia", "ClimbingMountSaintHelens", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListStreamingLocatorsResponse = armmediaservices.ListStreamingLocatorsResponse{
	// 	StreamingLocators: []*armmediaservices.AssetStreamingLocator{
	// 		{
	// 			Name: to.Ptr("secureStreamingLocator"),
	// 			AssetName: to.Ptr("ClimbingMountSaintHelens"),
	// 			Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:26.972Z"); return t}()),
	// 			EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "9999-12-31T23:59:59.999Z"); return t}()),
	// 			StreamingLocatorID: to.Ptr("36b74ce3-20b4-4de0-84f1-97e9138e886c"),
	// 			StreamingPolicyName: to.Ptr("secureStreamingPolicy"),
	// 		},
	// 		{
	// 			Name: to.Ptr("clearStreamingLocator"),
	// 			AssetName: to.Ptr("ClimbingMountSaintHelens"),
	// 			Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:26.948Z"); return t}()),
	// 			EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "9999-12-31T23:59:59.999Z"); return t}()),
	// 			StreamingLocatorID: to.Ptr("3e8d9ac3-50f6-4f6d-8482-078ceb56f23a"),
	// 			StreamingPolicyName: to.Ptr("clearStreamingPolicy"),
	// 	}},
	// }
}
