//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
	"net/http"
	"net/url"
	"regexp"
)

// AvailableServiceTiersServer is a fake server for instances of the armoperationalinsights.AvailableServiceTiersClient type.
type AvailableServiceTiersServer struct {
	// ListByWorkspace is the fake for method AvailableServiceTiersClient.ListByWorkspace
	// HTTP status codes to indicate success: http.StatusOK
	ListByWorkspace func(ctx context.Context, resourceGroupName string, workspaceName string, options *armoperationalinsights.AvailableServiceTiersClientListByWorkspaceOptions) (resp azfake.Responder[armoperationalinsights.AvailableServiceTiersClientListByWorkspaceResponse], errResp azfake.ErrorResponder)
}

// NewAvailableServiceTiersServerTransport creates a new instance of AvailableServiceTiersServerTransport with the provided implementation.
// The returned AvailableServiceTiersServerTransport instance is connected to an instance of armoperationalinsights.AvailableServiceTiersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAvailableServiceTiersServerTransport(srv *AvailableServiceTiersServer) *AvailableServiceTiersServerTransport {
	return &AvailableServiceTiersServerTransport{srv: srv}
}

// AvailableServiceTiersServerTransport connects instances of armoperationalinsights.AvailableServiceTiersClient to instances of AvailableServiceTiersServer.
// Don't use this type directly, use NewAvailableServiceTiersServerTransport instead.
type AvailableServiceTiersServerTransport struct {
	srv *AvailableServiceTiersServer
}

// Do implements the policy.Transporter interface for AvailableServiceTiersServerTransport.
func (a *AvailableServiceTiersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AvailableServiceTiersClient.ListByWorkspace":
		resp, err = a.dispatchListByWorkspace(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AvailableServiceTiersServerTransport) dispatchListByWorkspace(req *http.Request) (*http.Response, error) {
	if a.srv.ListByWorkspace == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByWorkspace not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/availableServiceTiers`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListByWorkspace(req.Context(), resourceGroupNameParam, workspaceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AvailableServiceTierArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
