//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpanngfw

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// GlobalRulestackClient contains the methods for the GlobalRulestack group.
// Don't use this type directly, use NewGlobalRulestackClient() instead.
type GlobalRulestackClient struct {
	internal *arm.Client
}

// NewGlobalRulestackClient creates a new instance of GlobalRulestackClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGlobalRulestackClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*GlobalRulestackClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GlobalRulestackClient{
		internal: cl,
	}
	return client, nil
}

// BeginCommit - Commit rulestack configuration
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientBeginCommitOptions contains the optional parameters for the GlobalRulestackClient.BeginCommit
//     method.
func (client *GlobalRulestackClient) BeginCommit(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientBeginCommitOptions) (*runtime.Poller[GlobalRulestackClientCommitResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.commit(ctx, globalRulestackName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GlobalRulestackClientCommitResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GlobalRulestackClientCommitResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Commit - Commit rulestack configuration
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
func (client *GlobalRulestackClient) commit(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientBeginCommitOptions) (*http.Response, error) {
	var err error
	const operationName = "GlobalRulestackClient.BeginCommit"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.commitCreateRequest(ctx, globalRulestackName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// commitCreateRequest creates the Commit request.
func (client *GlobalRulestackClient) commitCreateRequest(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientBeginCommitOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/commit"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginCreateOrUpdate - Create a GlobalRulestackResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - resource - Resource create parameters.
//   - options - GlobalRulestackClientBeginCreateOrUpdateOptions contains the optional parameters for the GlobalRulestackClient.BeginCreateOrUpdate
//     method.
func (client *GlobalRulestackClient) BeginCreateOrUpdate(ctx context.Context, globalRulestackName string, resource GlobalRulestackResource, options *GlobalRulestackClientBeginCreateOrUpdateOptions) (*runtime.Poller[GlobalRulestackClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, globalRulestackName, resource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GlobalRulestackClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GlobalRulestackClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Create a GlobalRulestackResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
func (client *GlobalRulestackClient) createOrUpdate(ctx context.Context, globalRulestackName string, resource GlobalRulestackResource, options *GlobalRulestackClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "GlobalRulestackClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, globalRulestackName, resource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *GlobalRulestackClient) createOrUpdateCreateRequest(ctx context.Context, globalRulestackName string, resource GlobalRulestackResource, options *GlobalRulestackClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resource); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Delete a GlobalRulestackResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientBeginDeleteOptions contains the optional parameters for the GlobalRulestackClient.BeginDelete
//     method.
func (client *GlobalRulestackClient) BeginDelete(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientBeginDeleteOptions) (*runtime.Poller[GlobalRulestackClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, globalRulestackName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GlobalRulestackClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GlobalRulestackClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete a GlobalRulestackResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
func (client *GlobalRulestackClient) deleteOperation(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "GlobalRulestackClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, globalRulestackName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *GlobalRulestackClient) deleteCreateRequest(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a GlobalRulestackResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientGetOptions contains the optional parameters for the GlobalRulestackClient.Get method.
func (client *GlobalRulestackClient) Get(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientGetOptions) (GlobalRulestackClientGetResponse, error) {
	var err error
	const operationName = "GlobalRulestackClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, globalRulestackName, options)
	if err != nil {
		return GlobalRulestackClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalRulestackClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalRulestackClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *GlobalRulestackClient) getCreateRequest(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *GlobalRulestackClient) getHandleResponse(resp *http.Response) (GlobalRulestackClientGetResponse, error) {
	result := GlobalRulestackClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GlobalRulestackResource); err != nil {
		return GlobalRulestackClientGetResponse{}, err
	}
	return result, nil
}

// GetChangeLog - Get changelog
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientGetChangeLogOptions contains the optional parameters for the GlobalRulestackClient.GetChangeLog
//     method.
func (client *GlobalRulestackClient) GetChangeLog(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientGetChangeLogOptions) (GlobalRulestackClientGetChangeLogResponse, error) {
	var err error
	const operationName = "GlobalRulestackClient.GetChangeLog"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getChangeLogCreateRequest(ctx, globalRulestackName, options)
	if err != nil {
		return GlobalRulestackClientGetChangeLogResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalRulestackClientGetChangeLogResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalRulestackClientGetChangeLogResponse{}, err
	}
	resp, err := client.getChangeLogHandleResponse(httpResp)
	return resp, err
}

// getChangeLogCreateRequest creates the GetChangeLog request.
func (client *GlobalRulestackClient) getChangeLogCreateRequest(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientGetChangeLogOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/getChangeLog"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getChangeLogHandleResponse handles the GetChangeLog response.
func (client *GlobalRulestackClient) getChangeLogHandleResponse(resp *http.Response) (GlobalRulestackClientGetChangeLogResponse, error) {
	result := GlobalRulestackClientGetChangeLogResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Changelog); err != nil {
		return GlobalRulestackClientGetChangeLogResponse{}, err
	}
	return result, nil
}

// NewListPager - List GlobalRulestackResource resources by Tenant
//
// Generated from API version 2023-09-01
//   - options - GlobalRulestackClientListOptions contains the optional parameters for the GlobalRulestackClient.NewListPager
//     method.
func (client *GlobalRulestackClient) NewListPager(options *GlobalRulestackClientListOptions) *runtime.Pager[GlobalRulestackClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[GlobalRulestackClientListResponse]{
		More: func(page GlobalRulestackClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GlobalRulestackClientListResponse) (GlobalRulestackClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GlobalRulestackClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return GlobalRulestackClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *GlobalRulestackClient) listCreateRequest(ctx context.Context, options *GlobalRulestackClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *GlobalRulestackClient) listHandleResponse(resp *http.Response) (GlobalRulestackClientListResponse, error) {
	result := GlobalRulestackClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GlobalRulestackResourceListResult); err != nil {
		return GlobalRulestackClientListResponse{}, err
	}
	return result, nil
}

// ListAdvancedSecurityObjects - Get the list of advanced security objects
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientListAdvancedSecurityObjectsOptions contains the optional parameters for the GlobalRulestackClient.ListAdvancedSecurityObjects
//     method.
func (client *GlobalRulestackClient) ListAdvancedSecurityObjects(ctx context.Context, globalRulestackName string, typeParam AdvSecurityObjectTypeEnum, options *GlobalRulestackClientListAdvancedSecurityObjectsOptions) (GlobalRulestackClientListAdvancedSecurityObjectsResponse, error) {
	var err error
	const operationName = "GlobalRulestackClient.ListAdvancedSecurityObjects"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listAdvancedSecurityObjectsCreateRequest(ctx, globalRulestackName, typeParam, options)
	if err != nil {
		return GlobalRulestackClientListAdvancedSecurityObjectsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalRulestackClientListAdvancedSecurityObjectsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalRulestackClientListAdvancedSecurityObjectsResponse{}, err
	}
	resp, err := client.listAdvancedSecurityObjectsHandleResponse(httpResp)
	return resp, err
}

// listAdvancedSecurityObjectsCreateRequest creates the ListAdvancedSecurityObjects request.
func (client *GlobalRulestackClient) listAdvancedSecurityObjectsCreateRequest(ctx context.Context, globalRulestackName string, typeParam AdvSecurityObjectTypeEnum, options *GlobalRulestackClientListAdvancedSecurityObjectsOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/listAdvancedSecurityObjects"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	if options != nil && options.Skip != nil {
		reqQP.Set("skip", *options.Skip)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("top", strconv.FormatInt(int64(*options.Top), 10))
	}
	reqQP.Set("type", string(typeParam))
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAdvancedSecurityObjectsHandleResponse handles the ListAdvancedSecurityObjects response.
func (client *GlobalRulestackClient) listAdvancedSecurityObjectsHandleResponse(resp *http.Response) (GlobalRulestackClientListAdvancedSecurityObjectsResponse, error) {
	result := GlobalRulestackClientListAdvancedSecurityObjectsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AdvSecurityObjectListResponse); err != nil {
		return GlobalRulestackClientListAdvancedSecurityObjectsResponse{}, err
	}
	return result, nil
}

// ListAppIDs - List of AppIds for GlobalRulestack ApiVersion
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientListAppIDsOptions contains the optional parameters for the GlobalRulestackClient.ListAppIDs
//     method.
func (client *GlobalRulestackClient) ListAppIDs(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientListAppIDsOptions) (GlobalRulestackClientListAppIDsResponse, error) {
	var err error
	const operationName = "GlobalRulestackClient.ListAppIDs"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listAppIDsCreateRequest(ctx, globalRulestackName, options)
	if err != nil {
		return GlobalRulestackClientListAppIDsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalRulestackClientListAppIDsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalRulestackClientListAppIDsResponse{}, err
	}
	resp, err := client.listAppIDsHandleResponse(httpResp)
	return resp, err
}

// listAppIDsCreateRequest creates the ListAppIDs request.
func (client *GlobalRulestackClient) listAppIDsCreateRequest(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientListAppIDsOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/listAppIds"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	if options != nil && options.AppIDVersion != nil {
		reqQP.Set("appIdVersion", *options.AppIDVersion)
	}
	if options != nil && options.AppPrefix != nil {
		reqQP.Set("appPrefix", *options.AppPrefix)
	}
	if options != nil && options.Skip != nil {
		reqQP.Set("skip", *options.Skip)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAppIDsHandleResponse handles the ListAppIDs response.
func (client *GlobalRulestackClient) listAppIDsHandleResponse(resp *http.Response) (GlobalRulestackClientListAppIDsResponse, error) {
	result := GlobalRulestackClientListAppIDsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ListAppIDResponse); err != nil {
		return GlobalRulestackClientListAppIDsResponse{}, err
	}
	return result, nil
}

// ListCountries - List of countries for Rulestack
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientListCountriesOptions contains the optional parameters for the GlobalRulestackClient.ListCountries
//     method.
func (client *GlobalRulestackClient) ListCountries(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientListCountriesOptions) (GlobalRulestackClientListCountriesResponse, error) {
	var err error
	const operationName = "GlobalRulestackClient.ListCountries"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listCountriesCreateRequest(ctx, globalRulestackName, options)
	if err != nil {
		return GlobalRulestackClientListCountriesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalRulestackClientListCountriesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalRulestackClientListCountriesResponse{}, err
	}
	resp, err := client.listCountriesHandleResponse(httpResp)
	return resp, err
}

// listCountriesCreateRequest creates the ListCountries request.
func (client *GlobalRulestackClient) listCountriesCreateRequest(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientListCountriesOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/listCountries"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	if options != nil && options.Skip != nil {
		reqQP.Set("skip", *options.Skip)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCountriesHandleResponse handles the ListCountries response.
func (client *GlobalRulestackClient) listCountriesHandleResponse(resp *http.Response) (GlobalRulestackClientListCountriesResponse, error) {
	result := GlobalRulestackClientListCountriesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CountriesResponse); err != nil {
		return GlobalRulestackClientListCountriesResponse{}, err
	}
	return result, nil
}

// ListFirewalls - List of Firewalls associated with Rulestack
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientListFirewallsOptions contains the optional parameters for the GlobalRulestackClient.ListFirewalls
//     method.
func (client *GlobalRulestackClient) ListFirewalls(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientListFirewallsOptions) (GlobalRulestackClientListFirewallsResponse, error) {
	var err error
	const operationName = "GlobalRulestackClient.ListFirewalls"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listFirewallsCreateRequest(ctx, globalRulestackName, options)
	if err != nil {
		return GlobalRulestackClientListFirewallsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalRulestackClientListFirewallsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalRulestackClientListFirewallsResponse{}, err
	}
	resp, err := client.listFirewallsHandleResponse(httpResp)
	return resp, err
}

// listFirewallsCreateRequest creates the ListFirewalls request.
func (client *GlobalRulestackClient) listFirewallsCreateRequest(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientListFirewallsOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/listFirewalls"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFirewallsHandleResponse handles the ListFirewalls response.
func (client *GlobalRulestackClient) listFirewallsHandleResponse(resp *http.Response) (GlobalRulestackClientListFirewallsResponse, error) {
	result := GlobalRulestackClientListFirewallsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ListFirewallsResponse); err != nil {
		return GlobalRulestackClientListFirewallsResponse{}, err
	}
	return result, nil
}

// ListPredefinedURLCategories - List predefined URL categories for rulestack
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientListPredefinedURLCategoriesOptions contains the optional parameters for the GlobalRulestackClient.ListPredefinedURLCategories
//     method.
func (client *GlobalRulestackClient) ListPredefinedURLCategories(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientListPredefinedURLCategoriesOptions) (GlobalRulestackClientListPredefinedURLCategoriesResponse, error) {
	var err error
	const operationName = "GlobalRulestackClient.ListPredefinedURLCategories"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listPredefinedURLCategoriesCreateRequest(ctx, globalRulestackName, options)
	if err != nil {
		return GlobalRulestackClientListPredefinedURLCategoriesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalRulestackClientListPredefinedURLCategoriesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalRulestackClientListPredefinedURLCategoriesResponse{}, err
	}
	resp, err := client.listPredefinedURLCategoriesHandleResponse(httpResp)
	return resp, err
}

// listPredefinedURLCategoriesCreateRequest creates the ListPredefinedURLCategories request.
func (client *GlobalRulestackClient) listPredefinedURLCategoriesCreateRequest(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientListPredefinedURLCategoriesOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/listPredefinedUrlCategories"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	if options != nil && options.Skip != nil {
		reqQP.Set("skip", *options.Skip)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listPredefinedURLCategoriesHandleResponse handles the ListPredefinedURLCategories response.
func (client *GlobalRulestackClient) listPredefinedURLCategoriesHandleResponse(resp *http.Response) (GlobalRulestackClientListPredefinedURLCategoriesResponse, error) {
	result := GlobalRulestackClientListPredefinedURLCategoriesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PredefinedURLCategoriesResponse); err != nil {
		return GlobalRulestackClientListPredefinedURLCategoriesResponse{}, err
	}
	return result, nil
}

// ListSecurityServices - List the security services for rulestack
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientListSecurityServicesOptions contains the optional parameters for the GlobalRulestackClient.ListSecurityServices
//     method.
func (client *GlobalRulestackClient) ListSecurityServices(ctx context.Context, globalRulestackName string, typeParam SecurityServicesTypeEnum, options *GlobalRulestackClientListSecurityServicesOptions) (GlobalRulestackClientListSecurityServicesResponse, error) {
	var err error
	const operationName = "GlobalRulestackClient.ListSecurityServices"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listSecurityServicesCreateRequest(ctx, globalRulestackName, typeParam, options)
	if err != nil {
		return GlobalRulestackClientListSecurityServicesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalRulestackClientListSecurityServicesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalRulestackClientListSecurityServicesResponse{}, err
	}
	resp, err := client.listSecurityServicesHandleResponse(httpResp)
	return resp, err
}

// listSecurityServicesCreateRequest creates the ListSecurityServices request.
func (client *GlobalRulestackClient) listSecurityServicesCreateRequest(ctx context.Context, globalRulestackName string, typeParam SecurityServicesTypeEnum, options *GlobalRulestackClientListSecurityServicesOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/listSecurityServices"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	if options != nil && options.Skip != nil {
		reqQP.Set("skip", *options.Skip)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("top", strconv.FormatInt(int64(*options.Top), 10))
	}
	reqQP.Set("type", string(typeParam))
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSecurityServicesHandleResponse handles the ListSecurityServices response.
func (client *GlobalRulestackClient) listSecurityServicesHandleResponse(resp *http.Response) (GlobalRulestackClientListSecurityServicesResponse, error) {
	result := GlobalRulestackClientListSecurityServicesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SecurityServicesResponse); err != nil {
		return GlobalRulestackClientListSecurityServicesResponse{}, err
	}
	return result, nil
}

// Revert - Revert rulestack configuration
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - options - GlobalRulestackClientRevertOptions contains the optional parameters for the GlobalRulestackClient.Revert method.
func (client *GlobalRulestackClient) Revert(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientRevertOptions) (GlobalRulestackClientRevertResponse, error) {
	var err error
	const operationName = "GlobalRulestackClient.Revert"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.revertCreateRequest(ctx, globalRulestackName, options)
	if err != nil {
		return GlobalRulestackClientRevertResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalRulestackClientRevertResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return GlobalRulestackClientRevertResponse{}, err
	}
	return GlobalRulestackClientRevertResponse{}, nil
}

// revertCreateRequest creates the Revert request.
func (client *GlobalRulestackClient) revertCreateRequest(ctx context.Context, globalRulestackName string, options *GlobalRulestackClientRevertOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/revert"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Update - Update a GlobalRulestackResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - globalRulestackName - GlobalRulestack resource name
//   - properties - The resource properties to be updated.
//   - options - GlobalRulestackClientUpdateOptions contains the optional parameters for the GlobalRulestackClient.Update method.
func (client *GlobalRulestackClient) Update(ctx context.Context, globalRulestackName string, properties GlobalRulestackResourceUpdate, options *GlobalRulestackClientUpdateOptions) (GlobalRulestackClientUpdateResponse, error) {
	var err error
	const operationName = "GlobalRulestackClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, globalRulestackName, properties, options)
	if err != nil {
		return GlobalRulestackClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalRulestackClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalRulestackClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *GlobalRulestackClient) updateCreateRequest(ctx context.Context, globalRulestackName string, properties GlobalRulestackResourceUpdate, options *GlobalRulestackClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}"
	if globalRulestackName == "" {
		return nil, errors.New("parameter globalRulestackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{globalRulestackName}", url.PathEscape(globalRulestackName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *GlobalRulestackClient) updateHandleResponse(resp *http.Response) (GlobalRulestackClientUpdateResponse, error) {
	result := GlobalRulestackClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GlobalRulestackResource); err != nil {
		return GlobalRulestackClientUpdateResponse{}, err
	}
	return result, nil
}
