//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/policyinsights/armpolicyinsights"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// PolicyTrackedResourcesServer is a fake server for instances of the armpolicyinsights.PolicyTrackedResourcesClient type.
type PolicyTrackedResourcesServer struct {
	// NewListQueryResultsForManagementGroupPager is the fake for method PolicyTrackedResourcesClient.NewListQueryResultsForManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForManagementGroupPager func(managementGroupName string, policyTrackedResourcesResource armpolicyinsights.PolicyTrackedResourcesResourceType, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForManagementGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForManagementGroupResponse])

	// NewListQueryResultsForResourcePager is the fake for method PolicyTrackedResourcesClient.NewListQueryResultsForResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForResourcePager func(resourceID string, policyTrackedResourcesResource armpolicyinsights.PolicyTrackedResourcesResourceType, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForResourceOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForResourceResponse])

	// NewListQueryResultsForResourceGroupPager is the fake for method PolicyTrackedResourcesClient.NewListQueryResultsForResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForResourceGroupPager func(resourceGroupName string, policyTrackedResourcesResource armpolicyinsights.PolicyTrackedResourcesResourceType, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForResourceGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForResourceGroupResponse])

	// NewListQueryResultsForSubscriptionPager is the fake for method PolicyTrackedResourcesClient.NewListQueryResultsForSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForSubscriptionPager func(policyTrackedResourcesResource armpolicyinsights.PolicyTrackedResourcesResourceType, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForSubscriptionOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForSubscriptionResponse])
}

// NewPolicyTrackedResourcesServerTransport creates a new instance of PolicyTrackedResourcesServerTransport with the provided implementation.
// The returned PolicyTrackedResourcesServerTransport instance is connected to an instance of armpolicyinsights.PolicyTrackedResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPolicyTrackedResourcesServerTransport(srv *PolicyTrackedResourcesServer) *PolicyTrackedResourcesServerTransport {
	return &PolicyTrackedResourcesServerTransport{
		srv: srv,
		newListQueryResultsForManagementGroupPager: newTracker[azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForManagementGroupResponse]](),
		newListQueryResultsForResourcePager:        newTracker[azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForResourceResponse]](),
		newListQueryResultsForResourceGroupPager:   newTracker[azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForResourceGroupResponse]](),
		newListQueryResultsForSubscriptionPager:    newTracker[azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForSubscriptionResponse]](),
	}
}

// PolicyTrackedResourcesServerTransport connects instances of armpolicyinsights.PolicyTrackedResourcesClient to instances of PolicyTrackedResourcesServer.
// Don't use this type directly, use NewPolicyTrackedResourcesServerTransport instead.
type PolicyTrackedResourcesServerTransport struct {
	srv                                        *PolicyTrackedResourcesServer
	newListQueryResultsForManagementGroupPager *tracker[azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForManagementGroupResponse]]
	newListQueryResultsForResourcePager        *tracker[azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForResourceResponse]]
	newListQueryResultsForResourceGroupPager   *tracker[azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForResourceGroupResponse]]
	newListQueryResultsForSubscriptionPager    *tracker[azfake.PagerResponder[armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForSubscriptionResponse]]
}

// Do implements the policy.Transporter interface for PolicyTrackedResourcesServerTransport.
func (p *PolicyTrackedResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PolicyTrackedResourcesClient.NewListQueryResultsForManagementGroupPager":
		resp, err = p.dispatchNewListQueryResultsForManagementGroupPager(req)
	case "PolicyTrackedResourcesClient.NewListQueryResultsForResourcePager":
		resp, err = p.dispatchNewListQueryResultsForResourcePager(req)
	case "PolicyTrackedResourcesClient.NewListQueryResultsForResourceGroupPager":
		resp, err = p.dispatchNewListQueryResultsForResourceGroupPager(req)
	case "PolicyTrackedResourcesClient.NewListQueryResultsForSubscriptionPager":
		resp, err = p.dispatchNewListQueryResultsForSubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PolicyTrackedResourcesServerTransport) dispatchNewListQueryResultsForManagementGroupPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForManagementGroupPager not implemented")}
	}
	newListQueryResultsForManagementGroupPager := p.newListQueryResultsForManagementGroupPager.get(req)
	if newListQueryResultsForManagementGroupPager == nil {
		const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyTrackedResources/(?P<policyTrackedResourcesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		managementGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupName")])
		if err != nil {
			return nil, err
		}
		policyTrackedResourcesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyTrackedResourcesResource")], func(v string) (armpolicyinsights.PolicyTrackedResourcesResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyTrackedResourcesResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := p.srv.NewListQueryResultsForManagementGroupPager(managementGroupNameParam, policyTrackedResourcesResourceParam, queryOptions, nil)
		newListQueryResultsForManagementGroupPager = &resp
		p.newListQueryResultsForManagementGroupPager.add(req, newListQueryResultsForManagementGroupPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForManagementGroupPager, req, func(page *armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForManagementGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForManagementGroupPager) {
		p.newListQueryResultsForManagementGroupPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyTrackedResourcesServerTransport) dispatchNewListQueryResultsForResourcePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForResourcePager not implemented")}
	}
	newListQueryResultsForResourcePager := p.newListQueryResultsForResourcePager.get(req)
	if newListQueryResultsForResourcePager == nil {
		const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyTrackedResources/(?P<policyTrackedResourcesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
		if err != nil {
			return nil, err
		}
		policyTrackedResourcesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyTrackedResourcesResource")], func(v string) (armpolicyinsights.PolicyTrackedResourcesResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyTrackedResourcesResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := p.srv.NewListQueryResultsForResourcePager(resourceIDParam, policyTrackedResourcesResourceParam, queryOptions, nil)
		newListQueryResultsForResourcePager = &resp
		p.newListQueryResultsForResourcePager.add(req, newListQueryResultsForResourcePager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForResourcePager, req, func(page *armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForResourcePager) {
		p.newListQueryResultsForResourcePager.remove(req)
	}
	return resp, nil
}

func (p *PolicyTrackedResourcesServerTransport) dispatchNewListQueryResultsForResourceGroupPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForResourceGroupPager not implemented")}
	}
	newListQueryResultsForResourceGroupPager := p.newListQueryResultsForResourceGroupPager.get(req)
	if newListQueryResultsForResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyTrackedResources/(?P<policyTrackedResourcesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		policyTrackedResourcesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyTrackedResourcesResource")], func(v string) (armpolicyinsights.PolicyTrackedResourcesResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyTrackedResourcesResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := p.srv.NewListQueryResultsForResourceGroupPager(resourceGroupNameParam, policyTrackedResourcesResourceParam, queryOptions, nil)
		newListQueryResultsForResourceGroupPager = &resp
		p.newListQueryResultsForResourceGroupPager.add(req, newListQueryResultsForResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForResourceGroupPager, req, func(page *armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForResourceGroupPager) {
		p.newListQueryResultsForResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyTrackedResourcesServerTransport) dispatchNewListQueryResultsForSubscriptionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForSubscriptionPager not implemented")}
	}
	newListQueryResultsForSubscriptionPager := p.newListQueryResultsForSubscriptionPager.get(req)
	if newListQueryResultsForSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyTrackedResources/(?P<policyTrackedResourcesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyTrackedResourcesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyTrackedResourcesResource")], func(v string) (armpolicyinsights.PolicyTrackedResourcesResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyTrackedResourcesResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := p.srv.NewListQueryResultsForSubscriptionPager(policyTrackedResourcesResourceParam, queryOptions, nil)
		newListQueryResultsForSubscriptionPager = &resp
		p.newListQueryResultsForSubscriptionPager.add(req, newListQueryResultsForSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForSubscriptionPager, req, func(page *armpolicyinsights.PolicyTrackedResourcesClientListQueryResultsForSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForSubscriptionPager) {
		p.newListQueryResultsForSubscriptionPager.remove(req)
	}
	return resp, nil
}
