//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armpolicyinsights.ClientFactory type.
type ServerFactory struct {
	AttestationsServer           AttestationsServer
	OperationsServer             OperationsServer
	PolicyEventsServer           PolicyEventsServer
	PolicyMetadataServer         PolicyMetadataServer
	PolicyRestrictionsServer     PolicyRestrictionsServer
	PolicyStatesServer           PolicyStatesServer
	PolicyTrackedResourcesServer PolicyTrackedResourcesServer
	RemediationsServer           RemediationsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armpolicyinsights.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armpolicyinsights.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                            *ServerFactory
	trMu                           sync.Mutex
	trAttestationsServer           *AttestationsServerTransport
	trOperationsServer             *OperationsServerTransport
	trPolicyEventsServer           *PolicyEventsServerTransport
	trPolicyMetadataServer         *PolicyMetadataServerTransport
	trPolicyRestrictionsServer     *PolicyRestrictionsServerTransport
	trPolicyStatesServer           *PolicyStatesServerTransport
	trPolicyTrackedResourcesServer *PolicyTrackedResourcesServerTransport
	trRemediationsServer           *RemediationsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AttestationsClient":
		initServer(s, &s.trAttestationsServer, func() *AttestationsServerTransport { return NewAttestationsServerTransport(&s.srv.AttestationsServer) })
		resp, err = s.trAttestationsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PolicyEventsClient":
		initServer(s, &s.trPolicyEventsServer, func() *PolicyEventsServerTransport { return NewPolicyEventsServerTransport(&s.srv.PolicyEventsServer) })
		resp, err = s.trPolicyEventsServer.Do(req)
	case "PolicyMetadataClient":
		initServer(s, &s.trPolicyMetadataServer, func() *PolicyMetadataServerTransport {
			return NewPolicyMetadataServerTransport(&s.srv.PolicyMetadataServer)
		})
		resp, err = s.trPolicyMetadataServer.Do(req)
	case "PolicyRestrictionsClient":
		initServer(s, &s.trPolicyRestrictionsServer, func() *PolicyRestrictionsServerTransport {
			return NewPolicyRestrictionsServerTransport(&s.srv.PolicyRestrictionsServer)
		})
		resp, err = s.trPolicyRestrictionsServer.Do(req)
	case "PolicyStatesClient":
		initServer(s, &s.trPolicyStatesServer, func() *PolicyStatesServerTransport { return NewPolicyStatesServerTransport(&s.srv.PolicyStatesServer) })
		resp, err = s.trPolicyStatesServer.Do(req)
	case "PolicyTrackedResourcesClient":
		initServer(s, &s.trPolicyTrackedResourcesServer, func() *PolicyTrackedResourcesServerTransport {
			return NewPolicyTrackedResourcesServerTransport(&s.srv.PolicyTrackedResourcesServer)
		})
		resp, err = s.trPolicyTrackedResourcesServer.Do(req)
	case "RemediationsClient":
		initServer(s, &s.trRemediationsServer, func() *RemediationsServerTransport { return NewRemediationsServerTransport(&s.srv.RemediationsServer) })
		resp, err = s.trRemediationsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
