//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/postgresql/armpostgresqlflexibleservers/v4"
	"net/http"
	"net/url"
	"regexp"
)

// PostgreSQLManagementServer is a fake server for instances of the armpostgresqlflexibleservers.PostgreSQLManagementClient type.
type PostgreSQLManagementServer struct {
	// CheckMigrationNameAvailability is the fake for method PostgreSQLManagementClient.CheckMigrationNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckMigrationNameAvailability func(ctx context.Context, subscriptionID string, resourceGroupName string, targetDbServerName string, parameters armpostgresqlflexibleservers.MigrationNameAvailabilityResource, options *armpostgresqlflexibleservers.PostgreSQLManagementClientCheckMigrationNameAvailabilityOptions) (resp azfake.Responder[armpostgresqlflexibleservers.PostgreSQLManagementClientCheckMigrationNameAvailabilityResponse], errResp azfake.ErrorResponder)
}

// NewPostgreSQLManagementServerTransport creates a new instance of PostgreSQLManagementServerTransport with the provided implementation.
// The returned PostgreSQLManagementServerTransport instance is connected to an instance of armpostgresqlflexibleservers.PostgreSQLManagementClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPostgreSQLManagementServerTransport(srv *PostgreSQLManagementServer) *PostgreSQLManagementServerTransport {
	return &PostgreSQLManagementServerTransport{srv: srv}
}

// PostgreSQLManagementServerTransport connects instances of armpostgresqlflexibleservers.PostgreSQLManagementClient to instances of PostgreSQLManagementServer.
// Don't use this type directly, use NewPostgreSQLManagementServerTransport instead.
type PostgreSQLManagementServerTransport struct {
	srv *PostgreSQLManagementServer
}

// Do implements the policy.Transporter interface for PostgreSQLManagementServerTransport.
func (p *PostgreSQLManagementServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PostgreSQLManagementClient.CheckMigrationNameAvailability":
		resp, err = p.dispatchCheckMigrationNameAvailability(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PostgreSQLManagementServerTransport) dispatchCheckMigrationNameAvailability(req *http.Request) (*http.Response, error) {
	if p.srv.CheckMigrationNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckMigrationNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforPostgreSQL/flexibleServers/(?P<targetDbServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkMigrationNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpostgresqlflexibleservers.MigrationNameAvailabilityResource](req)
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	targetDbServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("targetDbServerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.CheckMigrationNameAvailability(req.Context(), subscriptionIDParam, resourceGroupNameParam, targetDbServerNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MigrationNameAvailabilityResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
