//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armrecoveryservicesdatareplication_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservicesdatareplication/armrecoveryservicesdatareplication"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/3066a973f4baf2e2bf072a013b585a820bb10146/specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Fabric_Get.json
func ExampleFabricClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesdatareplication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFabricClient().Get(ctx, "rgrecoveryservicesdatareplication", "wPR", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FabricModel = armrecoveryservicesdatareplication.FabricModel{
	// 	Name: to.Ptr("rhojydcwjgvgexpdwswjib"),
	// 	Type: to.Ptr("toipsryjyqchikyakeiuatshiu"),
	// 	ID: to.Ptr("ycaxtshcmldt"),
	// 	Location: to.Ptr("tqygutlpob"),
	// 	Properties: &armrecoveryservicesdatareplication.FabricModelProperties{
	// 		CustomProperties: &armrecoveryservicesdatareplication.FabricModelCustomProperties{
	// 			InstanceType: to.Ptr("FabricModelCustomProperties"),
	// 		},
	// 		Health: to.Ptr(armrecoveryservicesdatareplication.HealthStatusNormal),
	// 		HealthErrors: []*armrecoveryservicesdatareplication.HealthErrorModel{
	// 			{
	// 				AffectedResourceCorrelationIDs: []*string{
	// 					to.Ptr("fope")},
	// 					AffectedResourceType: to.Ptr("scfniv"),
	// 					Category: to.Ptr("leigw"),
	// 					Causes: to.Ptr("xznphqrrmsdzm"),
	// 					ChildErrors: []*armrecoveryservicesdatareplication.InnerHealthErrorModel{
	// 						{
	// 							Category: to.Ptr("lcsdxrqxquke"),
	// 							Causes: to.Ptr("kefaugkpxjkpulimjthjnl"),
	// 							Code: to.Ptr("yuxxpblihirpedwkigywgwjjrlzq"),
	// 							CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:52.128Z"); return t}()),
	// 							HealthCategory: to.Ptr("mhdgfjqwbikhxmhtomkl"),
	// 							IsCustomerResolvable: to.Ptr(true),
	// 							Message: to.Ptr("sskcei"),
	// 							Recommendation: to.Ptr("kqybwaesqumywtjepi"),
	// 							Severity: to.Ptr("wqxxiuaqjyagq"),
	// 							Source: to.Ptr("wevvftugwydzzw"),
	// 							Summary: to.Ptr("djsmgrltruljo"),
	// 					}},
	// 					Code: to.Ptr("dgxkefzmeukd"),
	// 					CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:52.128Z"); return t}()),
	// 					HealthCategory: to.Ptr("itc"),
	// 					IsCustomerResolvable: to.Ptr(true),
	// 					Message: to.Ptr("lbywtdprdqdekl"),
	// 					Recommendation: to.Ptr("gmssteizlhjtclyeoo"),
	// 					Severity: to.Ptr("vvdajssdcypewdyechilxjmuijvdd"),
	// 					Source: to.Ptr("iy"),
	// 					Summary: to.Ptr("jtooblbvaxxrvcwgscbobq"),
	// 			}},
	// 			ProvisioningState: to.Ptr(armrecoveryservicesdatareplication.ProvisioningStateSucceeded),
	// 			ServiceEndpoint: to.Ptr("ilrfl"),
	// 			ServiceResourceID: to.Ptr("xukigpdrbyyy"),
	// 		},
	// 		SystemData: &armrecoveryservicesdatareplication.FabricModelSystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:53.716Z"); return t}()),
	// 			CreatedBy: to.Ptr("yhdmbqrsgimuucexvpas"),
	// 			CreatedByType: to.Ptr("brnojz"),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:53.716Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("balecqnwu"),
	// 			LastModifiedByType: to.Ptr("ukvqlncihf"),
	// 		},
	// 		Tags: map[string]*string{
	// 			"key3917": to.Ptr("vgralu"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/3066a973f4baf2e2bf072a013b585a820bb10146/specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Fabric_Create.json
func ExampleFabricClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesdatareplication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFabricClient().BeginCreate(ctx, "rgrecoveryservicesdatareplication", "wPR", armrecoveryservicesdatareplication.FabricModel{
		Location: to.Ptr("tqygutlpob"),
		Properties: &armrecoveryservicesdatareplication.FabricModelProperties{
			CustomProperties: &armrecoveryservicesdatareplication.FabricModelCustomProperties{
				InstanceType: to.Ptr("FabricModelCustomProperties"),
			},
		},
		Tags: map[string]*string{
			"key3917": to.Ptr("vgralu"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FabricModel = armrecoveryservicesdatareplication.FabricModel{
	// 	Name: to.Ptr("rhojydcwjgvgexpdwswjib"),
	// 	Type: to.Ptr("toipsryjyqchikyakeiuatshiu"),
	// 	ID: to.Ptr("ycaxtshcmldt"),
	// 	Location: to.Ptr("tqygutlpob"),
	// 	Properties: &armrecoveryservicesdatareplication.FabricModelProperties{
	// 		CustomProperties: &armrecoveryservicesdatareplication.FabricModelCustomProperties{
	// 			InstanceType: to.Ptr("FabricModelCustomProperties"),
	// 		},
	// 		Health: to.Ptr(armrecoveryservicesdatareplication.HealthStatusNormal),
	// 		HealthErrors: []*armrecoveryservicesdatareplication.HealthErrorModel{
	// 			{
	// 				AffectedResourceCorrelationIDs: []*string{
	// 					to.Ptr("fope")},
	// 					AffectedResourceType: to.Ptr("scfniv"),
	// 					Category: to.Ptr("leigw"),
	// 					Causes: to.Ptr("xznphqrrmsdzm"),
	// 					ChildErrors: []*armrecoveryservicesdatareplication.InnerHealthErrorModel{
	// 						{
	// 							Category: to.Ptr("lcsdxrqxquke"),
	// 							Causes: to.Ptr("kefaugkpxjkpulimjthjnl"),
	// 							Code: to.Ptr("yuxxpblihirpedwkigywgwjjrlzq"),
	// 							CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:52.128Z"); return t}()),
	// 							HealthCategory: to.Ptr("mhdgfjqwbikhxmhtomkl"),
	// 							IsCustomerResolvable: to.Ptr(true),
	// 							Message: to.Ptr("sskcei"),
	// 							Recommendation: to.Ptr("kqybwaesqumywtjepi"),
	// 							Severity: to.Ptr("wqxxiuaqjyagq"),
	// 							Source: to.Ptr("wevvftugwydzzw"),
	// 							Summary: to.Ptr("djsmgrltruljo"),
	// 					}},
	// 					Code: to.Ptr("dgxkefzmeukd"),
	// 					CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:52.128Z"); return t}()),
	// 					HealthCategory: to.Ptr("itc"),
	// 					IsCustomerResolvable: to.Ptr(true),
	// 					Message: to.Ptr("lbywtdprdqdekl"),
	// 					Recommendation: to.Ptr("gmssteizlhjtclyeoo"),
	// 					Severity: to.Ptr("vvdajssdcypewdyechilxjmuijvdd"),
	// 					Source: to.Ptr("iy"),
	// 					Summary: to.Ptr("jtooblbvaxxrvcwgscbobq"),
	// 			}},
	// 			ProvisioningState: to.Ptr(armrecoveryservicesdatareplication.ProvisioningStateSucceeded),
	// 			ServiceEndpoint: to.Ptr("ilrfl"),
	// 			ServiceResourceID: to.Ptr("xukigpdrbyyy"),
	// 		},
	// 		SystemData: &armrecoveryservicesdatareplication.FabricModelSystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:53.716Z"); return t}()),
	// 			CreatedBy: to.Ptr("yhdmbqrsgimuucexvpas"),
	// 			CreatedByType: to.Ptr("brnojz"),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:53.716Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("balecqnwu"),
	// 			LastModifiedByType: to.Ptr("ukvqlncihf"),
	// 		},
	// 		Tags: map[string]*string{
	// 			"key3917": to.Ptr("vgralu"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/3066a973f4baf2e2bf072a013b585a820bb10146/specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Fabric_Update.json
func ExampleFabricClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesdatareplication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFabricClient().BeginUpdate(ctx, "rgrecoveryservicesdatareplication", "wPR", armrecoveryservicesdatareplication.FabricModelUpdate{
		Properties: &armrecoveryservicesdatareplication.FabricModelProperties{
			CustomProperties: &armrecoveryservicesdatareplication.FabricModelCustomProperties{
				InstanceType: to.Ptr("FabricModelCustomProperties"),
			},
		},
		Tags: map[string]*string{
			"key6664": to.Ptr("def"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FabricModel = armrecoveryservicesdatareplication.FabricModel{
	// 	Name: to.Ptr("rhojydcwjgvgexpdwswjib"),
	// 	Type: to.Ptr("toipsryjyqchikyakeiuatshiu"),
	// 	ID: to.Ptr("ycaxtshcmldt"),
	// 	Location: to.Ptr("tqygutlpob"),
	// 	Properties: &armrecoveryservicesdatareplication.FabricModelProperties{
	// 		CustomProperties: &armrecoveryservicesdatareplication.FabricModelCustomProperties{
	// 			InstanceType: to.Ptr("FabricModelCustomProperties"),
	// 		},
	// 		Health: to.Ptr(armrecoveryservicesdatareplication.HealthStatusNormal),
	// 		HealthErrors: []*armrecoveryservicesdatareplication.HealthErrorModel{
	// 			{
	// 				AffectedResourceCorrelationIDs: []*string{
	// 					to.Ptr("fope")},
	// 					AffectedResourceType: to.Ptr("scfniv"),
	// 					Category: to.Ptr("leigw"),
	// 					Causes: to.Ptr("xznphqrrmsdzm"),
	// 					ChildErrors: []*armrecoveryservicesdatareplication.InnerHealthErrorModel{
	// 						{
	// 							Category: to.Ptr("lcsdxrqxquke"),
	// 							Causes: to.Ptr("kefaugkpxjkpulimjthjnl"),
	// 							Code: to.Ptr("yuxxpblihirpedwkigywgwjjrlzq"),
	// 							CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:52.128Z"); return t}()),
	// 							HealthCategory: to.Ptr("mhdgfjqwbikhxmhtomkl"),
	// 							IsCustomerResolvable: to.Ptr(true),
	// 							Message: to.Ptr("sskcei"),
	// 							Recommendation: to.Ptr("kqybwaesqumywtjepi"),
	// 							Severity: to.Ptr("wqxxiuaqjyagq"),
	// 							Source: to.Ptr("wevvftugwydzzw"),
	// 							Summary: to.Ptr("djsmgrltruljo"),
	// 					}},
	// 					Code: to.Ptr("dgxkefzmeukd"),
	// 					CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:52.128Z"); return t}()),
	// 					HealthCategory: to.Ptr("itc"),
	// 					IsCustomerResolvable: to.Ptr(true),
	// 					Message: to.Ptr("lbywtdprdqdekl"),
	// 					Recommendation: to.Ptr("gmssteizlhjtclyeoo"),
	// 					Severity: to.Ptr("vvdajssdcypewdyechilxjmuijvdd"),
	// 					Source: to.Ptr("iy"),
	// 					Summary: to.Ptr("jtooblbvaxxrvcwgscbobq"),
	// 			}},
	// 			ProvisioningState: to.Ptr(armrecoveryservicesdatareplication.ProvisioningStateSucceeded),
	// 			ServiceEndpoint: to.Ptr("ilrfl"),
	// 			ServiceResourceID: to.Ptr("xukigpdrbyyy"),
	// 		},
	// 		SystemData: &armrecoveryservicesdatareplication.FabricModelSystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:53.716Z"); return t}()),
	// 			CreatedBy: to.Ptr("yhdmbqrsgimuucexvpas"),
	// 			CreatedByType: to.Ptr("brnojz"),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:53.716Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("balecqnwu"),
	// 			LastModifiedByType: to.Ptr("ukvqlncihf"),
	// 		},
	// 		Tags: map[string]*string{
	// 			"key3917": to.Ptr("vgralu"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/3066a973f4baf2e2bf072a013b585a820bb10146/specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Fabric_Delete.json
func ExampleFabricClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesdatareplication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFabricClient().BeginDelete(ctx, "rgrecoveryservicesdatareplication", "wPR", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/3066a973f4baf2e2bf072a013b585a820bb10146/specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Fabric_ListBySubscription.json
func ExampleFabricClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesdatareplication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFabricClient().NewListBySubscriptionPager(&armrecoveryservicesdatareplication.FabricClientListBySubscriptionOptions{ContinuationToken: to.Ptr("rmgqrpzucsizbyjscxzockbiyg")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FabricModelCollection = armrecoveryservicesdatareplication.FabricModelCollection{
		// 	Value: []*armrecoveryservicesdatareplication.FabricModel{
		// 		{
		// 			Name: to.Ptr("rhojydcwjgvgexpdwswjib"),
		// 			Type: to.Ptr("toipsryjyqchikyakeiuatshiu"),
		// 			ID: to.Ptr("ycaxtshcmldt"),
		// 			Location: to.Ptr("tqygutlpob"),
		// 			Properties: &armrecoveryservicesdatareplication.FabricModelProperties{
		// 				CustomProperties: &armrecoveryservicesdatareplication.FabricModelCustomProperties{
		// 					InstanceType: to.Ptr("FabricModelCustomProperties"),
		// 				},
		// 				Health: to.Ptr(armrecoveryservicesdatareplication.HealthStatusNormal),
		// 				HealthErrors: []*armrecoveryservicesdatareplication.HealthErrorModel{
		// 					{
		// 						AffectedResourceCorrelationIDs: []*string{
		// 							to.Ptr("fope")},
		// 							AffectedResourceType: to.Ptr("scfniv"),
		// 							Category: to.Ptr("leigw"),
		// 							Causes: to.Ptr("xznphqrrmsdzm"),
		// 							ChildErrors: []*armrecoveryservicesdatareplication.InnerHealthErrorModel{
		// 								{
		// 									Category: to.Ptr("lcsdxrqxquke"),
		// 									Causes: to.Ptr("kefaugkpxjkpulimjthjnl"),
		// 									Code: to.Ptr("yuxxpblihirpedwkigywgwjjrlzq"),
		// 									CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:52.128Z"); return t}()),
		// 									HealthCategory: to.Ptr("mhdgfjqwbikhxmhtomkl"),
		// 									IsCustomerResolvable: to.Ptr(true),
		// 									Message: to.Ptr("sskcei"),
		// 									Recommendation: to.Ptr("kqybwaesqumywtjepi"),
		// 									Severity: to.Ptr("wqxxiuaqjyagq"),
		// 									Source: to.Ptr("wevvftugwydzzw"),
		// 									Summary: to.Ptr("djsmgrltruljo"),
		// 							}},
		// 							Code: to.Ptr("dgxkefzmeukd"),
		// 							CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:52.128Z"); return t}()),
		// 							HealthCategory: to.Ptr("itc"),
		// 							IsCustomerResolvable: to.Ptr(true),
		// 							Message: to.Ptr("lbywtdprdqdekl"),
		// 							Recommendation: to.Ptr("gmssteizlhjtclyeoo"),
		// 							Severity: to.Ptr("vvdajssdcypewdyechilxjmuijvdd"),
		// 							Source: to.Ptr("iy"),
		// 							Summary: to.Ptr("jtooblbvaxxrvcwgscbobq"),
		// 					}},
		// 					ProvisioningState: to.Ptr(armrecoveryservicesdatareplication.ProvisioningStateSucceeded),
		// 					ServiceEndpoint: to.Ptr("ilrfl"),
		// 					ServiceResourceID: to.Ptr("xukigpdrbyyy"),
		// 				},
		// 				SystemData: &armrecoveryservicesdatareplication.FabricModelSystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:53.716Z"); return t}()),
		// 					CreatedBy: to.Ptr("yhdmbqrsgimuucexvpas"),
		// 					CreatedByType: to.Ptr("brnojz"),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:53.716Z"); return t}()),
		// 					LastModifiedBy: to.Ptr("balecqnwu"),
		// 					LastModifiedByType: to.Ptr("ukvqlncihf"),
		// 				},
		// 				Tags: map[string]*string{
		// 					"key3917": to.Ptr("vgralu"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/3066a973f4baf2e2bf072a013b585a820bb10146/specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Fabric_List.json
func ExampleFabricClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesdatareplication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFabricClient().NewListPager("rgrecoveryservicesdatareplication", &armrecoveryservicesdatareplication.FabricClientListOptions{ContinuationToken: to.Ptr("mjzsxwwmtvd")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FabricModelCollection = armrecoveryservicesdatareplication.FabricModelCollection{
		// 	Value: []*armrecoveryservicesdatareplication.FabricModel{
		// 		{
		// 			Name: to.Ptr("rhojydcwjgvgexpdwswjib"),
		// 			Type: to.Ptr("toipsryjyqchikyakeiuatshiu"),
		// 			ID: to.Ptr("ycaxtshcmldt"),
		// 			Location: to.Ptr("tqygutlpob"),
		// 			Properties: &armrecoveryservicesdatareplication.FabricModelProperties{
		// 				CustomProperties: &armrecoveryservicesdatareplication.FabricModelCustomProperties{
		// 					InstanceType: to.Ptr("FabricModelCustomProperties"),
		// 				},
		// 				Health: to.Ptr(armrecoveryservicesdatareplication.HealthStatusNormal),
		// 				HealthErrors: []*armrecoveryservicesdatareplication.HealthErrorModel{
		// 					{
		// 						AffectedResourceCorrelationIDs: []*string{
		// 							to.Ptr("fope")},
		// 							AffectedResourceType: to.Ptr("scfniv"),
		// 							Category: to.Ptr("leigw"),
		// 							Causes: to.Ptr("xznphqrrmsdzm"),
		// 							ChildErrors: []*armrecoveryservicesdatareplication.InnerHealthErrorModel{
		// 								{
		// 									Category: to.Ptr("lcsdxrqxquke"),
		// 									Causes: to.Ptr("kefaugkpxjkpulimjthjnl"),
		// 									Code: to.Ptr("yuxxpblihirpedwkigywgwjjrlzq"),
		// 									CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:52.128Z"); return t}()),
		// 									HealthCategory: to.Ptr("mhdgfjqwbikhxmhtomkl"),
		// 									IsCustomerResolvable: to.Ptr(true),
		// 									Message: to.Ptr("sskcei"),
		// 									Recommendation: to.Ptr("kqybwaesqumywtjepi"),
		// 									Severity: to.Ptr("wqxxiuaqjyagq"),
		// 									Source: to.Ptr("wevvftugwydzzw"),
		// 									Summary: to.Ptr("djsmgrltruljo"),
		// 							}},
		// 							Code: to.Ptr("dgxkefzmeukd"),
		// 							CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:52.128Z"); return t}()),
		// 							HealthCategory: to.Ptr("itc"),
		// 							IsCustomerResolvable: to.Ptr(true),
		// 							Message: to.Ptr("lbywtdprdqdekl"),
		// 							Recommendation: to.Ptr("gmssteizlhjtclyeoo"),
		// 							Severity: to.Ptr("vvdajssdcypewdyechilxjmuijvdd"),
		// 							Source: to.Ptr("iy"),
		// 							Summary: to.Ptr("jtooblbvaxxrvcwgscbobq"),
		// 					}},
		// 					ProvisioningState: to.Ptr(armrecoveryservicesdatareplication.ProvisioningStateSucceeded),
		// 					ServiceEndpoint: to.Ptr("ilrfl"),
		// 					ServiceResourceID: to.Ptr("xukigpdrbyyy"),
		// 				},
		// 				SystemData: &armrecoveryservicesdatareplication.FabricModelSystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:53.716Z"); return t}()),
		// 					CreatedBy: to.Ptr("yhdmbqrsgimuucexvpas"),
		// 					CreatedByType: to.Ptr("brnojz"),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-25T00:28:53.716Z"); return t}()),
		// 					LastModifiedBy: to.Ptr("balecqnwu"),
		// 					LastModifiedByType: to.Ptr("ukvqlncihf"),
		// 				},
		// 				Tags: map[string]*string{
		// 					"key3917": to.Ptr("vgralu"),
		// 				},
		// 		}},
		// 	}
	}
}
