//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armreservations

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// AzureReservationAPIClient contains the methods for the AzureReservationAPI group.
// Don't use this type directly, use NewAzureReservationAPIClient() instead.
type AzureReservationAPIClient struct {
	internal *arm.Client
}

// NewAzureReservationAPIClient creates a new instance of AzureReservationAPIClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAzureReservationAPIClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*AzureReservationAPIClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AzureReservationAPIClient{
		internal: cl,
	}
	return client, nil
}

// GetAppliedReservationList - Get applicable Reservations that are applied to this subscription or a resource group under
// this subscription.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
//   - subscriptionID - Id of the subscription
//   - options - AzureReservationAPIClientGetAppliedReservationListOptions contains the optional parameters for the AzureReservationAPIClient.GetAppliedReservationList
//     method.
func (client *AzureReservationAPIClient) GetAppliedReservationList(ctx context.Context, subscriptionID string, options *AzureReservationAPIClientGetAppliedReservationListOptions) (AzureReservationAPIClientGetAppliedReservationListResponse, error) {
	var err error
	const operationName = "AzureReservationAPIClient.GetAppliedReservationList"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAppliedReservationListCreateRequest(ctx, subscriptionID, options)
	if err != nil {
		return AzureReservationAPIClientGetAppliedReservationListResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureReservationAPIClientGetAppliedReservationListResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureReservationAPIClientGetAppliedReservationListResponse{}, err
	}
	resp, err := client.getAppliedReservationListHandleResponse(httpResp)
	return resp, err
}

// getAppliedReservationListCreateRequest creates the GetAppliedReservationList request.
func (client *AzureReservationAPIClient) getAppliedReservationListCreateRequest(ctx context.Context, subscriptionID string, options *AzureReservationAPIClientGetAppliedReservationListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/appliedReservations"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAppliedReservationListHandleResponse handles the GetAppliedReservationList response.
func (client *AzureReservationAPIClient) getAppliedReservationListHandleResponse(resp *http.Response) (AzureReservationAPIClientGetAppliedReservationListResponse, error) {
	result := AzureReservationAPIClientGetAppliedReservationListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AppliedReservations); err != nil {
		return AzureReservationAPIClientGetAppliedReservationListResponse{}, err
	}
	return result, nil
}

// NewGetCatalogPager - Get the regions and skus that are available for RI purchase for the specified Azure subscription.
//
// Generated from API version 2022-11-01
//   - subscriptionID - Id of the subscription
//   - options - AzureReservationAPIClientGetCatalogOptions contains the optional parameters for the AzureReservationAPIClient.NewGetCatalogPager
//     method.
func (client *AzureReservationAPIClient) NewGetCatalogPager(subscriptionID string, options *AzureReservationAPIClientGetCatalogOptions) *runtime.Pager[AzureReservationAPIClientGetCatalogResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureReservationAPIClientGetCatalogResponse]{
		More: func(page AzureReservationAPIClientGetCatalogResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureReservationAPIClientGetCatalogResponse) (AzureReservationAPIClientGetCatalogResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AzureReservationAPIClient.NewGetCatalogPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getCatalogCreateRequest(ctx, subscriptionID, options)
			}, nil)
			if err != nil {
				return AzureReservationAPIClientGetCatalogResponse{}, err
			}
			return client.getCatalogHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getCatalogCreateRequest creates the GetCatalog request.
func (client *AzureReservationAPIClient) getCatalogCreateRequest(ctx context.Context, subscriptionID string, options *AzureReservationAPIClientGetCatalogOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/catalogs"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	if options != nil && options.ReservedResourceType != nil {
		reqQP.Set("reservedResourceType", *options.ReservedResourceType)
	}
	if options != nil && options.Location != nil {
		reqQP.Set("location", *options.Location)
	}
	if options != nil && options.PublisherID != nil {
		reqQP.Set("publisherId", *options.PublisherID)
	}
	if options != nil && options.OfferID != nil {
		reqQP.Set("offerId", *options.OfferID)
	}
	if options != nil && options.PlanID != nil {
		reqQP.Set("planId", *options.PlanID)
	}
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Skip != nil {
		reqQP.Set("$skip", strconv.FormatFloat(float64(*options.Skip), 'f', -1, 32))
	}
	if options != nil && options.Take != nil {
		reqQP.Set("$take", strconv.FormatFloat(float64(*options.Take), 'f', -1, 32))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCatalogHandleResponse handles the GetCatalog response.
func (client *AzureReservationAPIClient) getCatalogHandleResponse(resp *http.Response) (AzureReservationAPIClientGetCatalogResponse, error) {
	result := AzureReservationAPIClientGetCatalogResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CatalogsResult); err != nil {
		return AzureReservationAPIClientGetCatalogResponse{}, err
	}
	return result, nil
}
