//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurityinsights

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securityinsights/armsecurityinsights"
	moduleVersion = "v1.2.0"
)

// ActionType - The type of the automation rule action
type ActionType string

const (
	// ActionTypeModifyProperties - Modify an object's properties
	ActionTypeModifyProperties ActionType = "ModifyProperties"
	// ActionTypeRunPlaybook - Run a playbook on an object
	ActionTypeRunPlaybook ActionType = "RunPlaybook"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeModifyProperties,
		ActionTypeRunPlaybook,
	}
}

// AlertDetail - Alert detail
type AlertDetail string

const (
	// AlertDetailDisplayName - Alert display name
	AlertDetailDisplayName AlertDetail = "DisplayName"
	// AlertDetailSeverity - Alert severity
	AlertDetailSeverity AlertDetail = "Severity"
)

// PossibleAlertDetailValues returns the possible values for the AlertDetail const type.
func PossibleAlertDetailValues() []AlertDetail {
	return []AlertDetail{
		AlertDetailDisplayName,
		AlertDetailSeverity,
	}
}

// AlertRuleKind - The kind of the alert rule
type AlertRuleKind string

const (
	AlertRuleKindFusion                            AlertRuleKind = "Fusion"
	AlertRuleKindMicrosoftSecurityIncidentCreation AlertRuleKind = "MicrosoftSecurityIncidentCreation"
	AlertRuleKindScheduled                         AlertRuleKind = "Scheduled"
)

// PossibleAlertRuleKindValues returns the possible values for the AlertRuleKind const type.
func PossibleAlertRuleKindValues() []AlertRuleKind {
	return []AlertRuleKind{
		AlertRuleKindFusion,
		AlertRuleKindMicrosoftSecurityIncidentCreation,
		AlertRuleKindScheduled,
	}
}

// AlertSeverity - The severity of the alert
type AlertSeverity string

const (
	// AlertSeverityHigh - High severity
	AlertSeverityHigh AlertSeverity = "High"
	// AlertSeverityInformational - Informational severity
	AlertSeverityInformational AlertSeverity = "Informational"
	// AlertSeverityLow - Low severity
	AlertSeverityLow AlertSeverity = "Low"
	// AlertSeverityMedium - Medium severity
	AlertSeverityMedium AlertSeverity = "Medium"
)

// PossibleAlertSeverityValues returns the possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{
		AlertSeverityHigh,
		AlertSeverityInformational,
		AlertSeverityLow,
		AlertSeverityMedium,
	}
}

// AlertStatus - The lifecycle status of the alert.
type AlertStatus string

const (
	// AlertStatusDismissed - Alert dismissed as false positive
	AlertStatusDismissed AlertStatus = "Dismissed"
	// AlertStatusInProgress - Alert is being handled
	AlertStatusInProgress AlertStatus = "InProgress"
	// AlertStatusNew - New alert
	AlertStatusNew AlertStatus = "New"
	// AlertStatusResolved - Alert closed after handling
	AlertStatusResolved AlertStatus = "Resolved"
	// AlertStatusUnknown - Unknown value
	AlertStatusUnknown AlertStatus = "Unknown"
)

// PossibleAlertStatusValues returns the possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{
		AlertStatusDismissed,
		AlertStatusInProgress,
		AlertStatusNew,
		AlertStatusResolved,
		AlertStatusUnknown,
	}
}

// AntispamMailDirection - The directionality of this mail message
type AntispamMailDirection string

const (
	// AntispamMailDirectionInbound - Inbound
	AntispamMailDirectionInbound AntispamMailDirection = "Inbound"
	// AntispamMailDirectionIntraorg - Intraorg
	AntispamMailDirectionIntraorg AntispamMailDirection = "Intraorg"
	// AntispamMailDirectionOutbound - Outbound
	AntispamMailDirectionOutbound AntispamMailDirection = "Outbound"
	// AntispamMailDirectionUnknown - Unknown
	AntispamMailDirectionUnknown AntispamMailDirection = "Unknown"
)

// PossibleAntispamMailDirectionValues returns the possible values for the AntispamMailDirection const type.
func PossibleAntispamMailDirectionValues() []AntispamMailDirection {
	return []AntispamMailDirection{
		AntispamMailDirectionInbound,
		AntispamMailDirectionIntraorg,
		AntispamMailDirectionOutbound,
		AntispamMailDirectionUnknown,
	}
}

// AttackTactic - The severity for alerts created by this alert rule.
type AttackTactic string

const (
	AttackTacticCollection          AttackTactic = "Collection"
	AttackTacticCommandAndControl   AttackTactic = "CommandAndControl"
	AttackTacticCredentialAccess    AttackTactic = "CredentialAccess"
	AttackTacticDefenseEvasion      AttackTactic = "DefenseEvasion"
	AttackTacticDiscovery           AttackTactic = "Discovery"
	AttackTacticExecution           AttackTactic = "Execution"
	AttackTacticExfiltration        AttackTactic = "Exfiltration"
	AttackTacticImpact              AttackTactic = "Impact"
	AttackTacticInitialAccess       AttackTactic = "InitialAccess"
	AttackTacticLateralMovement     AttackTactic = "LateralMovement"
	AttackTacticPersistence         AttackTactic = "Persistence"
	AttackTacticPreAttack           AttackTactic = "PreAttack"
	AttackTacticPrivilegeEscalation AttackTactic = "PrivilegeEscalation"
)

// PossibleAttackTacticValues returns the possible values for the AttackTactic const type.
func PossibleAttackTacticValues() []AttackTactic {
	return []AttackTactic{
		AttackTacticCollection,
		AttackTacticCommandAndControl,
		AttackTacticCredentialAccess,
		AttackTacticDefenseEvasion,
		AttackTacticDiscovery,
		AttackTacticExecution,
		AttackTacticExfiltration,
		AttackTacticImpact,
		AttackTacticInitialAccess,
		AttackTacticLateralMovement,
		AttackTacticPersistence,
		AttackTacticPreAttack,
		AttackTacticPrivilegeEscalation,
	}
}

type AutomationRulePropertyConditionSupportedOperator string

const (
	// AutomationRulePropertyConditionSupportedOperatorContains - Evaluates if the property contains at least one of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorContains AutomationRulePropertyConditionSupportedOperator = "Contains"
	// AutomationRulePropertyConditionSupportedOperatorEndsWith - Evaluates if the property ends with any of the condition values
	AutomationRulePropertyConditionSupportedOperatorEndsWith AutomationRulePropertyConditionSupportedOperator = "EndsWith"
	// AutomationRulePropertyConditionSupportedOperatorEquals - Evaluates if the property equals at least one of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorEquals AutomationRulePropertyConditionSupportedOperator = "Equals"
	// AutomationRulePropertyConditionSupportedOperatorNotContains - Evaluates if the property does not contain any of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorNotContains AutomationRulePropertyConditionSupportedOperator = "NotContains"
	// AutomationRulePropertyConditionSupportedOperatorNotEndsWith - Evaluates if the property does not end with any of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorNotEndsWith AutomationRulePropertyConditionSupportedOperator = "NotEndsWith"
	// AutomationRulePropertyConditionSupportedOperatorNotEquals - Evaluates if the property does not equal any of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorNotEquals AutomationRulePropertyConditionSupportedOperator = "NotEquals"
	// AutomationRulePropertyConditionSupportedOperatorNotStartsWith - Evaluates if the property does not start with any of the
	// condition values
	AutomationRulePropertyConditionSupportedOperatorNotStartsWith AutomationRulePropertyConditionSupportedOperator = "NotStartsWith"
	// AutomationRulePropertyConditionSupportedOperatorStartsWith - Evaluates if the property starts with any of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorStartsWith AutomationRulePropertyConditionSupportedOperator = "StartsWith"
)

// PossibleAutomationRulePropertyConditionSupportedOperatorValues returns the possible values for the AutomationRulePropertyConditionSupportedOperator const type.
func PossibleAutomationRulePropertyConditionSupportedOperatorValues() []AutomationRulePropertyConditionSupportedOperator {
	return []AutomationRulePropertyConditionSupportedOperator{
		AutomationRulePropertyConditionSupportedOperatorContains,
		AutomationRulePropertyConditionSupportedOperatorEndsWith,
		AutomationRulePropertyConditionSupportedOperatorEquals,
		AutomationRulePropertyConditionSupportedOperatorNotContains,
		AutomationRulePropertyConditionSupportedOperatorNotEndsWith,
		AutomationRulePropertyConditionSupportedOperatorNotEquals,
		AutomationRulePropertyConditionSupportedOperatorNotStartsWith,
		AutomationRulePropertyConditionSupportedOperatorStartsWith,
	}
}

// AutomationRulePropertyConditionSupportedProperty - The property to evaluate in an automation rule property condition
type AutomationRulePropertyConditionSupportedProperty string

const (
	// AutomationRulePropertyConditionSupportedPropertyAccountAADTenantID - The account Azure Active Directory tenant id
	AutomationRulePropertyConditionSupportedPropertyAccountAADTenantID AutomationRulePropertyConditionSupportedProperty = "AccountAadTenantId"
	// AutomationRulePropertyConditionSupportedPropertyAccountAADUserID - The account Azure Active Directory user id
	AutomationRulePropertyConditionSupportedPropertyAccountAADUserID AutomationRulePropertyConditionSupportedProperty = "AccountAadUserId"
	// AutomationRulePropertyConditionSupportedPropertyAccountNTDomain - The account NetBIOS domain name
	AutomationRulePropertyConditionSupportedPropertyAccountNTDomain AutomationRulePropertyConditionSupportedProperty = "AccountNTDomain"
	// AutomationRulePropertyConditionSupportedPropertyAccountName - The account name
	AutomationRulePropertyConditionSupportedPropertyAccountName AutomationRulePropertyConditionSupportedProperty = "AccountName"
	// AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID - The account unique identifier
	AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID AutomationRulePropertyConditionSupportedProperty = "AccountObjectGuid"
	// AutomationRulePropertyConditionSupportedPropertyAccountPUID - The account Azure Active Directory Passport User ID
	AutomationRulePropertyConditionSupportedPropertyAccountPUID AutomationRulePropertyConditionSupportedProperty = "AccountPUID"
	// AutomationRulePropertyConditionSupportedPropertyAccountSid - The account security identifier
	AutomationRulePropertyConditionSupportedPropertyAccountSid AutomationRulePropertyConditionSupportedProperty = "AccountSid"
	// AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix - The account user principal name suffix
	AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix AutomationRulePropertyConditionSupportedProperty = "AccountUPNSuffix"
	// AutomationRulePropertyConditionSupportedPropertyAlertProductNames - The name of the product of the alert
	AutomationRulePropertyConditionSupportedPropertyAlertProductNames AutomationRulePropertyConditionSupportedProperty = "AlertProductNames"
	// AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID - The Azure resource id
	AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID AutomationRulePropertyConditionSupportedProperty = "AzureResourceResourceId"
	// AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID - The Azure resource subscription id
	AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID AutomationRulePropertyConditionSupportedProperty = "AzureResourceSubscriptionId"
	// AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID - The cloud application identifier
	AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID AutomationRulePropertyConditionSupportedProperty = "CloudApplicationAppId"
	// AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName - The cloud application name
	AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName AutomationRulePropertyConditionSupportedProperty = "CloudApplicationAppName"
	// AutomationRulePropertyConditionSupportedPropertyDNSDomainName - The dns record domain name
	AutomationRulePropertyConditionSupportedPropertyDNSDomainName AutomationRulePropertyConditionSupportedProperty = "DNSDomainName"
	// AutomationRulePropertyConditionSupportedPropertyFileDirectory - The file directory full path
	AutomationRulePropertyConditionSupportedPropertyFileDirectory AutomationRulePropertyConditionSupportedProperty = "FileDirectory"
	// AutomationRulePropertyConditionSupportedPropertyFileHashValue - The file hash value
	AutomationRulePropertyConditionSupportedPropertyFileHashValue AutomationRulePropertyConditionSupportedProperty = "FileHashValue"
	// AutomationRulePropertyConditionSupportedPropertyFileName - The file name without path
	AutomationRulePropertyConditionSupportedPropertyFileName AutomationRulePropertyConditionSupportedProperty = "FileName"
	// AutomationRulePropertyConditionSupportedPropertyHostAzureID - The host Azure resource id
	AutomationRulePropertyConditionSupportedPropertyHostAzureID AutomationRulePropertyConditionSupportedProperty = "HostAzureID"
	// AutomationRulePropertyConditionSupportedPropertyHostNTDomain - The host NT domain
	AutomationRulePropertyConditionSupportedPropertyHostNTDomain AutomationRulePropertyConditionSupportedProperty = "HostNTDomain"
	// AutomationRulePropertyConditionSupportedPropertyHostName - The host name without domain
	AutomationRulePropertyConditionSupportedPropertyHostName AutomationRulePropertyConditionSupportedProperty = "HostName"
	// AutomationRulePropertyConditionSupportedPropertyHostNetBiosName - The host NetBIOS name
	AutomationRulePropertyConditionSupportedPropertyHostNetBiosName AutomationRulePropertyConditionSupportedProperty = "HostNetBiosName"
	// AutomationRulePropertyConditionSupportedPropertyHostOSVersion - The host operating system
	AutomationRulePropertyConditionSupportedPropertyHostOSVersion AutomationRulePropertyConditionSupportedProperty = "HostOSVersion"
	// AutomationRulePropertyConditionSupportedPropertyIPAddress - The IP address
	AutomationRulePropertyConditionSupportedPropertyIPAddress AutomationRulePropertyConditionSupportedProperty = "IPAddress"
	// AutomationRulePropertyConditionSupportedPropertyIncidentDescription - The description of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentDescription AutomationRulePropertyConditionSupportedProperty = "IncidentDescription"
	// AutomationRulePropertyConditionSupportedPropertyIncidentLabel - The labels of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentLabel AutomationRulePropertyConditionSupportedProperty = "IncidentLabel"
	// AutomationRulePropertyConditionSupportedPropertyIncidentProviderName - The provider name of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentProviderName AutomationRulePropertyConditionSupportedProperty = "IncidentProviderName"
	// AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIDs - The related Analytic rule ids of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIDs AutomationRulePropertyConditionSupportedProperty = "IncidentRelatedAnalyticRuleIds"
	// AutomationRulePropertyConditionSupportedPropertyIncidentSeverity - The severity of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentSeverity AutomationRulePropertyConditionSupportedProperty = "IncidentSeverity"
	// AutomationRulePropertyConditionSupportedPropertyIncidentStatus - The status of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentStatus AutomationRulePropertyConditionSupportedProperty = "IncidentStatus"
	// AutomationRulePropertyConditionSupportedPropertyIncidentTactics - The tactics of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentTactics AutomationRulePropertyConditionSupportedProperty = "IncidentTactics"
	// AutomationRulePropertyConditionSupportedPropertyIncidentTitle - The title of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentTitle AutomationRulePropertyConditionSupportedProperty = "IncidentTitle"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceID - "The IoT device id
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceID AutomationRulePropertyConditionSupportedProperty = "IoTDeviceId"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel - The IoT device model
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel AutomationRulePropertyConditionSupportedProperty = "IoTDeviceModel"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceName - The IoT device name
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceName AutomationRulePropertyConditionSupportedProperty = "IoTDeviceName"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem - The IoT device operating system
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem AutomationRulePropertyConditionSupportedProperty = "IoTDeviceOperatingSystem"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceType - The IoT device type
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceType AutomationRulePropertyConditionSupportedProperty = "IoTDeviceType"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor - The IoT device vendor
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor AutomationRulePropertyConditionSupportedProperty = "IoTDeviceVendor"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction - The mail message delivery action
	AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction AutomationRulePropertyConditionSupportedProperty = "MailMessageDeliveryAction"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation - The mail message delivery location
	AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation AutomationRulePropertyConditionSupportedProperty = "MailMessageDeliveryLocation"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender - The mail message P1 sender
	AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender AutomationRulePropertyConditionSupportedProperty = "MailMessageP1Sender"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender - The mail message P2 sender
	AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender AutomationRulePropertyConditionSupportedProperty = "MailMessageP2Sender"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient - The mail message recipient
	AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient AutomationRulePropertyConditionSupportedProperty = "MailMessageRecipient"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP - The mail message sender IP address
	AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP AutomationRulePropertyConditionSupportedProperty = "MailMessageSenderIP"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageSubject - The mail message subject
	AutomationRulePropertyConditionSupportedPropertyMailMessageSubject AutomationRulePropertyConditionSupportedProperty = "MailMessageSubject"
	// AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName - The mailbox display name
	AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName AutomationRulePropertyConditionSupportedProperty = "MailboxDisplayName"
	// AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress - The mailbox primary address
	AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress AutomationRulePropertyConditionSupportedProperty = "MailboxPrimaryAddress"
	// AutomationRulePropertyConditionSupportedPropertyMailboxUPN - The mailbox user principal name
	AutomationRulePropertyConditionSupportedPropertyMailboxUPN AutomationRulePropertyConditionSupportedProperty = "MailboxUPN"
	// AutomationRulePropertyConditionSupportedPropertyMalwareCategory - The malware category
	AutomationRulePropertyConditionSupportedPropertyMalwareCategory AutomationRulePropertyConditionSupportedProperty = "MalwareCategory"
	// AutomationRulePropertyConditionSupportedPropertyMalwareName - The malware name
	AutomationRulePropertyConditionSupportedPropertyMalwareName AutomationRulePropertyConditionSupportedProperty = "MalwareName"
	// AutomationRulePropertyConditionSupportedPropertyProcessCommandLine - The process execution command line
	AutomationRulePropertyConditionSupportedPropertyProcessCommandLine AutomationRulePropertyConditionSupportedProperty = "ProcessCommandLine"
	// AutomationRulePropertyConditionSupportedPropertyProcessID - The process id
	AutomationRulePropertyConditionSupportedPropertyProcessID AutomationRulePropertyConditionSupportedProperty = "ProcessId"
	// AutomationRulePropertyConditionSupportedPropertyRegistryKey - The registry key path
	AutomationRulePropertyConditionSupportedPropertyRegistryKey AutomationRulePropertyConditionSupportedProperty = "RegistryKey"
	// AutomationRulePropertyConditionSupportedPropertyRegistryValueData - The registry key value in string formatted representation
	AutomationRulePropertyConditionSupportedPropertyRegistryValueData AutomationRulePropertyConditionSupportedProperty = "RegistryValueData"
	// AutomationRulePropertyConditionSupportedPropertyURL - The url
	AutomationRulePropertyConditionSupportedPropertyURL AutomationRulePropertyConditionSupportedProperty = "Url"
)

// PossibleAutomationRulePropertyConditionSupportedPropertyValues returns the possible values for the AutomationRulePropertyConditionSupportedProperty const type.
func PossibleAutomationRulePropertyConditionSupportedPropertyValues() []AutomationRulePropertyConditionSupportedProperty {
	return []AutomationRulePropertyConditionSupportedProperty{
		AutomationRulePropertyConditionSupportedPropertyAccountAADTenantID,
		AutomationRulePropertyConditionSupportedPropertyAccountAADUserID,
		AutomationRulePropertyConditionSupportedPropertyAccountNTDomain,
		AutomationRulePropertyConditionSupportedPropertyAccountName,
		AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID,
		AutomationRulePropertyConditionSupportedPropertyAccountPUID,
		AutomationRulePropertyConditionSupportedPropertyAccountSid,
		AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix,
		AutomationRulePropertyConditionSupportedPropertyAlertProductNames,
		AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID,
		AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID,
		AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID,
		AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName,
		AutomationRulePropertyConditionSupportedPropertyDNSDomainName,
		AutomationRulePropertyConditionSupportedPropertyFileDirectory,
		AutomationRulePropertyConditionSupportedPropertyFileHashValue,
		AutomationRulePropertyConditionSupportedPropertyFileName,
		AutomationRulePropertyConditionSupportedPropertyHostAzureID,
		AutomationRulePropertyConditionSupportedPropertyHostNTDomain,
		AutomationRulePropertyConditionSupportedPropertyHostName,
		AutomationRulePropertyConditionSupportedPropertyHostNetBiosName,
		AutomationRulePropertyConditionSupportedPropertyHostOSVersion,
		AutomationRulePropertyConditionSupportedPropertyIPAddress,
		AutomationRulePropertyConditionSupportedPropertyIncidentDescription,
		AutomationRulePropertyConditionSupportedPropertyIncidentLabel,
		AutomationRulePropertyConditionSupportedPropertyIncidentProviderName,
		AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIDs,
		AutomationRulePropertyConditionSupportedPropertyIncidentSeverity,
		AutomationRulePropertyConditionSupportedPropertyIncidentStatus,
		AutomationRulePropertyConditionSupportedPropertyIncidentTactics,
		AutomationRulePropertyConditionSupportedPropertyIncidentTitle,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceID,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceName,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceType,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor,
		AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction,
		AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation,
		AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender,
		AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender,
		AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient,
		AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP,
		AutomationRulePropertyConditionSupportedPropertyMailMessageSubject,
		AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName,
		AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress,
		AutomationRulePropertyConditionSupportedPropertyMailboxUPN,
		AutomationRulePropertyConditionSupportedPropertyMalwareCategory,
		AutomationRulePropertyConditionSupportedPropertyMalwareName,
		AutomationRulePropertyConditionSupportedPropertyProcessCommandLine,
		AutomationRulePropertyConditionSupportedPropertyProcessID,
		AutomationRulePropertyConditionSupportedPropertyRegistryKey,
		AutomationRulePropertyConditionSupportedPropertyRegistryValueData,
		AutomationRulePropertyConditionSupportedPropertyURL,
	}
}

type ConditionType string

const (
	// ConditionTypeProperty - Evaluate an object property value
	ConditionTypeProperty ConditionType = "Property"
)

// PossibleConditionTypeValues returns the possible values for the ConditionType const type.
func PossibleConditionTypeValues() []ConditionType {
	return []ConditionType{
		ConditionTypeProperty,
	}
}

// ConfidenceLevel - The confidence level of this alert.
type ConfidenceLevel string

const (
	// ConfidenceLevelHigh - High confidence that the alert is true positive malicious
	ConfidenceLevelHigh ConfidenceLevel = "High"
	// ConfidenceLevelLow - Low confidence, meaning we have some doubts this is indeed malicious or part of an attack
	ConfidenceLevelLow ConfidenceLevel = "Low"
	// ConfidenceLevelUnknown - Unknown confidence, the is the default value
	ConfidenceLevelUnknown ConfidenceLevel = "Unknown"
)

// PossibleConfidenceLevelValues returns the possible values for the ConfidenceLevel const type.
func PossibleConfidenceLevelValues() []ConfidenceLevel {
	return []ConfidenceLevel{
		ConfidenceLevelHigh,
		ConfidenceLevelLow,
		ConfidenceLevelUnknown,
	}
}

// ConfidenceScoreStatus - The confidence score calculation status, i.e. indicating if score calculation is pending for this
// alert, not applicable or final.
type ConfidenceScoreStatus string

const (
	// ConfidenceScoreStatusFinal - Final score was calculated and available
	ConfidenceScoreStatusFinal ConfidenceScoreStatus = "Final"
	// ConfidenceScoreStatusInProcess - No score was set yet and calculation is in progress
	ConfidenceScoreStatusInProcess ConfidenceScoreStatus = "InProcess"
	// ConfidenceScoreStatusNotApplicable - Score will not be calculated for this alert as it is not supported by virtual analyst
	ConfidenceScoreStatusNotApplicable ConfidenceScoreStatus = "NotApplicable"
	// ConfidenceScoreStatusNotFinal - Score is calculated and shown as part of the alert, but may be updated again at a later
	// time following the processing of additional data
	ConfidenceScoreStatusNotFinal ConfidenceScoreStatus = "NotFinal"
)

// PossibleConfidenceScoreStatusValues returns the possible values for the ConfidenceScoreStatus const type.
func PossibleConfidenceScoreStatusValues() []ConfidenceScoreStatus {
	return []ConfidenceScoreStatus{
		ConfidenceScoreStatusFinal,
		ConfidenceScoreStatusInProcess,
		ConfidenceScoreStatusNotApplicable,
		ConfidenceScoreStatusNotFinal,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DataConnectorKind - The kind of the data connector
type DataConnectorKind string

const (
	DataConnectorKindAmazonWebServicesCloudTrail               DataConnectorKind = "AmazonWebServicesCloudTrail"
	DataConnectorKindAzureActiveDirectory                      DataConnectorKind = "AzureActiveDirectory"
	DataConnectorKindAzureAdvancedThreatProtection             DataConnectorKind = "AzureAdvancedThreatProtection"
	DataConnectorKindAzureSecurityCenter                       DataConnectorKind = "AzureSecurityCenter"
	DataConnectorKindMicrosoftCloudAppSecurity                 DataConnectorKind = "MicrosoftCloudAppSecurity"
	DataConnectorKindMicrosoftDefenderAdvancedThreatProtection DataConnectorKind = "MicrosoftDefenderAdvancedThreatProtection"
	DataConnectorKindOffice365                                 DataConnectorKind = "Office365"
	DataConnectorKindThreatIntelligence                        DataConnectorKind = "ThreatIntelligence"
)

// PossibleDataConnectorKindValues returns the possible values for the DataConnectorKind const type.
func PossibleDataConnectorKindValues() []DataConnectorKind {
	return []DataConnectorKind{
		DataConnectorKindAmazonWebServicesCloudTrail,
		DataConnectorKindAzureActiveDirectory,
		DataConnectorKindAzureAdvancedThreatProtection,
		DataConnectorKindAzureSecurityCenter,
		DataConnectorKindMicrosoftCloudAppSecurity,
		DataConnectorKindMicrosoftDefenderAdvancedThreatProtection,
		DataConnectorKindOffice365,
		DataConnectorKindThreatIntelligence,
	}
}

// DataTypeState - Describe whether this data type connection is enabled or not.
type DataTypeState string

const (
	DataTypeStateDisabled DataTypeState = "Disabled"
	DataTypeStateEnabled  DataTypeState = "Enabled"
)

// PossibleDataTypeStateValues returns the possible values for the DataTypeState const type.
func PossibleDataTypeStateValues() []DataTypeState {
	return []DataTypeState{
		DataTypeStateDisabled,
		DataTypeStateEnabled,
	}
}

// DeliveryAction - The delivery action of this mail message like Delivered, Blocked, Replaced etc
type DeliveryAction string

const (
	// DeliveryActionBlocked - Blocked
	DeliveryActionBlocked DeliveryAction = "Blocked"
	// DeliveryActionDelivered - Delivered
	DeliveryActionDelivered DeliveryAction = "Delivered"
	// DeliveryActionDeliveredAsSpam - DeliveredAsSpam
	DeliveryActionDeliveredAsSpam DeliveryAction = "DeliveredAsSpam"
	// DeliveryActionReplaced - Replaced
	DeliveryActionReplaced DeliveryAction = "Replaced"
	// DeliveryActionUnknown - Unknown
	DeliveryActionUnknown DeliveryAction = "Unknown"
)

// PossibleDeliveryActionValues returns the possible values for the DeliveryAction const type.
func PossibleDeliveryActionValues() []DeliveryAction {
	return []DeliveryAction{
		DeliveryActionBlocked,
		DeliveryActionDelivered,
		DeliveryActionDeliveredAsSpam,
		DeliveryActionReplaced,
		DeliveryActionUnknown,
	}
}

// DeliveryLocation - The delivery location of this mail message like Inbox, JunkFolder etc
type DeliveryLocation string

const (
	// DeliveryLocationDeletedFolder - DeletedFolder
	DeliveryLocationDeletedFolder DeliveryLocation = "DeletedFolder"
	// DeliveryLocationDropped - Dropped
	DeliveryLocationDropped DeliveryLocation = "Dropped"
	// DeliveryLocationExternal - External
	DeliveryLocationExternal DeliveryLocation = "External"
	// DeliveryLocationFailed - Failed
	DeliveryLocationFailed DeliveryLocation = "Failed"
	// DeliveryLocationForwarded - Forwarded
	DeliveryLocationForwarded DeliveryLocation = "Forwarded"
	// DeliveryLocationInbox - Inbox
	DeliveryLocationInbox DeliveryLocation = "Inbox"
	// DeliveryLocationJunkFolder - JunkFolder
	DeliveryLocationJunkFolder DeliveryLocation = "JunkFolder"
	// DeliveryLocationQuarantine - Quarantine
	DeliveryLocationQuarantine DeliveryLocation = "Quarantine"
	// DeliveryLocationUnknown - Unknown
	DeliveryLocationUnknown DeliveryLocation = "Unknown"
)

// PossibleDeliveryLocationValues returns the possible values for the DeliveryLocation const type.
func PossibleDeliveryLocationValues() []DeliveryLocation {
	return []DeliveryLocation{
		DeliveryLocationDeletedFolder,
		DeliveryLocationDropped,
		DeliveryLocationExternal,
		DeliveryLocationFailed,
		DeliveryLocationForwarded,
		DeliveryLocationInbox,
		DeliveryLocationJunkFolder,
		DeliveryLocationQuarantine,
		DeliveryLocationUnknown,
	}
}

// ElevationToken - The elevation token associated with the process.
type ElevationToken string

const (
	// ElevationTokenDefault - Default elevation token
	ElevationTokenDefault ElevationToken = "Default"
	// ElevationTokenFull - Full elevation token
	ElevationTokenFull ElevationToken = "Full"
	// ElevationTokenLimited - Limited elevation token
	ElevationTokenLimited ElevationToken = "Limited"
)

// PossibleElevationTokenValues returns the possible values for the ElevationToken const type.
func PossibleElevationTokenValues() []ElevationToken {
	return []ElevationToken{
		ElevationTokenDefault,
		ElevationTokenFull,
		ElevationTokenLimited,
	}
}

// EntityKindEnum - The kind of the entity
type EntityKindEnum string

const (
	// EntityKindEnumAccount - Entity represents account in the system.
	EntityKindEnumAccount EntityKindEnum = "Account"
	// EntityKindEnumAzureResource - Entity represents azure resource in the system.
	EntityKindEnumAzureResource EntityKindEnum = "AzureResource"
	// EntityKindEnumBookmark - Entity represents bookmark in the system.
	EntityKindEnumBookmark EntityKindEnum = "Bookmark"
	// EntityKindEnumCloudApplication - Entity represents cloud application in the system.
	EntityKindEnumCloudApplication EntityKindEnum = "CloudApplication"
	// EntityKindEnumDNSResolution - Entity represents dns resolution in the system.
	EntityKindEnumDNSResolution EntityKindEnum = "DnsResolution"
	// EntityKindEnumFile - Entity represents file in the system.
	EntityKindEnumFile EntityKindEnum = "File"
	// EntityKindEnumFileHash - Entity represents file hash in the system.
	EntityKindEnumFileHash EntityKindEnum = "FileHash"
	// EntityKindEnumHost - Entity represents host in the system.
	EntityKindEnumHost EntityKindEnum = "Host"
	// EntityKindEnumIP - Entity represents ip in the system.
	EntityKindEnumIP EntityKindEnum = "Ip"
	// EntityKindEnumIoTDevice - Entity represents IoT device in the system.
	EntityKindEnumIoTDevice EntityKindEnum = "IoTDevice"
	// EntityKindEnumMailCluster - Entity represents mail cluster in the system.
	EntityKindEnumMailCluster EntityKindEnum = "MailCluster"
	// EntityKindEnumMailMessage - Entity represents mail message in the system.
	EntityKindEnumMailMessage EntityKindEnum = "MailMessage"
	// EntityKindEnumMailbox - Entity represents mailbox in the system.
	EntityKindEnumMailbox EntityKindEnum = "Mailbox"
	// EntityKindEnumMalware - Entity represents malware in the system.
	EntityKindEnumMalware EntityKindEnum = "Malware"
	// EntityKindEnumProcess - Entity represents process in the system.
	EntityKindEnumProcess EntityKindEnum = "Process"
	// EntityKindEnumRegistryKey - Entity represents registry key in the system.
	EntityKindEnumRegistryKey EntityKindEnum = "RegistryKey"
	// EntityKindEnumRegistryValue - Entity represents registry value in the system.
	EntityKindEnumRegistryValue EntityKindEnum = "RegistryValue"
	// EntityKindEnumSecurityAlert - Entity represents security alert in the system.
	EntityKindEnumSecurityAlert EntityKindEnum = "SecurityAlert"
	// EntityKindEnumSecurityGroup - Entity represents security group in the system.
	EntityKindEnumSecurityGroup EntityKindEnum = "SecurityGroup"
	// EntityKindEnumSubmissionMail - Entity represents submission mail in the system.
	EntityKindEnumSubmissionMail EntityKindEnum = "SubmissionMail"
	// EntityKindEnumURL - Entity represents url in the system.
	EntityKindEnumURL EntityKindEnum = "Url"
)

// PossibleEntityKindEnumValues returns the possible values for the EntityKindEnum const type.
func PossibleEntityKindEnumValues() []EntityKindEnum {
	return []EntityKindEnum{
		EntityKindEnumAccount,
		EntityKindEnumAzureResource,
		EntityKindEnumBookmark,
		EntityKindEnumCloudApplication,
		EntityKindEnumDNSResolution,
		EntityKindEnumFile,
		EntityKindEnumFileHash,
		EntityKindEnumHost,
		EntityKindEnumIP,
		EntityKindEnumIoTDevice,
		EntityKindEnumMailCluster,
		EntityKindEnumMailMessage,
		EntityKindEnumMailbox,
		EntityKindEnumMalware,
		EntityKindEnumProcess,
		EntityKindEnumRegistryKey,
		EntityKindEnumRegistryValue,
		EntityKindEnumSecurityAlert,
		EntityKindEnumSecurityGroup,
		EntityKindEnumSubmissionMail,
		EntityKindEnumURL,
	}
}

// EntityMappingType - The V3 type of the mapped entity
type EntityMappingType string

const (
	// EntityMappingTypeAccount - User account entity type
	EntityMappingTypeAccount EntityMappingType = "Account"
	// EntityMappingTypeAzureResource - Azure resource entity type
	EntityMappingTypeAzureResource EntityMappingType = "AzureResource"
	// EntityMappingTypeCloudApplication - Cloud app entity type
	EntityMappingTypeCloudApplication EntityMappingType = "CloudApplication"
	// EntityMappingTypeDNS - DNS entity type
	EntityMappingTypeDNS EntityMappingType = "DNS"
	// EntityMappingTypeFile - System file entity type
	EntityMappingTypeFile EntityMappingType = "File"
	// EntityMappingTypeFileHash - File-hash entity type
	EntityMappingTypeFileHash EntityMappingType = "FileHash"
	// EntityMappingTypeHost - Host entity type
	EntityMappingTypeHost EntityMappingType = "Host"
	// EntityMappingTypeIP - IP address entity type
	EntityMappingTypeIP EntityMappingType = "IP"
	// EntityMappingTypeMailCluster - Mail cluster entity type
	EntityMappingTypeMailCluster EntityMappingType = "MailCluster"
	// EntityMappingTypeMailMessage - Mail message entity type
	EntityMappingTypeMailMessage EntityMappingType = "MailMessage"
	// EntityMappingTypeMailbox - Mailbox entity type
	EntityMappingTypeMailbox EntityMappingType = "Mailbox"
	// EntityMappingTypeMalware - Malware entity type
	EntityMappingTypeMalware EntityMappingType = "Malware"
	// EntityMappingTypeProcess - Process entity type
	EntityMappingTypeProcess EntityMappingType = "Process"
	// EntityMappingTypeRegistryKey - Registry key entity type
	EntityMappingTypeRegistryKey EntityMappingType = "RegistryKey"
	// EntityMappingTypeRegistryValue - Registry value entity type
	EntityMappingTypeRegistryValue EntityMappingType = "RegistryValue"
	// EntityMappingTypeSecurityGroup - Security group entity type
	EntityMappingTypeSecurityGroup EntityMappingType = "SecurityGroup"
	// EntityMappingTypeSubmissionMail - Submission mail entity type
	EntityMappingTypeSubmissionMail EntityMappingType = "SubmissionMail"
	// EntityMappingTypeURL - URL entity type
	EntityMappingTypeURL EntityMappingType = "URL"
)

// PossibleEntityMappingTypeValues returns the possible values for the EntityMappingType const type.
func PossibleEntityMappingTypeValues() []EntityMappingType {
	return []EntityMappingType{
		EntityMappingTypeAccount,
		EntityMappingTypeAzureResource,
		EntityMappingTypeCloudApplication,
		EntityMappingTypeDNS,
		EntityMappingTypeFile,
		EntityMappingTypeFileHash,
		EntityMappingTypeHost,
		EntityMappingTypeIP,
		EntityMappingTypeMailCluster,
		EntityMappingTypeMailMessage,
		EntityMappingTypeMailbox,
		EntityMappingTypeMalware,
		EntityMappingTypeProcess,
		EntityMappingTypeRegistryKey,
		EntityMappingTypeRegistryValue,
		EntityMappingTypeSecurityGroup,
		EntityMappingTypeSubmissionMail,
		EntityMappingTypeURL,
	}
}

// EventGroupingAggregationKind - The event grouping aggregation kinds
type EventGroupingAggregationKind string

const (
	EventGroupingAggregationKindAlertPerResult EventGroupingAggregationKind = "AlertPerResult"
	EventGroupingAggregationKindSingleAlert    EventGroupingAggregationKind = "SingleAlert"
)

// PossibleEventGroupingAggregationKindValues returns the possible values for the EventGroupingAggregationKind const type.
func PossibleEventGroupingAggregationKindValues() []EventGroupingAggregationKind {
	return []EventGroupingAggregationKind{
		EventGroupingAggregationKindAlertPerResult,
		EventGroupingAggregationKindSingleAlert,
	}
}

// FileHashAlgorithm - The hash algorithm type.
type FileHashAlgorithm string

const (
	// FileHashAlgorithmMD5 - MD5 hash type
	FileHashAlgorithmMD5 FileHashAlgorithm = "MD5"
	// FileHashAlgorithmSHA1 - SHA1 hash type
	FileHashAlgorithmSHA1 FileHashAlgorithm = "SHA1"
	// FileHashAlgorithmSHA256 - SHA256 hash type
	FileHashAlgorithmSHA256 FileHashAlgorithm = "SHA256"
	// FileHashAlgorithmSHA256AC - SHA256 Authenticode hash type
	FileHashAlgorithmSHA256AC FileHashAlgorithm = "SHA256AC"
	// FileHashAlgorithmUnknown - Unknown hash algorithm
	FileHashAlgorithmUnknown FileHashAlgorithm = "Unknown"
)

// PossibleFileHashAlgorithmValues returns the possible values for the FileHashAlgorithm const type.
func PossibleFileHashAlgorithmValues() []FileHashAlgorithm {
	return []FileHashAlgorithm{
		FileHashAlgorithmMD5,
		FileHashAlgorithmSHA1,
		FileHashAlgorithmSHA256,
		FileHashAlgorithmSHA256AC,
		FileHashAlgorithmUnknown,
	}
}

// IncidentClassification - The reason the incident was closed
type IncidentClassification string

const (
	// IncidentClassificationBenignPositive - Incident was benign positive
	IncidentClassificationBenignPositive IncidentClassification = "BenignPositive"
	// IncidentClassificationFalsePositive - Incident was false positive
	IncidentClassificationFalsePositive IncidentClassification = "FalsePositive"
	// IncidentClassificationTruePositive - Incident was true positive
	IncidentClassificationTruePositive IncidentClassification = "TruePositive"
	// IncidentClassificationUndetermined - Incident classification was undetermined
	IncidentClassificationUndetermined IncidentClassification = "Undetermined"
)

// PossibleIncidentClassificationValues returns the possible values for the IncidentClassification const type.
func PossibleIncidentClassificationValues() []IncidentClassification {
	return []IncidentClassification{
		IncidentClassificationBenignPositive,
		IncidentClassificationFalsePositive,
		IncidentClassificationTruePositive,
		IncidentClassificationUndetermined,
	}
}

// IncidentClassificationReason - The classification reason the incident was closed with
type IncidentClassificationReason string

const (
	// IncidentClassificationReasonInaccurateData - Classification reason was inaccurate data
	IncidentClassificationReasonInaccurateData IncidentClassificationReason = "InaccurateData"
	// IncidentClassificationReasonIncorrectAlertLogic - Classification reason was incorrect alert logic
	IncidentClassificationReasonIncorrectAlertLogic IncidentClassificationReason = "IncorrectAlertLogic"
	// IncidentClassificationReasonSuspiciousActivity - Classification reason was suspicious activity
	IncidentClassificationReasonSuspiciousActivity IncidentClassificationReason = "SuspiciousActivity"
	// IncidentClassificationReasonSuspiciousButExpected - Classification reason was suspicious but expected
	IncidentClassificationReasonSuspiciousButExpected IncidentClassificationReason = "SuspiciousButExpected"
)

// PossibleIncidentClassificationReasonValues returns the possible values for the IncidentClassificationReason const type.
func PossibleIncidentClassificationReasonValues() []IncidentClassificationReason {
	return []IncidentClassificationReason{
		IncidentClassificationReasonInaccurateData,
		IncidentClassificationReasonIncorrectAlertLogic,
		IncidentClassificationReasonSuspiciousActivity,
		IncidentClassificationReasonSuspiciousButExpected,
	}
}

// IncidentLabelType - The type of the label
type IncidentLabelType string

const (
	// IncidentLabelTypeAutoAssigned - Label automatically created by the system
	IncidentLabelTypeAutoAssigned IncidentLabelType = "AutoAssigned"
	// IncidentLabelTypeUser - Label manually created by a user
	IncidentLabelTypeUser IncidentLabelType = "User"
)

// PossibleIncidentLabelTypeValues returns the possible values for the IncidentLabelType const type.
func PossibleIncidentLabelTypeValues() []IncidentLabelType {
	return []IncidentLabelType{
		IncidentLabelTypeAutoAssigned,
		IncidentLabelTypeUser,
	}
}

// IncidentSeverity - The severity of the incident
type IncidentSeverity string

const (
	// IncidentSeverityHigh - High severity
	IncidentSeverityHigh IncidentSeverity = "High"
	// IncidentSeverityInformational - Informational severity
	IncidentSeverityInformational IncidentSeverity = "Informational"
	// IncidentSeverityLow - Low severity
	IncidentSeverityLow IncidentSeverity = "Low"
	// IncidentSeverityMedium - Medium severity
	IncidentSeverityMedium IncidentSeverity = "Medium"
)

// PossibleIncidentSeverityValues returns the possible values for the IncidentSeverity const type.
func PossibleIncidentSeverityValues() []IncidentSeverity {
	return []IncidentSeverity{
		IncidentSeverityHigh,
		IncidentSeverityInformational,
		IncidentSeverityLow,
		IncidentSeverityMedium,
	}
}

// IncidentStatus - The status of the incident
type IncidentStatus string

const (
	// IncidentStatusActive - An active incident which is being handled
	IncidentStatusActive IncidentStatus = "Active"
	// IncidentStatusClosed - A non-active incident
	IncidentStatusClosed IncidentStatus = "Closed"
	// IncidentStatusNew - An active incident which isn't being handled currently
	IncidentStatusNew IncidentStatus = "New"
)

// PossibleIncidentStatusValues returns the possible values for the IncidentStatus const type.
func PossibleIncidentStatusValues() []IncidentStatus {
	return []IncidentStatus{
		IncidentStatusActive,
		IncidentStatusClosed,
		IncidentStatusNew,
	}
}

// KillChainIntent - Holds the alert intent stage(s) mapping for this alert.
type KillChainIntent string

const (
	// KillChainIntentCollection - Collection consists of techniques used to identify and gather information, such as sensitive
	// files, from a target network prior to exfiltration. This category also covers locations on a system or network where the
	// adversary may look for information to exfiltrate.
	KillChainIntentCollection KillChainIntent = "Collection"
	// KillChainIntentCommandAndControl - The command and control tactic represents how adversaries communicate with systems under
	// their control within a target network.
	KillChainIntentCommandAndControl KillChainIntent = "CommandAndControl"
	// KillChainIntentCredentialAccess - Credential access represents techniques resulting in access to or control over system,
	// domain, or service credentials that are used within an enterprise environment. Adversaries will likely attempt to obtain
	// legitimate credentials from users or administrator accounts (local system administrator or domain users with administrator
	// access) to use within the network. With sufficient access within a network, an adversary can create accounts for later
	// use within the environment.
	KillChainIntentCredentialAccess KillChainIntent = "CredentialAccess"
	// KillChainIntentDefenseEvasion - Defense evasion consists of techniques an adversary may use to evade detection or avoid
	// other defenses. Sometimes these actions are the same as or variations of techniques in other categories that have the added
	// benefit of subverting a particular defense or mitigation.
	KillChainIntentDefenseEvasion KillChainIntent = "DefenseEvasion"
	// KillChainIntentDiscovery - Discovery consists of techniques that allow the adversary to gain knowledge about the system
	// and internal network. When adversaries gain access to a new system, they must orient themselves to what they now have control
	// of and what benefits operating from that system give to their current objective or overall goals during the intrusion.
	// The operating system provides many native tools that aid in this post-compromise information-gathering phase.
	KillChainIntentDiscovery KillChainIntent = "Discovery"
	// KillChainIntentExecution - The execution tactic represents techniques that result in execution of adversary-controlled
	// code on a local or remote system. This tactic is often used in conjunction with lateral movement to expand access to remote
	// systems on a network.
	KillChainIntentExecution KillChainIntent = "Execution"
	// KillChainIntentExfiltration - Exfiltration refers to techniques and attributes that result or aid in the adversary removing
	// files and information from a target network. This category also covers locations on a system or network where the adversary
	// may look for information to exfiltrate.
	KillChainIntentExfiltration KillChainIntent = "Exfiltration"
	// KillChainIntentExploitation - Exploitation is the stage where an attacker manage to get foothold on the attacked resource.
	// This stage is applicable not only for compute hosts, but also for resources such as user accounts, certificates etc. Adversaries
	// will often be able to control the resource after this stage.
	KillChainIntentExploitation KillChainIntent = "Exploitation"
	// KillChainIntentImpact - The impact intent primary objective is to directly reduce the availability or integrity of a system,
	// service, or network; including manipulation of data to impact a business or operational process. This would often refer
	// to techniques such as ransom-ware, defacement, data manipulation and others.
	KillChainIntentImpact KillChainIntent = "Impact"
	// KillChainIntentLateralMovement - Lateral movement consists of techniques that enable an adversary to access and control
	// remote systems on a network and could, but does not necessarily, include execution of tools on remote systems. The lateral
	// movement techniques could allow an adversary to gather information from a system without needing additional tools, such
	// as a remote access tool. An adversary can use lateral movement for many purposes, including remote Execution of tools,
	// pivoting to additional systems, access to specific information or files, access to additional credentials, or to cause
	// an effect.
	KillChainIntentLateralMovement KillChainIntent = "LateralMovement"
	// KillChainIntentPersistence - Persistence is any access, action, or configuration change to a system that gives an adversary
	// a persistent presence on that system. Adversaries will often need to maintain access to systems through interruptions such
	// as system restarts, loss of credentials, or other failures that would require a remote access tool to restart or alternate
	// backdoor for them to regain access.
	KillChainIntentPersistence KillChainIntent = "Persistence"
	// KillChainIntentPrivilegeEscalation - Privilege escalation is the result of actions that allow an adversary to obtain a
	// higher level of permissions on a system or network. Certain tools or actions require a higher level of privilege to work
	// and are likely necessary at many points throughout an operation. User accounts with permissions to access specific systems
	// or perform specific functions necessary for adversaries to achieve their objective may also be considered an escalation
	// of privilege.
	KillChainIntentPrivilegeEscalation KillChainIntent = "PrivilegeEscalation"
	// KillChainIntentProbing - Probing could be an attempt to access a certain resource regardless of a malicious intent or a
	// failed attempt to gain access to a target system to gather information prior to exploitation. This step is usually detected
	// as an attempt originating from outside the network in attempt to scan the target system and find a way in.
	KillChainIntentProbing KillChainIntent = "Probing"
	// KillChainIntentUnknown - The default value.
	KillChainIntentUnknown KillChainIntent = "Unknown"
)

// PossibleKillChainIntentValues returns the possible values for the KillChainIntent const type.
func PossibleKillChainIntentValues() []KillChainIntent {
	return []KillChainIntent{
		KillChainIntentCollection,
		KillChainIntentCommandAndControl,
		KillChainIntentCredentialAccess,
		KillChainIntentDefenseEvasion,
		KillChainIntentDiscovery,
		KillChainIntentExecution,
		KillChainIntentExfiltration,
		KillChainIntentExploitation,
		KillChainIntentImpact,
		KillChainIntentLateralMovement,
		KillChainIntentPersistence,
		KillChainIntentPrivilegeEscalation,
		KillChainIntentProbing,
		KillChainIntentUnknown,
	}
}

// MatchingMethod - Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails,
// groupByCustomDetails must be provided and not empty.
type MatchingMethod string

const (
	// MatchingMethodAllEntities - Grouping alerts into a single incident if all the entities match
	MatchingMethodAllEntities MatchingMethod = "AllEntities"
	// MatchingMethodAnyAlert - Grouping any alerts triggered by this rule into a single incident
	MatchingMethodAnyAlert MatchingMethod = "AnyAlert"
	// MatchingMethodSelected - Grouping alerts into a single incident if the selected entities, custom details and alert details
	// match
	MatchingMethodSelected MatchingMethod = "Selected"
)

// PossibleMatchingMethodValues returns the possible values for the MatchingMethod const type.
func PossibleMatchingMethodValues() []MatchingMethod {
	return []MatchingMethod{
		MatchingMethodAllEntities,
		MatchingMethodAnyAlert,
		MatchingMethodSelected,
	}
}

// MicrosoftSecurityProductName - The alerts' productName on which the cases will be generated
type MicrosoftSecurityProductName string

const (
	MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection MicrosoftSecurityProductName = "Azure Active Directory Identity Protection"
	MicrosoftSecurityProductNameAzureAdvancedThreatProtection          MicrosoftSecurityProductName = "Azure Advanced Threat Protection"
	MicrosoftSecurityProductNameAzureSecurityCenter                    MicrosoftSecurityProductName = "Azure Security Center"
	MicrosoftSecurityProductNameAzureSecurityCenterForIoT              MicrosoftSecurityProductName = "Azure Security Center for IoT"
	MicrosoftSecurityProductNameMicrosoftCloudAppSecurity              MicrosoftSecurityProductName = "Microsoft Cloud App Security"
)

// PossibleMicrosoftSecurityProductNameValues returns the possible values for the MicrosoftSecurityProductName const type.
func PossibleMicrosoftSecurityProductNameValues() []MicrosoftSecurityProductName {
	return []MicrosoftSecurityProductName{
		MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection,
		MicrosoftSecurityProductNameAzureAdvancedThreatProtection,
		MicrosoftSecurityProductNameAzureSecurityCenter,
		MicrosoftSecurityProductNameAzureSecurityCenterForIoT,
		MicrosoftSecurityProductNameMicrosoftCloudAppSecurity,
	}
}

// OSFamily - The operating system type.
type OSFamily string

const (
	// OSFamilyAndroid - Host with Android operating system.
	OSFamilyAndroid OSFamily = "Android"
	// OSFamilyIOS - Host with IOS operating system.
	OSFamilyIOS OSFamily = "IOS"
	// OSFamilyLinux - Host with Linux operating system.
	OSFamilyLinux OSFamily = "Linux"
	// OSFamilyUnknown - Host with Unknown operating system.
	OSFamilyUnknown OSFamily = "Unknown"
	// OSFamilyWindows - Host with Windows operating system.
	OSFamilyWindows OSFamily = "Windows"
)

// PossibleOSFamilyValues returns the possible values for the OSFamily const type.
func PossibleOSFamilyValues() []OSFamily {
	return []OSFamily{
		OSFamilyAndroid,
		OSFamilyIOS,
		OSFamilyLinux,
		OSFamilyUnknown,
		OSFamilyWindows,
	}
}

// OwnerType - The type of the owner the incident is assigned to.
type OwnerType string

const (
	// OwnerTypeGroup - The incident owner type is an AAD group
	OwnerTypeGroup OwnerType = "Group"
	// OwnerTypeUnknown - The incident owner type is unknown
	OwnerTypeUnknown OwnerType = "Unknown"
	// OwnerTypeUser - The incident owner type is an AAD user
	OwnerTypeUser OwnerType = "User"
)

// PossibleOwnerTypeValues returns the possible values for the OwnerType const type.
func PossibleOwnerTypeValues() []OwnerType {
	return []OwnerType{
		OwnerTypeGroup,
		OwnerTypeUnknown,
		OwnerTypeUser,
	}
}

// RegistryHive - the hive that holds the registry key.
type RegistryHive string

const (
	// RegistryHiveHKEYA - HKEY_A
	RegistryHiveHKEYA RegistryHive = "HKEY_A"
	// RegistryHiveHKEYCLASSESROOT - HKEY_CLASSES_ROOT
	RegistryHiveHKEYCLASSESROOT RegistryHive = "HKEY_CLASSES_ROOT"
	// RegistryHiveHKEYCURRENTCONFIG - HKEY_CURRENT_CONFIG
	RegistryHiveHKEYCURRENTCONFIG RegistryHive = "HKEY_CURRENT_CONFIG"
	// RegistryHiveHKEYCURRENTUSER - HKEY_CURRENT_USER
	RegistryHiveHKEYCURRENTUSER RegistryHive = "HKEY_CURRENT_USER"
	// RegistryHiveHKEYCURRENTUSERLOCALSETTINGS - HKEY_CURRENT_USER_LOCAL_SETTINGS
	RegistryHiveHKEYCURRENTUSERLOCALSETTINGS RegistryHive = "HKEY_CURRENT_USER_LOCAL_SETTINGS"
	// RegistryHiveHKEYLOCALMACHINE - HKEY_LOCAL_MACHINE
	RegistryHiveHKEYLOCALMACHINE RegistryHive = "HKEY_LOCAL_MACHINE"
	// RegistryHiveHKEYPERFORMANCEDATA - HKEY_PERFORMANCE_DATA
	RegistryHiveHKEYPERFORMANCEDATA RegistryHive = "HKEY_PERFORMANCE_DATA"
	// RegistryHiveHKEYPERFORMANCENLSTEXT - HKEY_PERFORMANCE_NLSTEXT
	RegistryHiveHKEYPERFORMANCENLSTEXT RegistryHive = "HKEY_PERFORMANCE_NLSTEXT"
	// RegistryHiveHKEYPERFORMANCETEXT - HKEY_PERFORMANCE_TEXT
	RegistryHiveHKEYPERFORMANCETEXT RegistryHive = "HKEY_PERFORMANCE_TEXT"
	// RegistryHiveHKEYUSERS - HKEY_USERS
	RegistryHiveHKEYUSERS RegistryHive = "HKEY_USERS"
)

// PossibleRegistryHiveValues returns the possible values for the RegistryHive const type.
func PossibleRegistryHiveValues() []RegistryHive {
	return []RegistryHive{
		RegistryHiveHKEYA,
		RegistryHiveHKEYCLASSESROOT,
		RegistryHiveHKEYCURRENTCONFIG,
		RegistryHiveHKEYCURRENTUSER,
		RegistryHiveHKEYCURRENTUSERLOCALSETTINGS,
		RegistryHiveHKEYLOCALMACHINE,
		RegistryHiveHKEYPERFORMANCEDATA,
		RegistryHiveHKEYPERFORMANCENLSTEXT,
		RegistryHiveHKEYPERFORMANCETEXT,
		RegistryHiveHKEYUSERS,
	}
}

// RegistryValueKind - Specifies the data types to use when storing values in the registry, or identifies the data type of
// a value in the registry.
type RegistryValueKind string

const (
	// RegistryValueKindBinary - Binary value type
	RegistryValueKindBinary RegistryValueKind = "Binary"
	// RegistryValueKindDWord - DWord value type
	RegistryValueKindDWord RegistryValueKind = "DWord"
	// RegistryValueKindExpandString - ExpandString value type
	RegistryValueKindExpandString RegistryValueKind = "ExpandString"
	// RegistryValueKindMultiString - MultiString value type
	RegistryValueKindMultiString RegistryValueKind = "MultiString"
	// RegistryValueKindNone - None
	RegistryValueKindNone RegistryValueKind = "None"
	// RegistryValueKindQWord - QWord value type
	RegistryValueKindQWord RegistryValueKind = "QWord"
	// RegistryValueKindString - String value type
	RegistryValueKindString RegistryValueKind = "String"
	// RegistryValueKindUnknown - Unknown value type
	RegistryValueKindUnknown RegistryValueKind = "Unknown"
)

// PossibleRegistryValueKindValues returns the possible values for the RegistryValueKind const type.
func PossibleRegistryValueKindValues() []RegistryValueKind {
	return []RegistryValueKind{
		RegistryValueKindBinary,
		RegistryValueKindDWord,
		RegistryValueKindExpandString,
		RegistryValueKindMultiString,
		RegistryValueKindNone,
		RegistryValueKindQWord,
		RegistryValueKindString,
		RegistryValueKindUnknown,
	}
}

// Source - The source of the watchlist
type Source string

const (
	SourceLocalFile     Source = "Local file"
	SourceRemoteStorage Source = "Remote storage"
)

// PossibleSourceValues returns the possible values for the Source const type.
func PossibleSourceValues() []Source {
	return []Source{
		SourceLocalFile,
		SourceRemoteStorage,
	}
}

// TemplateStatus - The alert rule template status.
type TemplateStatus string

const (
	// TemplateStatusAvailable - Alert rule template is available.
	TemplateStatusAvailable TemplateStatus = "Available"
	// TemplateStatusInstalled - Alert rule template installed. and can not use more then once
	TemplateStatusInstalled TemplateStatus = "Installed"
	// TemplateStatusNotAvailable - Alert rule template is not available
	TemplateStatusNotAvailable TemplateStatus = "NotAvailable"
)

// PossibleTemplateStatusValues returns the possible values for the TemplateStatus const type.
func PossibleTemplateStatusValues() []TemplateStatus {
	return []TemplateStatus{
		TemplateStatusAvailable,
		TemplateStatusInstalled,
		TemplateStatusNotAvailable,
	}
}

// ThreatIntelligenceResourceInnerKind - The kind of the threat intelligence entity
type ThreatIntelligenceResourceInnerKind string

const (
	// ThreatIntelligenceResourceInnerKindIndicator - Entity represents threat intelligence indicator in the system.
	ThreatIntelligenceResourceInnerKindIndicator ThreatIntelligenceResourceInnerKind = "indicator"
)

// PossibleThreatIntelligenceResourceInnerKindValues returns the possible values for the ThreatIntelligenceResourceInnerKind const type.
func PossibleThreatIntelligenceResourceInnerKindValues() []ThreatIntelligenceResourceInnerKind {
	return []ThreatIntelligenceResourceInnerKind{
		ThreatIntelligenceResourceInnerKindIndicator,
	}
}

// ThreatIntelligenceSortingOrder - Sorting order (ascending/descending/unsorted).
type ThreatIntelligenceSortingOrder string

const (
	ThreatIntelligenceSortingOrderAscending  ThreatIntelligenceSortingOrder = "ascending"
	ThreatIntelligenceSortingOrderDescending ThreatIntelligenceSortingOrder = "descending"
	ThreatIntelligenceSortingOrderUnsorted   ThreatIntelligenceSortingOrder = "unsorted"
)

// PossibleThreatIntelligenceSortingOrderValues returns the possible values for the ThreatIntelligenceSortingOrder const type.
func PossibleThreatIntelligenceSortingOrderValues() []ThreatIntelligenceSortingOrder {
	return []ThreatIntelligenceSortingOrder{
		ThreatIntelligenceSortingOrderAscending,
		ThreatIntelligenceSortingOrderDescending,
		ThreatIntelligenceSortingOrderUnsorted,
	}
}

// TriggerOperator - The operation against the threshold that triggers alert rule.
type TriggerOperator string

const (
	TriggerOperatorEqual       TriggerOperator = "Equal"
	TriggerOperatorGreaterThan TriggerOperator = "GreaterThan"
	TriggerOperatorLessThan    TriggerOperator = "LessThan"
	TriggerOperatorNotEqual    TriggerOperator = "NotEqual"
)

// PossibleTriggerOperatorValues returns the possible values for the TriggerOperator const type.
func PossibleTriggerOperatorValues() []TriggerOperator {
	return []TriggerOperator{
		TriggerOperatorEqual,
		TriggerOperatorGreaterThan,
		TriggerOperatorLessThan,
		TriggerOperatorNotEqual,
	}
}

type TriggersOn string

const (
	// TriggersOnIncidents - Trigger on Incidents
	TriggersOnIncidents TriggersOn = "Incidents"
)

// PossibleTriggersOnValues returns the possible values for the TriggersOn const type.
func PossibleTriggersOnValues() []TriggersOn {
	return []TriggersOn{
		TriggersOnIncidents,
	}
}

type TriggersWhen string

const (
	// TriggersWhenCreated - Trigger on created objects
	TriggersWhenCreated TriggersWhen = "Created"
)

// PossibleTriggersWhenValues returns the possible values for the TriggersWhen const type.
func PossibleTriggersWhenValues() []TriggersWhen {
	return []TriggersWhen{
		TriggersWhenCreated,
	}
}
