//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicebus

import "time"

// AccessKeys - Namespace/ServiceBus Connection String
type AccessKeys struct {
	// READ-ONLY; Primary connection string of the alias if GEO DR is enabled
	AliasPrimaryConnectionString *string

	// READ-ONLY; Secondary connection string of the alias if GEO DR is enabled
	AliasSecondaryConnectionString *string

	// READ-ONLY; A string that describes the authorization rule.
	KeyName *string

	// READ-ONLY; Primary connection string of the created namespace authorization rule.
	PrimaryConnectionString *string

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string

	// READ-ONLY; Secondary connection string of the created namespace authorization rule.
	SecondaryConnectionString *string

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string
}

// Action - Represents the filter actions which are allowed for the transformation of a message that have been matched by
// a filter expression.
type Action struct {
	// This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
	CompatibilityLevel *int32

	// Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool

	// SQL expression. e.g. MyProperty='ABC'
	SQLExpression *string
}

// ArmDisasterRecovery - Single item in List or Get Alias(Disaster Recovery configuration) operation
type ArmDisasterRecovery struct {
	// Properties required to the Create Or Update Alias(Disaster Recovery configurations)
	Properties *ArmDisasterRecoveryProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string
}

// ArmDisasterRecoveryListResult - The result of the List Alias(Disaster Recovery configuration) operation.
type ArmDisasterRecoveryListResult struct {
	// List of Alias(Disaster Recovery configurations)
	Value []*ArmDisasterRecovery

	// READ-ONLY; Link to the next set of results. Not empty if Value contains incomplete list of Alias(Disaster Recovery configuration)
	NextLink *string
}

// ArmDisasterRecoveryProperties - Properties required to the Create Or Update Alias(Disaster Recovery configurations)
type ArmDisasterRecoveryProperties struct {
	// Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
	AlternateName *string

	// ARM Id of the Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
	PartnerNamespace *string

	// READ-ONLY; Number of entities pending to be replicated.
	PendingReplicationOperationsCount *int64

	// READ-ONLY; Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted' or 'Succeeded'
	// or 'Failed'
	ProvisioningState *ProvisioningStateDR

	// READ-ONLY; role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or 'Secondary'
	Role *RoleDisasterRecovery
}

// CheckNameAvailability - Description of a Check Name availability request properties.
type CheckNameAvailability struct {
	// REQUIRED; The Name to check the namespace name availability and The namespace name can contain only letters, numbers, and
	// hyphens. The namespace must start with a letter, and it must end with a letter or
	// number.
	Name *string
}

// CheckNameAvailabilityResult - Description of a Check Name availability request properties.
type CheckNameAvailabilityResult struct {
	// Value indicating namespace is availability, true if the namespace is available; otherwise, false.
	NameAvailable *bool

	// The reason for unavailability of a namespace.
	Reason *UnavailableReason

	// READ-ONLY; The detailed info regarding the reason associated with the namespace.
	Message *string
}

// ConnectionState information.
type ConnectionState struct {
	// Description of the connection state.
	Description *string

	// Status of the connection.
	Status *PrivateLinkConnectionStatus
}

// CorrelationFilter - Represents the correlation filter expression.
type CorrelationFilter struct {
	// Content type of the message.
	ContentType *string

	// Identifier of the correlation.
	CorrelationID *string

	// Application specific label.
	Label *string

	// Identifier of the message.
	MessageID *string

	// dictionary object for custom filters
	Properties map[string]*string

	// Address of the queue to reply to.
	ReplyTo *string

	// Session identifier to reply to.
	ReplyToSessionID *string

	// Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool

	// Session identifier.
	SessionID *string

	// Address to send to.
	To *string
}

// Encryption - Properties to configure Encryption
type Encryption struct {
	// Enumerates the possible value of keySource for Encryption
	KeySource *string

	// Properties of KeyVault
	KeyVaultProperties []*KeyVaultProperties

	// Enable Infrastructure Encryption (Double Encryption)
	RequireInfrastructureEncryption *bool
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorResponse - The resource management error response.
type ErrorResponse struct {
	// The error object.
	Error *ErrorResponseError
}

// ErrorResponseError - The error object.
type ErrorResponseError struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorResponse

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// FailoverProperties - Safe failover is to indicate the service should wait for pending replication to finish before switching
// to the secondary.
type FailoverProperties struct {
	// Safe failover is to indicate the service should wait for pending replication to finish before switching to the secondary.
	Properties *FailoverPropertiesProperties
}

// FailoverPropertiesProperties - Safe failover is to indicate the service should wait for pending replication to finish before
// switching to the secondary.
type FailoverPropertiesProperties struct {
	// Safe failover is to indicate the service should wait for pending replication to finish before switching to the secondary.
	IsSafeFailover *bool
}

// Identity - Properties to configure User Assigned Identities for Bring your Own Keys
type Identity struct {
	// Type of managed service identity.
	Type *ManagedServiceIdentityType

	// Properties for User Assigned Identities
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; ObjectId from the KeyVault
	PrincipalID *string

	// READ-ONLY; TenantId from the KeyVault
	TenantID *string
}

// KeyVaultProperties - Properties to configure keyVault Properties
type KeyVaultProperties struct {
	Identity *UserAssignedIdentityProperties

	// Name of the Key from KeyVault
	KeyName *string

	// Uri of KeyVault
	KeyVaultURI *string

	// Version of KeyVault
	KeyVersion *string
}

// MessageCountDetails - Message Count Details.
type MessageCountDetails struct {
	// READ-ONLY; Number of active messages in the queue, topic, or subscription.
	ActiveMessageCount *int64

	// READ-ONLY; Number of messages that are dead lettered.
	DeadLetterMessageCount *int64

	// READ-ONLY; Number of scheduled messages.
	ScheduledMessageCount *int64

	// READ-ONLY; Number of messages transferred into dead letters.
	TransferDeadLetterMessageCount *int64

	// READ-ONLY; Number of messages transferred to another queue, topic, or subscription.
	TransferMessageCount *int64
}

// MigrationConfigListResult - The result of the List migrationConfigurations operation.
type MigrationConfigListResult struct {
	// List of Migration Configs
	Value []*MigrationConfigProperties

	// READ-ONLY; Link to the next set of results. Not empty if Value contains incomplete list of migrationConfigurations
	NextLink *string
}

// MigrationConfigProperties - Single item in List or Get Migration Config operation
type MigrationConfigProperties struct {
	// Properties required to the Create Migration Configuration
	Properties *MigrationConfigPropertiesProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string
}

// MigrationConfigPropertiesProperties - Properties required to the Create Migration Configuration
type MigrationConfigPropertiesProperties struct {
	// REQUIRED; Name to access Standard Namespace after migration
	PostMigrationName *string

	// REQUIRED; Existing premium Namespace ARM Id name which has no entities, will be used for migration
	TargetNamespace *string

	// READ-ONLY; State in which Standard to Premium Migration is, possible values : Unknown, Reverting, Completing, Initiating,
	// Syncing, Active
	MigrationState *string

	// READ-ONLY; Number of entities pending to be replicated.
	PendingReplicationOperationsCount *int64

	// READ-ONLY; Provisioning state of Migration Configuration
	ProvisioningState *string
}

// NWRuleSetIPRules - Description of NetWorkRuleSet - IpRules resource.
type NWRuleSetIPRules struct {
	// The IP Filter Action
	Action *NetworkRuleIPAction

	// IP Mask
	IPMask *string
}

// NWRuleSetVirtualNetworkRules - Description of VirtualNetworkRules - NetworkRules resource.
type NWRuleSetVirtualNetworkRules struct {
	// Value that indicates whether to ignore missing VNet Service Endpoint
	IgnoreMissingVnetServiceEndpoint *bool

	// Subnet properties
	Subnet *Subnet
}

// NetworkRuleSet - Description of NetworkRuleSet resource.
type NetworkRuleSet struct {
	// NetworkRuleSet properties
	Properties *NetworkRuleSetProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string
}

// NetworkRuleSetListResult - The response of the List NetworkRuleSet operation.
type NetworkRuleSetListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of NetworkRuleSet.
	NextLink *string

	// Result of the List NetworkRuleSet operation.
	Value []*NetworkRuleSet
}

// NetworkRuleSetProperties - NetworkRuleSet properties
type NetworkRuleSetProperties struct {
	// Default Action for Network Rule Set
	DefaultAction *DefaultAction

	// List of IpRules
	IPRules []*NWRuleSetIPRules

	// This determines if traffic is allowed over public network. By default it is enabled.
	PublicNetworkAccess *PublicNetworkAccessFlag

	// Value that indicates whether Trusted Service Access is Enabled or not.
	TrustedServiceAccessEnabled *bool

	// List VirtualNetwork Rules
	VirtualNetworkRules []*NWRuleSetVirtualNetworkRules
}

// Operation - A Service Bus REST API operation
type Operation struct {
	// Display of the operation
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Origin of the operation
	Origin *string

	// Properties of the operation
	Properties any

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - Operation display payload
type OperationDisplay struct {
	// READ-ONLY; Localized friendly description for the operation
	Description *string

	// READ-ONLY; Localized friendly name for the operation
	Operation *string

	// READ-ONLY; Resource provider of the operation
	Provider *string

	// READ-ONLY; Resource of the operation
	Resource *string
}

// OperationListResult - Result of the request to list ServiceBus operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string

	// READ-ONLY; List of ServiceBus operations supported by the Microsoft.ServiceBus resource provider.
	Value []*Operation
}

// PrivateEndpoint information.
type PrivateEndpoint struct {
	// The ARM identifier for Private Endpoint.
	ID *string
}

// PrivateEndpointConnection - Properties of the PrivateEndpointConnection.
type PrivateEndpointConnection struct {
	// Properties of the PrivateEndpointConnection.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string
}

// PrivateEndpointConnectionListResult - Result of the list of all private endpoint connections operation.
type PrivateEndpointConnectionListResult struct {
	// A link for the next page of private endpoint connection resources.
	NextLink *string

	// A collection of private endpoint connection resources.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// The Private Endpoint resource for this Connection.
	PrivateEndpoint *PrivateEndpoint

	// Details about the state of the connection.
	PrivateLinkServiceConnectionState *ConnectionState

	// Provisioning state of the Private Endpoint Connection.
	ProvisioningState *EndPointProvisioningState
}

// PrivateLinkResource - Information of the private link resource.
type PrivateLinkResource struct {
	// Fully qualified identifier of the resource.
	ID *string

	// Name of the resource
	Name *string

	// Properties of the private link resource.
	Properties *PrivateLinkResourceProperties

	// Type of the resource
	Type *string
}

// PrivateLinkResourceProperties - Properties of PrivateLinkResource
type PrivateLinkResourceProperties struct {
	GroupID *string

	// Required Members
	RequiredMembers []*string

	// Required Zone Names
	RequiredZoneNames []*string
}

// PrivateLinkResourcesListResult - Result of the List private link resources operation.
type PrivateLinkResourcesListResult struct {
	// A link for the next page of private link resources.
	NextLink *string

	// A collection of private link resources
	Value []*PrivateLinkResource
}

// ProxyResource - Common fields that are returned in the response for all Azure Resource Manager resources
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string
}

// RegenerateAccessKeyParameters - Parameters supplied to the Regenerate Authorization Rule operation, specifies which key
// needs to be reset.
type RegenerateAccessKeyParameters struct {
	// REQUIRED; The access key to regenerate.
	KeyType *KeyType

	// Optional, if the key value provided, is reset for KeyType value or autogenerate Key value set for keyType
	Key *string
}

// Resource - The Resource definition for other than namespace.
type Resource struct {
	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ResourceNamespacePatch - The Resource definition.
type ResourceNamespacePatch struct {
	// Resource location
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// Rule - Description of Rule Resource.
type Rule struct {
	// Properties of Rule resource
	Properties *Ruleproperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string
}

// RuleListResult - The response of the List rule operation.
type RuleListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of rules
	NextLink *string

	// Result of the List Rules operation.
	Value []*Rule
}

// Ruleproperties - Description of Rule Resource.
type Ruleproperties struct {
	// Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter
	// expression.
	Action *Action

	// Properties of correlationFilter
	CorrelationFilter *CorrelationFilter

	// Filter type that is evaluated against a BrokeredMessage.
	FilterType *FilterType

	// Properties of sqlFilter
	SQLFilter *SQLFilter
}

// SBAuthorizationRule - Description of a namespace authorization rule.
type SBAuthorizationRule struct {
	// AuthorizationRule properties.
	Properties *SBAuthorizationRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string
}

// SBAuthorizationRuleListResult - The response to the List Namespace operation.
type SBAuthorizationRuleListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Authorization Rules.
	NextLink *string

	// Result of the List Authorization Rules operation.
	Value []*SBAuthorizationRule
}

// SBAuthorizationRuleProperties - AuthorizationRule properties.
type SBAuthorizationRuleProperties struct {
	// REQUIRED; The rights associated with the rule.
	Rights []*AccessRights
}

// SBClientAffineProperties - Properties specific to client affine subscriptions.
type SBClientAffineProperties struct {
	// Indicates the Client ID of the application that created the client-affine subscription.
	ClientID *string

	// For client-affine subscriptions, this value indicates whether the subscription is durable or not.
	IsDurable *bool

	// For client-affine subscriptions, this value indicates whether the subscription is shared or not.
	IsShared *bool
}

// SBNamespace - Description of a namespace resource.
type SBNamespace struct {
	// REQUIRED; The Geo-location where the resource lives
	Location *string

	// Properties of BYOK Identity description
	Identity *Identity

	// Properties of the namespace.
	Properties *SBNamespaceProperties

	// Properties of SKU
	SKU *SBSKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// SBNamespaceListResult - The response of the List Namespace operation.
type SBNamespaceListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Namespaces.
	NextLink *string

	// Result of the List Namespace operation.
	Value []*SBNamespace
}

// SBNamespaceProperties - Properties of the namespace.
type SBNamespaceProperties struct {
	// Alternate name for namespace
	AlternateName *string

	// This property disables SAS authentication for the Service Bus namespace.
	DisableLocalAuth *bool

	// Properties of BYOK Encryption description
	Encryption *Encryption

	// List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// Enabling this property creates a Premium Service Bus Namespace in regions supported availability zones.
	ZoneRedundant *bool

	// READ-ONLY; The time the namespace was created
	CreatedAt *time.Time

	// READ-ONLY; Identifier for Azure Insights metrics
	MetricID *string

	// READ-ONLY; Provisioning state of the namespace.
	ProvisioningState *string

	// READ-ONLY; Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string

	// READ-ONLY; Status of the namespace.
	Status *string

	// READ-ONLY; The time the namespace was updated.
	UpdatedAt *time.Time
}

// SBNamespaceUpdateParameters - Description of a namespace resource.
type SBNamespaceUpdateParameters struct {
	// Properties of BYOK Identity description
	Identity *Identity

	// Resource location
	Location *string

	// Properties of the namespace.
	Properties *SBNamespaceUpdateProperties

	// Properties of SKU
	SKU *SBSKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SBNamespaceUpdateProperties - Properties of the namespace.
type SBNamespaceUpdateProperties struct {
	// Alternate name for namespace
	AlternateName *string

	// This property disables SAS authentication for the Service Bus namespace.
	DisableLocalAuth *bool

	// Properties of BYOK Encryption description
	Encryption *Encryption

	// List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; The time the namespace was created
	CreatedAt *time.Time

	// READ-ONLY; Identifier for Azure Insights metrics
	MetricID *string

	// READ-ONLY; Provisioning state of the namespace.
	ProvisioningState *string

	// READ-ONLY; Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string

	// READ-ONLY; Status of the namespace.
	Status *string

	// READ-ONLY; The time the namespace was updated.
	UpdatedAt *time.Time
}

// SBQueue - Description of queue Resource.
type SBQueue struct {
	// Queue Properties
	Properties *SBQueueProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string
}

// SBQueueListResult - The response to the List Queues operation.
type SBQueueListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of queues.
	NextLink *string

	// Result of the List Queues operation.
	Value []*SBQueue
}

// SBQueueProperties - The Queue Properties definition.
type SBQueueProperties struct {
	// ISO 8061 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string

	// A value that indicates whether this queue has dead letter support when a message expires.
	DeadLetteringOnMessageExpiration *bool

	// ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting from when
	// the message is sent to Service Bus. This is the default value used when
	// TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string

	// ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string

	// Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool

	// A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before
	// writing it to persistent storage.
	EnableExpress *bool

	// A value that indicates whether the queue is to be partitioned across multiple message brokers.
	EnablePartitioning *bool

	// Queue/Topic name to forward the Dead Letter message
	ForwardDeadLetteredMessagesTo *string

	// Queue/Topic name to forward the messages
	ForwardTo *string

	// ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers.
	// The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
	LockDuration *string

	// The maximum delivery count. A message is automatically deadlettered after this number of deliveries. default value is 10.
	MaxDeliveryCount *int32

	// Maximum size (in KB) of the message payload that can be accepted by the queue. This property is only used in Premium today
	// and default is 1024.
	MaxMessageSizeInKilobytes *int64

	// The maximum size of the queue in megabytes, which is the size of memory allocated for the queue. Default is 1024.
	MaxSizeInMegabytes *int32

	// A value indicating if this queue requires duplicate detection.
	RequiresDuplicateDetection *bool

	// A value that indicates whether the queue supports the concept of sessions.
	RequiresSession *bool

	// Enumerates the possible values for the status of a messaging entity.
	Status *EntityStatus

	// READ-ONLY; Last time a message was sent, or the last time there was a receive request to this queue.
	AccessedAt *time.Time

	// READ-ONLY; Message Count Details.
	CountDetails *MessageCountDetails

	// READ-ONLY; The exact time the message was created.
	CreatedAt *time.Time

	// READ-ONLY; The number of messages in the queue.
	MessageCount *int64

	// READ-ONLY; The size of the queue, in bytes.
	SizeInBytes *int64

	// READ-ONLY; The exact time the message was updated.
	UpdatedAt *time.Time
}

// SBSKU - SKU of the namespace.
type SBSKU struct {
	// REQUIRED; Name of this SKU.
	Name *SKUName

	// The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
	Capacity *int32

	// The billing tier of this particular SKU.
	Tier *SKUTier
}

// SBSubscription - Description of subscription resource.
type SBSubscription struct {
	// Properties of subscriptions resource.
	Properties *SBSubscriptionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string
}

// SBSubscriptionListResult - The response to the List Subscriptions operation.
type SBSubscriptionListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of subscriptions.
	NextLink *string

	// Result of the List Subscriptions operation.
	Value []*SBSubscription
}

// SBSubscriptionProperties - Description of Subscription Resource.
type SBSubscriptionProperties struct {
	// ISO 8061 timeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string

	// Properties specific to client affine subscriptions.
	ClientAffineProperties *SBClientAffineProperties

	// Value that indicates whether a subscription has dead letter support on filter evaluation exceptions.
	DeadLetteringOnFilterEvaluationExceptions *bool

	// Value that indicates whether a subscription has dead letter support when a message expires.
	DeadLetteringOnMessageExpiration *bool

	// ISO 8061 Default message timespan to live value. This is the duration after which the message expires, starting from when
	// the message is sent to Service Bus. This is the default value used when
	// TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string

	// ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string

	// Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool

	// Queue/Topic name to forward the Dead Letter message
	ForwardDeadLetteredMessagesTo *string

	// Queue/Topic name to forward the messages
	ForwardTo *string

	// Value that indicates whether the subscription has an affinity to the client id.
	IsClientAffine *bool

	// ISO 8061 lock duration timespan for the subscription. The default value is 1 minute.
	LockDuration *string

	// Number of maximum deliveries.
	MaxDeliveryCount *int32

	// Value indicating if a subscription supports the concept of sessions.
	RequiresSession *bool

	// Enumerates the possible values for the status of a messaging entity.
	Status *EntityStatus

	// READ-ONLY; Last time there was a receive request to this subscription.
	AccessedAt *time.Time

	// READ-ONLY; Message count details
	CountDetails *MessageCountDetails

	// READ-ONLY; Exact time the message was created.
	CreatedAt *time.Time

	// READ-ONLY; Number of messages.
	MessageCount *int64

	// READ-ONLY; The exact time the message was updated.
	UpdatedAt *time.Time
}

// SBTopic - Description of topic resource.
type SBTopic struct {
	// Properties of topic resource.
	Properties *SBTopicProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string
}

// SBTopicListResult - The response to the List Topics operation.
type SBTopicListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of topics.
	NextLink *string

	// Result of the List Topics operation.
	Value []*SBTopic
}

// SBTopicProperties - The Topic Properties definition.
type SBTopicProperties struct {
	// ISO 8601 timespan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string

	// ISO 8601 Default message timespan to live value. This is the duration after which the message expires, starting from when
	// the message is sent to Service Bus. This is the default value used when
	// TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string

	// ISO8601 timespan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string

	// Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool

	// Value that indicates whether Express Entities are enabled. An express topic holds a message in memory temporarily before
	// writing it to persistent storage.
	EnableExpress *bool

	// Value that indicates whether the topic to be partitioned across multiple message brokers is enabled.
	EnablePartitioning *bool

	// Maximum size (in KB) of the message payload that can be accepted by the topic. This property is only used in Premium today
	// and default is 1024.
	MaxMessageSizeInKilobytes *int64

	// Maximum size of the topic in megabytes, which is the size of the memory allocated for the topic. Default is 1024.
	MaxSizeInMegabytes *int32

	// Value indicating if this topic requires duplicate detection.
	RequiresDuplicateDetection *bool

	// Enumerates the possible values for the status of a messaging entity.
	Status *EntityStatus

	// Value that indicates whether the topic supports ordering.
	SupportOrdering *bool

	// READ-ONLY; Last time the message was sent, or a request was received, for this topic.
	AccessedAt *time.Time

	// READ-ONLY; Message count details
	CountDetails *MessageCountDetails

	// READ-ONLY; Exact time the message was created.
	CreatedAt *time.Time

	// READ-ONLY; Size of the topic, in bytes.
	SizeInBytes *int64

	// READ-ONLY; Number of subscriptions.
	SubscriptionCount *int32

	// READ-ONLY; The exact time the message was updated.
	UpdatedAt *time.Time
}

// SQLFilter - Represents a filter which is a composition of an expression and an action that is executed in the pub/sub pipeline.
type SQLFilter struct {
	// This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
	CompatibilityLevel *int32

	// Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool

	// The SQL expression. e.g. MyProperty='ABC'
	SQLExpression *string
}

// SQLRuleAction - Represents set of actions written in SQL language-based syntax that is performed against a ServiceBus.Messaging.BrokeredMessage
type SQLRuleAction struct {
	// This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
	CompatibilityLevel *int32

	// Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool

	// SQL expression. e.g. MyProperty='ABC'
	SQLExpression *string
}

// Subnet - Properties supplied for Subnet
type Subnet struct {
	// REQUIRED; Resource ID of Virtual Network Subnet
	ID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrackedResource - The Resource definition.
type TrackedResource struct {
	// REQUIRED; The Geo-location where the resource lives
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// UserAssignedIdentity - Recognized Dictionary value.
type UserAssignedIdentity struct {
	// READ-ONLY; Client Id of user assigned identity
	ClientID *string

	// READ-ONLY; Principal Id of user assigned identity
	PrincipalID *string
}

type UserAssignedIdentityProperties struct {
	// ARM ID of user Identity selected for encryption
	UserAssignedIdentity *string
}
