//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// SQLPoolVulnerabilityAssessmentScansServer is a fake server for instances of the armsynapse.SQLPoolVulnerabilityAssessmentScansClient type.
type SQLPoolVulnerabilityAssessmentScansServer struct {
	// Export is the fake for method SQLPoolVulnerabilityAssessmentScansClient.Export
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Export func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName armsynapse.VulnerabilityAssessmentName, scanID string, options *armsynapse.SQLPoolVulnerabilityAssessmentScansClientExportOptions) (resp azfake.Responder[armsynapse.SQLPoolVulnerabilityAssessmentScansClientExportResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SQLPoolVulnerabilityAssessmentScansClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName armsynapse.VulnerabilityAssessmentName, scanID string, options *armsynapse.SQLPoolVulnerabilityAssessmentScansClientGetOptions) (resp azfake.Responder[armsynapse.SQLPoolVulnerabilityAssessmentScansClientGetResponse], errResp azfake.ErrorResponder)

	// BeginInitiateScan is the fake for method SQLPoolVulnerabilityAssessmentScansClient.BeginInitiateScan
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginInitiateScan func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName armsynapse.VulnerabilityAssessmentName, scanID string, options *armsynapse.SQLPoolVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (resp azfake.PollerResponder[armsynapse.SQLPoolVulnerabilityAssessmentScansClientInitiateScanResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method SQLPoolVulnerabilityAssessmentScansClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName armsynapse.VulnerabilityAssessmentName, options *armsynapse.SQLPoolVulnerabilityAssessmentScansClientListOptions) (resp azfake.PagerResponder[armsynapse.SQLPoolVulnerabilityAssessmentScansClientListResponse])
}

// NewSQLPoolVulnerabilityAssessmentScansServerTransport creates a new instance of SQLPoolVulnerabilityAssessmentScansServerTransport with the provided implementation.
// The returned SQLPoolVulnerabilityAssessmentScansServerTransport instance is connected to an instance of armsynapse.SQLPoolVulnerabilityAssessmentScansClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLPoolVulnerabilityAssessmentScansServerTransport(srv *SQLPoolVulnerabilityAssessmentScansServer) *SQLPoolVulnerabilityAssessmentScansServerTransport {
	return &SQLPoolVulnerabilityAssessmentScansServerTransport{
		srv:               srv,
		beginInitiateScan: newTracker[azfake.PollerResponder[armsynapse.SQLPoolVulnerabilityAssessmentScansClientInitiateScanResponse]](),
		newListPager:      newTracker[azfake.PagerResponder[armsynapse.SQLPoolVulnerabilityAssessmentScansClientListResponse]](),
	}
}

// SQLPoolVulnerabilityAssessmentScansServerTransport connects instances of armsynapse.SQLPoolVulnerabilityAssessmentScansClient to instances of SQLPoolVulnerabilityAssessmentScansServer.
// Don't use this type directly, use NewSQLPoolVulnerabilityAssessmentScansServerTransport instead.
type SQLPoolVulnerabilityAssessmentScansServerTransport struct {
	srv               *SQLPoolVulnerabilityAssessmentScansServer
	beginInitiateScan *tracker[azfake.PollerResponder[armsynapse.SQLPoolVulnerabilityAssessmentScansClientInitiateScanResponse]]
	newListPager      *tracker[azfake.PagerResponder[armsynapse.SQLPoolVulnerabilityAssessmentScansClientListResponse]]
}

// Do implements the policy.Transporter interface for SQLPoolVulnerabilityAssessmentScansServerTransport.
func (s *SQLPoolVulnerabilityAssessmentScansServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLPoolVulnerabilityAssessmentScansClient.Export":
		resp, err = s.dispatchExport(req)
	case "SQLPoolVulnerabilityAssessmentScansClient.Get":
		resp, err = s.dispatchGet(req)
	case "SQLPoolVulnerabilityAssessmentScansClient.BeginInitiateScan":
		resp, err = s.dispatchBeginInitiateScan(req)
	case "SQLPoolVulnerabilityAssessmentScansClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLPoolVulnerabilityAssessmentScansServerTransport) dispatchExport(req *http.Request) (*http.Response, error) {
	if s.srv.Export == nil {
		return nil, &nonRetriableError{errors.New("fake for method Export not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/export`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsynapse.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsynapse.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Export(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLPoolVulnerabilityAssessmentScansExport, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLPoolVulnerabilityAssessmentScansServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsynapse.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsynapse.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VulnerabilityAssessmentScanRecord, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLPoolVulnerabilityAssessmentScansServerTransport) dispatchBeginInitiateScan(req *http.Request) (*http.Response, error) {
	if s.srv.BeginInitiateScan == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInitiateScan not implemented")}
	}
	beginInitiateScan := s.beginInitiateScan.get(req)
	if beginInitiateScan == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/initiateScan`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsynapse.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsynapse.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginInitiateScan(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInitiateScan = &respr
		s.beginInitiateScan.add(req, beginInitiateScan)
	}

	resp, err := server.PollerResponderNext(beginInitiateScan, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginInitiateScan.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInitiateScan) {
		s.beginInitiateScan.remove(req)
	}

	return resp, nil
}

func (s *SQLPoolVulnerabilityAssessmentScansServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsynapse.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsynapse.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, vulnerabilityAssessmentNameParam, nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsynapse.SQLPoolVulnerabilityAssessmentScansClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
