//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/vmwarecloudsimple/armvmwarecloudsimple"
	"net/http"
	"net/url"
	"regexp"
)

// ResourcePoolsServer is a fake server for instances of the armvmwarecloudsimple.ResourcePoolsClient type.
type ResourcePoolsServer struct {
	// Get is the fake for method ResourcePoolsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, regionID string, pcName string, resourcePoolName string, options *armvmwarecloudsimple.ResourcePoolsClientGetOptions) (resp azfake.Responder[armvmwarecloudsimple.ResourcePoolsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ResourcePoolsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(regionID string, pcName string, options *armvmwarecloudsimple.ResourcePoolsClientListOptions) (resp azfake.PagerResponder[armvmwarecloudsimple.ResourcePoolsClientListResponse])
}

// NewResourcePoolsServerTransport creates a new instance of ResourcePoolsServerTransport with the provided implementation.
// The returned ResourcePoolsServerTransport instance is connected to an instance of armvmwarecloudsimple.ResourcePoolsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewResourcePoolsServerTransport(srv *ResourcePoolsServer) *ResourcePoolsServerTransport {
	return &ResourcePoolsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armvmwarecloudsimple.ResourcePoolsClientListResponse]](),
	}
}

// ResourcePoolsServerTransport connects instances of armvmwarecloudsimple.ResourcePoolsClient to instances of ResourcePoolsServer.
// Don't use this type directly, use NewResourcePoolsServerTransport instead.
type ResourcePoolsServerTransport struct {
	srv          *ResourcePoolsServer
	newListPager *tracker[azfake.PagerResponder[armvmwarecloudsimple.ResourcePoolsClientListResponse]]
}

// Do implements the policy.Transporter interface for ResourcePoolsServerTransport.
func (r *ResourcePoolsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ResourcePoolsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ResourcePoolsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ResourcePoolsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VMwareCloudSimple/locations/(?P<regionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateClouds/(?P<pcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcePools/(?P<resourcePoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	regionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("regionId")])
	if err != nil {
		return nil, err
	}
	pcNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pcName")])
	if err != nil {
		return nil, err
	}
	resourcePoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourcePoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), regionIDParam, pcNameParam, resourcePoolNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourcePool, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourcePoolsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VMwareCloudSimple/locations/(?P<regionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateClouds/(?P<pcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcePools`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		regionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("regionId")])
		if err != nil {
			return nil, err
		}
		pcNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pcName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListPager(regionIDParam, pcNameParam, nil)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armvmwarecloudsimple.ResourcePoolsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}
