//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package backup

import "time"

// FullBackupOperation - Full backup operation
type FullBackupOperation struct {
	// The Azure blob storage container Uri which contains the full backup
	AzureStorageBlobContainerURI *string

	// The end time of the backup operation in UTC
	EndTime *time.Time

	// Error encountered, if any, during the full backup operation.
	Error *ErrorInfo

	// Identifier for the full backup operation.
	JobID *string

	// The start time of the backup operation in UTC
	StartTime *time.Time

	// Status of the backup operation.
	Status *string

	// The status details of backup operation.
	StatusDetails *string
}

// RestoreOperation - Restore operation
type RestoreOperation struct {
	// The end time of the restore operation
	EndTime *time.Time

	// Error encountered, if any, during the restore operation.
	Error *ErrorInfo

	// Identifier for the restore operation.
	JobID *string

	// The start time of the restore operation
	StartTime *time.Time

	// Status of the restore operation.
	Status *string

	// The status details of restore operation.
	StatusDetails *string
}

// RestoreOperationParameters - Parameters for the restore operation
type RestoreOperationParameters struct {
	// REQUIRED; The Folder name of the blob where the previous successful full backup was stored
	FolderToRestore *string

	// REQUIRED; Contains the information required to access blob storage.
	SASTokenParameters *SASTokenParameters
}

// SASTokenParameters - Contains the information required to access blob storage.
type SASTokenParameters struct {
	// REQUIRED; Azure Blob storage container Uri
	StorageResourceURI *string

	// The SAS token pointing to an Azure Blob storage container
	Token *string

	// Indicates which authentication method should be used. If set to true, Managed HSM will use the configured user-assigned
	// managed identity to authenticate with Azure Storage. Otherwise, a SAS token has
	// to be specified.
	UseManagedIdentity *bool
}

// SelectiveKeyRestoreOperation - Selective Key Restore operation
type SelectiveKeyRestoreOperation struct {
	// The end time of the restore operation
	EndTime *time.Time

	// Error encountered, if any, during the selective key restore operation.
	Error *ErrorInfo

	// Identifier for the selective key restore operation.
	JobID *string

	// The start time of the restore operation
	StartTime *time.Time

	// Status of the restore operation.
	Status *string

	// The status details of restore operation.
	StatusDetails *string
}

// SelectiveKeyRestoreOperationParameters - Parameters for the selective restore operation
type SelectiveKeyRestoreOperationParameters struct {
	// REQUIRED; The Folder name of the blob where the previous successful full backup was stored
	Folder *string

	// REQUIRED; Contains the information required to access blob storage.
	SASTokenParameters *SASTokenParameters
}
