// Code generated by smithy-go-codegen DO NOT EDIT.

package querycompatiblerpcv2protocol

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/internal/protocoltest/querycompatiblerpcv2protocol/types"
	smithy "github.com/aws/smithy-go"
	smithycbor "github.com/aws/smithy-go/encoding/cbor"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"strings"
)

type smithyRpcv2cbor_deserializeOpQueryCompatibleOperation struct {
}

func (*smithyRpcv2cbor_deserializeOpQueryCompatibleOperation) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpQueryCompatibleOperation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorQueryCompatibleOperation(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &QueryCompatibleOperationOutput{}

	return out, metadata, nil
}
func deserializeCBOR_CustomCodeError(v smithycbor.Value) (*types.CustomCodeError, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.CustomCodeError{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "message" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Message = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_NoCustomCodeError(v smithycbor.Value) (*types.NoCustomCodeError, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.NoCustomCodeError{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "message" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Message = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_String(v smithycbor.Value) (string, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return "", fmt.Errorf("unexpected value type %T", v)
	}
	return string(av), nil
}
func rpc2_deserializeOpErrorQueryCompatibleOperation(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "NoCustomCodeError":
		verr, err := deserializeCBOR_NoCustomCodeError(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize aws.protocoltests.rpcv2cbor#NoCustomCodeError: %w", err),
				Snapshot: payload,
			}
		}
		if qtype := getAwsQueryErrorCode(resp); len(qtype) > 0 {
			verr.ErrorCodeOverride = ptr.String(qtype)
		}
		return verr
	case "CustomCodeError":
		verr, err := deserializeCBOR_CustomCodeError(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize aws.protocoltests.rpcv2cbor#CustomCodeError: %w", err),
				Snapshot: payload,
			}
		}
		if qtype := getAwsQueryErrorCode(resp); len(qtype) > 0 {
			verr.ErrorCodeOverride = ptr.String(qtype)
		}
		return verr
	default:
		if qtype := getAwsQueryErrorCode(resp); len(qtype) > 0 {
			typ = qtype
		}
		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}
func getProtocolErrorInfo(payload []byte) (typ, msg string, v smithycbor.Value, err error) {
	v, err = smithycbor.Decode(payload)
	if err != nil {
		return "", "", nil, fmt.Errorf("decode: %w", err)
	}

	mv, ok := v.(smithycbor.Map)
	if !ok {
		return "", "", nil, fmt.Errorf("unexpected payload type %T", v)
	}

	if ctyp, ok := mv["__type"]; ok {
		if ttyp, ok := ctyp.(smithycbor.String); ok {
			typ = string(ttyp)
		}
	}

	if cmsg, ok := mv["message"]; ok {
		if tmsg, ok := cmsg.(smithycbor.String); ok {
			msg = string(tmsg)
		}
	}

	return typ, msg, mv, nil
}
func getAwsQueryErrorCode(resp *smithyhttp.Response) string {
	header := resp.Header.Get("x-amzn-query-error")
	if header == "" {
		return ""
	}

	parts := strings.Split(header, ";")
	if len(parts) != 2 {
		return ""
	}

	return parts[0]
}
