// Code generated by smithy-go-codegen DO NOT EDIT.

package amp

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/amp/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an anomaly detector within a workspace using the Random Cut Forest
// algorithm for time-series analysis. The anomaly detector analyzes Amazon Managed
// Service for Prometheus metrics to identify unusual patterns and behaviors.
func (c *Client) CreateAnomalyDetector(ctx context.Context, params *CreateAnomalyDetectorInput, optFns ...func(*Options)) (*CreateAnomalyDetectorOutput, error) {
	if params == nil {
		params = &CreateAnomalyDetectorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAnomalyDetector", params, optFns, c.addOperationCreateAnomalyDetectorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAnomalyDetectorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAnomalyDetectorInput struct {

	// A user-friendly name for the anomaly detector.
	//
	// This member is required.
	Alias *string

	// The algorithm configuration for the anomaly detector.
	//
	// This member is required.
	Configuration types.AnomalyDetectorConfiguration

	// The identifier of the workspace where the anomaly detector will be created.
	//
	// This member is required.
	WorkspaceId *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string

	// The frequency, in seconds, at which the anomaly detector evaluates metrics. The
	// default value is 60 seconds.
	EvaluationIntervalInSeconds *int32

	// The Amazon Managed Service for Prometheus metric labels to associate with the
	// anomaly detector.
	Labels map[string]string

	// Specifies the action to take when data is missing during evaluation.
	MissingDataAction types.AnomalyDetectorMissingDataAction

	// The metadata to apply to the anomaly detector to assist with categorization and
	// organization.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateAnomalyDetectorOutput struct {

	// The unique identifier of the created anomaly detector.
	//
	// This member is required.
	AnomalyDetectorId *string

	// The Amazon Resource Name (ARN) of the created anomaly detector.
	//
	// This member is required.
	Arn *string

	// The status information of the created anomaly detector.
	//
	// This member is required.
	Status *types.AnomalyDetectorStatus

	// The tags applied to the created anomaly detector.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAnomalyDetectorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAnomalyDetector{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAnomalyDetector{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAnomalyDetector"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAnomalyDetectorMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAnomalyDetectorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAnomalyDetector(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateAnomalyDetector struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAnomalyDetector) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAnomalyDetectorInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAnomalyDetectorMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAnomalyDetector{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAnomalyDetector(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAnomalyDetector",
	}
}
