// Code generated by smithy-go-codegen DO NOT EDIT.

package applicationsignals

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/applicationsignals/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns the current grouping configuration for this account, including all
// custom grouping attribute definitions that have been configured. These
// definitions determine how services are logically grouped based on telemetry
// attributes, Amazon Web Services tags, or predefined mappings.
func (c *Client) ListGroupingAttributeDefinitions(ctx context.Context, params *ListGroupingAttributeDefinitionsInput, optFns ...func(*Options)) (*ListGroupingAttributeDefinitionsOutput, error) {
	if params == nil {
		params = &ListGroupingAttributeDefinitionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListGroupingAttributeDefinitions", params, optFns, c.addOperationListGroupingAttributeDefinitionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListGroupingAttributeDefinitionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListGroupingAttributeDefinitionsInput struct {

	// The Amazon Web Services account ID to retrieve grouping attribute definitions
	// for. Use this when accessing grouping configurations from a different account in
	// cross-account monitoring scenarios.
	AwsAccountId *string

	// If you are using this operation in a monitoring account, specify true to
	// include grouping attributes from source accounts in the returned data.
	IncludeLinkedAccounts bool

	// Include this value, if it was returned by the previous operation, to get the
	// next set of grouping attribute definitions.
	NextToken *string

	noSmithyDocumentSerde
}

type ListGroupingAttributeDefinitionsOutput struct {

	// An array of structures, where each structure contains information about one
	// grouping attribute definition, including the grouping name, source keys, and
	// default values.
	//
	// This member is required.
	GroupingAttributeDefinitions []types.GroupingAttributeDefinition

	// Include this value in your next use of this API to get the next set of grouping
	// attribute definitions.
	NextToken *string

	// The timestamp when the grouping configuration was last updated. When used in a
	// raw HTTP Query API, it is formatted as epoch time in seconds.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListGroupingAttributeDefinitionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListGroupingAttributeDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListGroupingAttributeDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListGroupingAttributeDefinitions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListGroupingAttributeDefinitions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListGroupingAttributeDefinitions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListGroupingAttributeDefinitions",
	}
}
