// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A structure that defines a filter for narrowing down results based on specific
// attribute values. This can be used to filter services by platform, environment,
// or other service characteristics.
type AttributeFilter struct {

	// The name of the attribute to filter by, such as Platform , Environment , or
	// BusinessUnit .
	//
	// This member is required.
	AttributeFilterName *string

	// An array of values to match for the specified attribute. Services that have any
	// of these values for the attribute will be included in the results.
	//
	// This member is required.
	AttributeFilterValues []string

	noSmithyDocumentSerde
}

// A structure that contains information about an audit finding, which represents
// an automated analysis result about service behavior, performance issues, or
// potential problems identified through heuristic algorithms.
type AuditFinding struct {

	// The key attributes that identify the service or entity this audit finding
	// relates to. This is a string-to-string map that includes fields like Type, Name,
	// and Environment.
	//
	// This member is required.
	KeyAttributes map[string]string

	// An array of auditor results that contain the specific findings, descriptions,
	// and severity levels identified by different auditing algorithms.
	AuditorResults []AuditorResult

	// A structure containing nodes and edges that represent the dependency
	// relationships relevant to this audit finding, helping to understand the context
	// and potential impact.
	DependencyGraph *DependencyGraph

	// A structure containing metric data queries and time range information that
	// provides context for the audit finding through relevant performance metrics.
	MetricGraph *MetricGraph

	// The name of the operation associated with this audit finding, if the finding is
	// specific to a particular service operation.
	Operation *string

	// The type of audit finding.
	Type *string

	noSmithyDocumentSerde
}

// A structure that contains the result of an automated audit analysis, including
// the auditor name, description of findings, additional data, and severity level.
type AuditorResult struct {

	// The name of the auditor algorithm that generated this result.
	Auditor *string

	// This is a string-to-string map. It contains additional data about the result of
	// an automated audit analysis.
	Data map[string]string

	// A detailed description of the audit finding, explaining what was observed and
	// potential implications.
	Description *string

	// The severity level of this audit finding, indicating the importance and
	// potential impact of the issue.
	Severity Severity

	noSmithyDocumentSerde
}

// A structure that specifies the target entity for audit analysis, such as a
// service , SLO , service_operation , or canary .
type AuditTarget struct {

	// The specific data identifying the audit target entity.
	//
	// This member is required.
	Data AuditTargetEntity

	// The type of entity being audited, such as service , SLO , service_operation , or
	// canary .
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// A union structure that contains the specific entity information for different
// types of audit targets.
//
// The following types satisfy this interface:
//
//	AuditTargetEntityMemberCanary
//	AuditTargetEntityMemberService
//	AuditTargetEntityMemberServiceOperation
//	AuditTargetEntityMemberSlo
type AuditTargetEntity interface {
	isAuditTargetEntity()
}

// Canary entity information when the audit target is a CloudWatch Synthetics
// canary.
type AuditTargetEntityMemberCanary struct {
	Value CanaryEntity

	noSmithyDocumentSerde
}

func (*AuditTargetEntityMemberCanary) isAuditTargetEntity() {}

// Service entity information when the audit target is a service.
type AuditTargetEntityMemberService struct {
	Value ServiceEntity

	noSmithyDocumentSerde
}

func (*AuditTargetEntityMemberService) isAuditTargetEntity() {}

// Service operation entity information when the audit target is a specific
// service operation.
type AuditTargetEntityMemberServiceOperation struct {
	Value ServiceOperationEntity

	noSmithyDocumentSerde
}

func (*AuditTargetEntityMemberServiceOperation) isAuditTargetEntity() {}

// SLO entity information when the audit target is a service level objective.
type AuditTargetEntityMemberSlo struct {
	Value ServiceLevelObjectiveEntity

	noSmithyDocumentSerde
}

func (*AuditTargetEntityMemberSlo) isAuditTargetEntity() {}

// An array of structures, where each structure includes an error indicating that
// one of the requests in the array was not valid.
type BatchUpdateExclusionWindowsError struct {

	// The error code.
	//
	// This member is required.
	ErrorCode *string

	// The error message.
	//
	// This member is required.
	ErrorMessage *string

	// The SLO ID in the error.
	//
	// This member is required.
	SloId *string

	noSmithyDocumentSerde
}

// This object defines the length of the look-back window used to calculate one
// burn rate metric for this SLO. The burn rate measures how fast the service is
// consuming the error budget, relative to the attainment goal of the SLO. A burn
// rate of exactly 1 indicates that the SLO goal will be met exactly.
//
// For example, if you specify 60 as the number of minutes in the look-back
// window, the burn rate is calculated as the following:
//
// burn rate = error rate over the look-back window / (100% - attainment goal
// percentage)
//
// For more information about burn rates, see [Calculate burn rates].
//
// [Calculate burn rates]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html#CloudWatch-ServiceLevelObjectives-burn
type BurnRateConfiguration struct {

	// The number of minutes to use as the look-back window.
	//
	// This member is required.
	LookBackWindowMinutes *int32

	noSmithyDocumentSerde
}

// If the interval for this service level objective is a calendar interval, this
// structure contains the interval specifications.
type CalendarInterval struct {

	// Specifies the duration of each calendar interval. For example, if Duration is 1
	// and DurationUnit is MONTH , each interval is one month, aligned with the
	// calendar.
	//
	// This member is required.
	Duration *int32

	// Specifies the calendar interval unit.
	//
	// This member is required.
	DurationUnit DurationUnit

	// The date and time when you want the first interval to start. Be sure to choose
	// a time that configures the intervals the way that you want. For example, if you
	// want weekly intervals starting on Mondays at 6 a.m., be sure to specify a start
	// time that is a Monday at 6 a.m.
	//
	// When used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// As soon as one calendar interval ends, another automatically begins.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// A structure that contains identifying information for a CloudWatch Synthetics
// canary entity used in audit targeting.
type CanaryEntity struct {

	// The name of the CloudWatch Synthetics canary.
	//
	// This member is required.
	CanaryName *string

	noSmithyDocumentSerde
}

// A structure that contains information about a change event that occurred for a
// service, such as a deployment or configuration change.
type ChangeEvent struct {

	// The Amazon Web Services account ID where this change event occurred.
	//
	// This member is required.
	AccountId *string

	// The type of change event that occurred, such as DEPLOYMENT .
	//
	// This member is required.
	ChangeEventType ChangeEventType

	// The entity (service or resource) that was affected by this change event,
	// including its key attributes.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	//   - AwsAccountId specifies the account where this object is in.
	//
	// Below is an example of a service.
	//
	//     { "Type": "Service", "Name": "visits-service", "Environment": "petclinic-test" }
	//
	// Below is an example of a resource.
	//
	//     { "Type": "AWS::Resource", "ResourceType": "AWS::DynamoDB::Table",
	//     "Identifier": "Customers" }
	//
	// This member is required.
	Entity map[string]string

	// A unique identifier for this change event. For CloudTrail-based events, this is
	// the CloudTrail event id. For other events, this will be Unknown .
	//
	// This member is required.
	EventId *string

	// The Amazon Web Services region where this change event occurred.
	//
	// This member is required.
	Region *string

	// The timestamp when this change event occurred. When used in a raw HTTP Query
	// API, it is formatted as epoch time in seconds.
	//
	// This member is required.
	Timestamp *time.Time

	// The name or description of this change event.
	EventName *string

	// The name of the user who initiated this change event, if available.
	UserName *string

	noSmithyDocumentSerde
}

// Identifies the dependency using the DependencyKeyAttributes and
// DependencyOperationName .
//
// When creating a service dependency SLO, you must specify the KeyAttributes of
// the service, and the DependencyConfig for the dependency. You can specify the
// OperationName of the service, from which it calls the dependency. Alternatively,
// you can exclude OperationName and the SLO will monitor all of the service's
// operations that call the dependency.
type DependencyConfig struct {

	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	// This member is required.
	DependencyKeyAttributes map[string]string

	// The name of the called operation in the dependency.
	//
	// This member is required.
	DependencyOperationName *string

	noSmithyDocumentSerde
}

// A structure that represents the dependency relationships relevant to an audit
// finding, containing nodes and edges that show how services and resources are
// connected.
type DependencyGraph struct {

	// An array of edges representing the connections and relationships between the
	// nodes in the dependency graph.
	Edges []Edge

	// An array of nodes representing the services, resources, or other entities in
	// the dependency graph.
	Nodes []Node

	noSmithyDocumentSerde
}

// A dimension is a name/value pair that is part of the identity of a metric.
// Because dimensions are part of the unique identifier for a metric, whenever you
// add a unique name/value pair to one of your metrics, you are creating a new
// variation of that metric. For example, many Amazon EC2 metrics publish
// InstanceId as a dimension name, and the actual instance ID as the value for that
// dimension.
//
// You can assign up to 30 dimensions to a metric.
type Dimension struct {

	// The name of the dimension. Dimension names must contain only ASCII characters,
	// must include at least one non-whitespace character, and cannot start with a
	// colon ( : ). ASCII control characters are not supported as part of dimension
	// names.
	//
	// This member is required.
	Name *string

	// The value of the dimension. Dimension values must contain only ASCII characters
	// and must include at least one non-whitespace character. ASCII control characters
	// are not supported as part of dimension values.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A structure that represents a connection between two nodes in a dependency
// graph, showing the relationship and characteristics of the connection.
type Edge struct {

	// The type of connection between the nodes, indicating the nature of the
	// relationship.
	ConnectionType ConnectionType

	// The identifier of the destination node in this edge connection.
	DestinationNodeId *string

	// The duration or latency associated with this connection, if applicable.
	Duration *float64

	// The identifier of the source node in this edge connection.
	SourceNodeId *string

	noSmithyDocumentSerde
}

// The core SLO time window exclusion object that includes Window, StartTime,
// RecurrenceRule, and Reason.
type ExclusionWindow struct {

	// The SLO time window exclusion .
	//
	// This member is required.
	Window *Window

	// A description explaining why this time period should be excluded from SLO
	// calculations.
	Reason *string

	// The recurrence rule for the SLO time window exclusion. Supports both cron and
	// rate expressions.
	RecurrenceRule *RecurrenceRule

	// The start of the SLO time window exclusion. Defaults to current time if not
	// specified.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// This structure contains the attributes that determine the goal of an SLO. This
// includes the time period for evaluation and the attainment threshold.
type Goal struct {

	// The threshold that determines if the goal is being met.
	//
	// If this is a period-based SLO, the attainment goal is the percentage of good
	// periods that meet the threshold requirements to the total periods within the
	// interval. For example, an attainment goal of 99.9% means that within your
	// interval, you are targeting 99.9% of the periods to be in healthy state.
	//
	// If this is a request-based SLO, the attainment goal is the percentage of
	// requests that must be successful to meet the attainment goal.
	//
	// If you omit this parameter, 99 is used to represent 99% as the attainment goal.
	AttainmentGoal *float64

	// The time period used to evaluate the SLO. It can be either a calendar interval
	// or rolling interval.
	//
	// If you omit this parameter, a rolling interval of 7 days is used.
	Interval Interval

	// The percentage of remaining budget over total budget that you want to get
	// warnings for. If you omit this parameter, the default of 50.0 is used.
	WarningThreshold *float64

	noSmithyDocumentSerde
}

// A structure that defines how services should be grouped based on specific
// attributes. This includes the friendly name for the grouping, the source keys to
// derive values from, and an optional default value.
type GroupingAttributeDefinition struct {

	// The friendly name for this grouping attribute, such as BusinessUnit or
	// Environment . This name is used to identify the grouping in the console and APIs.
	//
	// This member is required.
	GroupingName *string

	// The default value to use for this grouping attribute when no value can be
	// derived from the source keys. This ensures all services have a grouping value
	// even if the source data is missing.
	DefaultGroupingValue *string

	// An array of source keys used to derive the grouping attribute value from
	// telemetry data, Amazon Web Services tags, or other sources. For example,
	// ["business_unit", "team"] would look for values in those fields.
	GroupingSourceKeys []string

	noSmithyDocumentSerde
}

// A structure that contains the complete grouping configuration for an account,
// including all defined grouping attributes and metadata about when it was last
// updated.
type GroupingConfiguration struct {

	// An array of grouping attribute definitions that specify how services should be
	// grouped based on various attributes and source keys.
	//
	// This member is required.
	GroupingAttributeDefinitions []GroupingAttributeDefinition

	// The timestamp when this grouping configuration was last updated. When used in a
	// raw HTTP Query API, it is formatted as epoch time in seconds.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The time period used to evaluate the SLO. It can be either a calendar interval
// or rolling interval.
//
// The following types satisfy this interface:
//
//	IntervalMemberCalendarInterval
//	IntervalMemberRollingInterval
type Interval interface {
	isInterval()
}

// If the interval is a calendar interval, this structure contains the interval
// specifications.
type IntervalMemberCalendarInterval struct {
	Value CalendarInterval

	noSmithyDocumentSerde
}

func (*IntervalMemberCalendarInterval) isInterval() {}

// If the interval is a rolling interval, this structure contains the interval
// specifications.
type IntervalMemberRollingInterval struct {
	Value RollingInterval

	noSmithyDocumentSerde
}

func (*IntervalMemberRollingInterval) isInterval() {}

// This structure defines the metric used for a service level indicator, including
// the metric name, namespace, and dimensions
type Metric struct {

	// An array of one or more dimensions to use to define the metric that you want to
	// use. For more information, see [Dimensions].
	//
	// [Dimensions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension
	Dimensions []Dimension

	// The name of the metric to use.
	MetricName *string

	// The namespace of the metric. For more information, see [Namespaces].
	//
	// [Namespaces]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace
	Namespace *string

	noSmithyDocumentSerde
}

// Use this structure to define a metric or metric math expression that you want
// to use as for a service level objective.
//
// Each MetricDataQuery in the MetricDataQueries array specifies either a metric
// to retrieve, or a metric math expression to be performed on retrieved metrics. A
// single MetricDataQueries array can include as many as 20 MetricDataQuery
// structures in the array. The 20 structures can include as many as 10 structures
// that contain a MetricStat parameter to retrieve a metric, and as many as 10
// structures that contain the Expression parameter to perform a math expression.
// Of those Expression structures, exactly one must have true as the value for
// ReturnData . The result of this expression used for the SLO.
//
// For more information about metric math expressions, see [CloudWatchUse metric math].
//
// Within each MetricDataQuery object, you must specify either Expression or
// MetricStat but not both.
//
// [CloudWatchUse metric math]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html
type MetricDataQuery struct {

	// A short name used to tie this object to the results in the response. This Id
	// must be unique within a MetricDataQueries array. If you are performing math
	// expressions on this set of data, this name represents that data and can serve as
	// a variable in the metric math expression. The valid characters are letters,
	// numbers, and underscore. The first character must be a lowercase letter.
	//
	// This member is required.
	Id *string

	// The ID of the account where this metric is located. If you are performing this
	// operation in a monitoring account, use this to specify which source account to
	// retrieve this metric from.
	AccountId *string

	// This field can contain a metric math expression to be performed on the other
	// metrics that you are retrieving within this MetricDataQueries structure.
	//
	// A math expression can use the Id of the other metrics or queries to refer to
	// those metrics, and can also use the Id of other expressions to use the result
	// of those expressions. For more information about metric math expressions, see [Metric Math Syntax and Functions]
	// in the Amazon CloudWatch User Guide.
	//
	// Within each MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	//
	// [Metric Math Syntax and Functions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax
	Expression *string

	// A human-readable label for this metric or expression. This is especially useful
	// if this is an expression, so that you know what the value represents. If the
	// metric or expression is shown in a CloudWatch dashboard widget, the label is
	// shown. If Label is omitted, CloudWatch generates a default.
	//
	// You can put dynamic expressions into a label, so that it is more descriptive.
	// For more information, see [Using Dynamic Labels].
	//
	// [Using Dynamic Labels]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html
	Label *string

	// A metric to be used directly for the SLO, or to be used in the math expression
	// that will be used for the SLO.
	//
	// Within one MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	MetricStat *MetricStat

	// The granularity, in seconds, of the returned data points for this metric. For
	// metrics with regular resolution, a period can be as short as one minute (60
	// seconds) and must be a multiple of 60. For high-resolution metrics that are
	// collected at intervals of less than one minute, the period can be 1, 5, 10, 30,
	// 60, or any multiple of 60. High-resolution metrics are those metrics stored by a
	// PutMetricData call that includes a StorageResolution of 1 second.
	//
	// If the StartTime parameter specifies a time stamp that is greater than 3 hours
	// ago, you must specify the period as follows or no data points in that time range
	// is returned:
	//
	//   - Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds
	//   (1 minute).
	//
	//   - Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5
	//   minutes).
	//
	//   - Start time greater than 63 days ago - Use a multiple of 3600 seconds (1
	//   hour).
	Period *int32

	// Use this only if you are using a metric math expression for the SLO. Specify
	// true for ReturnData for only the one expression result to use as the alarm. For
	// all other metrics and expressions in the same CreateServiceLevelObjective
	// operation, specify ReturnData as false .
	ReturnData *bool

	noSmithyDocumentSerde
}

// A structure that contains metric data queries and time range information that
// provides context for audit findings through relevant performance metrics.
type MetricGraph struct {

	// The end time for the metric data included in this graph. When used in a raw
	// HTTP Query API, it is formatted as epoch time in seconds.
	EndTime *time.Time

	// An array of metric data queries that define the metrics to be retrieved and
	// analyzed as part of the audit finding context.
	MetricDataQueries []MetricDataQuery

	// The start time for the metric data included in this graph. When used in a raw
	// HTTP Query API, it is formatted as epoch time in seconds.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// This structure contains information about one CloudWatch metric associated with
// this entity discovered by Application Signals.
type MetricReference struct {

	// The name of the metric.
	//
	// This member is required.
	MetricName *string

	// Used to display the appropriate statistics in the CloudWatch console.
	//
	// This member is required.
	MetricType *string

	// The namespace of the metric. For more information, see [CloudWatchNamespaces].
	//
	// [CloudWatchNamespaces]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace
	//
	// This member is required.
	Namespace *string

	// Amazon Web Services account ID.
	AccountId *string

	// An array of one or more dimensions that further define the metric. For more
	// information, see [CloudWatchDimensions].
	//
	// [CloudWatchDimensions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension
	Dimensions []Dimension

	noSmithyDocumentSerde
}

// This structure defines the metric to be used as the service level indicator,
// along with the statistics, period, and unit.
type MetricStat struct {

	// The metric to use as the service level indicator, including the metric name,
	// namespace, and dimensions.
	//
	// This member is required.
	Metric *Metric

	// The granularity, in seconds, to be used for the metric. For metrics with
	// regular resolution, a period can be as short as one minute (60 seconds) and must
	// be a multiple of 60. For high-resolution metrics that are collected at intervals
	// of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of
	// 60. High-resolution metrics are those metrics stored by a PutMetricData call
	// that includes a StorageResolution of 1 second.
	//
	// This member is required.
	Period *int32

	// The statistic to use for comparison to the threshold. It can be any CloudWatch
	// statistic or extended statistic. For more information about statistics, see [CloudWatch statistics definitions].
	//
	// [CloudWatch statistics definitions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html
	//
	// This member is required.
	Stat *string

	// If you omit Unit then all data that was collected with any unit is returned,
	// along with the corresponding units that were specified when the data was
	// reported to CloudWatch. If you specify a unit, the operation returns only data
	// that was collected with that unit specified. If you specify a unit that does not
	// match the data collected, the results of the operation are null. CloudWatch does
	// not perform unit conversions.
	Unit StandardUnit

	noSmithyDocumentSerde
}

// This structure defines the metric that is used as the "good request" or "bad
// request" value for a request-based SLO. This value observed for the metric
// defined in TotalRequestCountMetric is divided by the number found for
// MonitoredRequestCountMetric to determine the percentage of successful requests
// that this SLO tracks.
//
// The following types satisfy this interface:
//
//	MonitoredRequestCountMetricDataQueriesMemberBadCountMetric
//	MonitoredRequestCountMetricDataQueriesMemberGoodCountMetric
type MonitoredRequestCountMetricDataQueries interface {
	isMonitoredRequestCountMetricDataQueries()
}

// If you want to count "bad requests" to determine the percentage of successful
// requests for this request-based SLO, specify the metric to use as "bad requests"
// in this structure.
type MonitoredRequestCountMetricDataQueriesMemberBadCountMetric struct {
	Value []MetricDataQuery

	noSmithyDocumentSerde
}

func (*MonitoredRequestCountMetricDataQueriesMemberBadCountMetric) isMonitoredRequestCountMetricDataQueries() {
}

// If you want to count "good requests" to determine the percentage of successful
// requests for this request-based SLO, specify the metric to use as "good
// requests" in this structure.
type MonitoredRequestCountMetricDataQueriesMemberGoodCountMetric struct {
	Value []MetricDataQuery

	noSmithyDocumentSerde
}

func (*MonitoredRequestCountMetricDataQueriesMemberGoodCountMetric) isMonitoredRequestCountMetricDataQueries() {
}

// A structure that represents a node in a dependency graph, containing
// information about a service, resource, or other entity and its characteristics.
type Node struct {

	// The key attributes that identify this node, including Type, Name, and
	// Environment information.
	//
	// This member is required.
	KeyAttributes map[string]string

	// The name of the entity represented by this node.
	//
	// This member is required.
	Name *string

	// A unique identifier for this node within the dependency graph.
	//
	// This member is required.
	NodeId *string

	// The duration or processing time associated with this node, if applicable.
	Duration *float64

	// The operation associated with this node, if applicable.
	Operation *string

	// The status of the entity represented by this node.
	Status *string

	// The type of entity represented by this node, such as Service or Resource .
	Type *string

	noSmithyDocumentSerde
}

// The recurrence rule for the SLO time window exclusion .
type RecurrenceRule struct {

	// A cron or rate expression that specifies the schedule for the exclusion window.
	//
	// This member is required.
	Expression *string

	noSmithyDocumentSerde
}

// This structure contains information about the performance metric that a
// request-based SLO monitors.
type RequestBasedServiceLevelIndicator struct {

	// A structure that contains information about the metric that the SLO monitors.
	//
	// This member is required.
	RequestBasedSliMetric *RequestBasedServiceLevelIndicatorMetric

	// The arithmetic operation used when comparing the specified metric to the
	// threshold.
	ComparisonOperator ServiceLevelIndicatorComparisonOperator

	// This value is the threshold that the observed metric values of the SLI metric
	// are compared to.
	MetricThreshold *float64

	noSmithyDocumentSerde
}

// This structure specifies the information about the service and the performance
// metric that a request-based SLO is to monitor.
type RequestBasedServiceLevelIndicatorConfig struct {

	// Use this structure to specify the metric to be used for the SLO.
	//
	// This member is required.
	RequestBasedSliMetricConfig *RequestBasedServiceLevelIndicatorMetricConfig

	// The arithmetic operation to use when comparing the specified metric to the
	// threshold. This parameter is required if this SLO is tracking the Latency
	// metric.
	ComparisonOperator ServiceLevelIndicatorComparisonOperator

	// The value that the SLI metric is compared to. This parameter is required if
	// this SLO is tracking the Latency metric.
	MetricThreshold *float64

	noSmithyDocumentSerde
}

// This structure contains the information about the metric that is used for a
// request-based SLO.
type RequestBasedServiceLevelIndicatorMetric struct {

	// This structure defines the metric that is used as the "good request" or "bad
	// request" value for a request-based SLO. This value observed for the metric
	// defined in TotalRequestCountMetric is divided by the number found for
	// MonitoredRequestCountMetric to determine the percentage of successful requests
	// that this SLO tracks.
	//
	// This member is required.
	MonitoredRequestCountMetric MonitoredRequestCountMetricDataQueries

	// This structure defines the metric that is used as the "total requests" number
	// for a request-based SLO. The number observed for this metric is divided by the
	// number of "good requests" or "bad requests" that is observed for the metric
	// defined in MonitoredRequestCountMetric .
	//
	// This member is required.
	TotalRequestCountMetric []MetricDataQuery

	// Identifies the dependency using the DependencyKeyAttributes and
	// DependencyOperationName .
	DependencyConfig *DependencyConfig

	// This is a string-to-string map that contains information about the type of
	// object that this SLO is related to. It can include the following fields.
	//
	//   - Type designates the type of object that this SLO is related to.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	KeyAttributes map[string]string

	// If the SLO monitors either the LATENCY or AVAILABILITY metric that Application
	// Signals collects, this field displays which of those metrics is used.
	MetricType ServiceLevelIndicatorMetricType

	// If the SLO monitors a specific operation of the service, this field displays
	// that operation name.
	OperationName *string

	noSmithyDocumentSerde
}

// Use this structure to specify the information for the metric that a
// period-based SLO will monitor.
type RequestBasedServiceLevelIndicatorMetricConfig struct {

	// Identifies the dependency using the DependencyKeyAttributes and
	// DependencyOperationName .
	DependencyConfig *DependencyConfig

	// If this SLO is related to a metric collected by Application Signals, you must
	// use this field to specify which service the SLO metric is related to. To do so,
	// you must specify at least the Type , Name , and Environment attributes.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	KeyAttributes map[string]string

	// If the SLO is to monitor either the LATENCY or AVAILABILITY metric that
	// Application Signals collects, use this field to specify which of those metrics
	// is used.
	MetricType ServiceLevelIndicatorMetricType

	// Use this structure to define the metric that you want to use as the "good
	// request" or "bad request" value for a request-based SLO. This value observed for
	// the metric defined in TotalRequestCountMetric will be divided by the number
	// found for MonitoredRequestCountMetric to determine the percentage of successful
	// requests that this SLO tracks.
	MonitoredRequestCountMetric MonitoredRequestCountMetricDataQueries

	// If the SLO is to monitor a specific operation of the service, use this field to
	// specify the name of that operation.
	OperationName *string

	// Use this structure to define the metric that you want to use as the "total
	// requests" number for a request-based SLO. This result will be divided by the
	// "good request" or "bad request" value defined in MonitoredRequestCountMetric .
	TotalRequestCountMetric []MetricDataQuery

	noSmithyDocumentSerde
}

// If the interval for this SLO is a rolling interval, this structure contains the
// interval specifications.
type RollingInterval struct {

	// Specifies the duration of each rolling interval. For example, if Duration is 7
	// and DurationUnit is DAY , each rolling interval is seven days.
	//
	// This member is required.
	Duration *int32

	// Specifies the rolling interval unit.
	//
	// This member is required.
	DurationUnit DurationUnit

	noSmithyDocumentSerde
}

// This structure contains information about one of your services that was
// discovered by Application Signals.
type Service struct {

	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	// This member is required.
	KeyAttributes map[string]string

	// An array of structures that each contain information about one metric
	// associated with this service.
	//
	// This member is required.
	MetricReferences []MetricReference

	// This structure contains one or more string-to-string maps that help identify
	// this service. It can include platform attributes, application attributes, and
	// telemetry attributes.
	//
	// Platform attributes contain information the service's platform.
	//
	//   - PlatformType defines the hosted-in platform.
	//
	//   - EKS.Cluster is the name of the Amazon EKS cluster.
	//
	//   - K8s.Cluster is the name of the self-hosted Kubernetes cluster.
	//
	//   - K8s.Namespace is the name of the Kubernetes namespace in either Amazon EKS
	//   or Kubernetes clusters.
	//
	//   - K8s.Workload is the name of the Kubernetes workload in either Amazon EKS or
	//   Kubernetes clusters.
	//
	//   - K8s.Node is the name of the Kubernetes node in either Amazon EKS or
	//   Kubernetes clusters.
	//
	//   - K8s.Pod is the name of the Kubernetes pod in either Amazon EKS or Kubernetes
	//   clusters.
	//
	//   - EC2.AutoScalingGroup is the name of the Amazon EC2 Auto Scaling group.
	//
	//   - EC2.InstanceId is the ID of the Amazon EC2 instance.
	//
	//   - Host is the name of the host, for all platform types.
	//
	// Application attributes contain information about the application.
	//
	//   - AWS.Application is the application's name in Amazon Web Services Service
	//   Catalog AppRegistry.
	//
	//   - AWS.Application.ARN is the application's ARN in Amazon Web Services Service
	//   Catalog AppRegistry.
	//
	// Telemetry attributes contain telemetry information.
	//
	//   - Telemetry.SDK is the fingerprint of the OpenTelemetry SDK version for
	//   instrumented services.
	//
	//   - Telemetry.Agent is the fingerprint of the agent used to collect and send
	//   telemetry data.
	//
	//   - Telemetry.Source Specifies the point of application where the telemetry was
	//   collected or specifies what was used for the source of telemetry data.
	AttributeMaps []map[string]string

	// An array of string-to-string maps that each contain information about one log
	// group associated with this service. Each string-to-string map includes the
	// following fields:
	//
	//   - "Type": "AWS::Resource"
	//
	//   - "ResourceType": "AWS::Logs::LogGroup"
	//
	//   - "Identifier": "name-of-log-group"
	LogGroupReferences []map[string]string

	// An array of service groups that this service belongs to, based on the
	// configured grouping attributes.
	ServiceGroups []ServiceGroup

	noSmithyDocumentSerde
}

// This structure contains information about one dependency of this service.
type ServiceDependency struct {

	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	// This member is required.
	DependencyKeyAttributes map[string]string

	// The name of the called operation in the dependency.
	//
	// This member is required.
	DependencyOperationName *string

	// An array of structures that each contain information about one metric
	// associated with this service dependency that was discovered by Application
	// Signals.
	//
	// This member is required.
	MetricReferences []MetricReference

	// The name of the operation in this service that calls the dependency.
	//
	// This member is required.
	OperationName *string

	noSmithyDocumentSerde
}

// This structure contains information about a service dependent that was
// discovered by Application Signals. A dependent is an entity that invoked the
// specified service during the provided time range. Dependents include other
// services, CloudWatch Synthetics canaries, and clients that are instrumented with
// CloudWatch RUM app monitors.
type ServiceDependent struct {

	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	// This member is required.
	DependentKeyAttributes map[string]string

	// An array of structures that each contain information about one metric
	// associated with this service dependent that was discovered by Application
	// Signals.
	//
	// This member is required.
	MetricReferences []MetricReference

	// If the dependent invoker was a service that invoked it from an operation, the
	// name of that dependent operation is displayed here.
	DependentOperationName *string

	// If the invoked entity is an operation on an entity, the name of that dependent
	// operation is displayed here.
	OperationName *string

	noSmithyDocumentSerde
}

// A structure that contains identifying information for a service entity.
type ServiceEntity struct {

	// The Amazon Web Services account ID where the service is located. Provide this
	// value only for cross-account access.
	AwsAccountId *string

	// The environment where the service is deployed.
	Environment *string

	// The name of the service.
	Name *string

	// The type of the service entity.
	Type *string

	noSmithyDocumentSerde
}

// A structure that represents a logical grouping of services based on shared
// attributes such as business unit, environment, or entry point.
type ServiceGroup struct {

	// A unique identifier for this grouping attribute value, used for filtering and
	// API operations.
	//
	// This member is required.
	GroupIdentifier *string

	// The name of the grouping attribute, such as BusinessUnit or Environment .
	//
	// This member is required.
	GroupName *string

	// The source of the grouping attribute, such as TAG , OTEL , or DEFAULT .
	//
	// This member is required.
	GroupSource *string

	// The value of the grouping attribute for this service, such as Payments or
	// Production .
	//
	// This member is required.
	GroupValue *string

	noSmithyDocumentSerde
}

// This structure contains information about the performance metric that a
// period-based SLO monitors.
type ServiceLevelIndicator struct {

	// The arithmetic operation used when comparing the specified metric to the
	// threshold.
	//
	// This member is required.
	ComparisonOperator ServiceLevelIndicatorComparisonOperator

	// The value that the SLI metric is compared to.
	//
	// This member is required.
	MetricThreshold *float64

	// A structure that contains information about the metric that the SLO monitors.
	//
	// This member is required.
	SliMetric *ServiceLevelIndicatorMetric

	noSmithyDocumentSerde
}

// This structure specifies the information about the service and the performance
// metric that a period-based SLO is to monitor.
type ServiceLevelIndicatorConfig struct {

	// The arithmetic operation to use when comparing the specified metric to the
	// threshold.
	//
	// This member is required.
	ComparisonOperator ServiceLevelIndicatorComparisonOperator

	// This parameter is used only when a request-based SLO tracks the Latency metric.
	// Specify the threshold value that the observed Latency metric values are to be
	// compared to.
	//
	// This member is required.
	MetricThreshold *float64

	// Use this structure to specify the metric to be used for the SLO.
	//
	// This member is required.
	SliMetricConfig *ServiceLevelIndicatorMetricConfig

	noSmithyDocumentSerde
}

// This structure contains the information about the metric that is used for a
// period-based SLO.
type ServiceLevelIndicatorMetric struct {

	// If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric
	// math expression, this structure includes the information about that metric or
	// expression.
	//
	// This member is required.
	MetricDataQueries []MetricDataQuery

	// Identifies the dependency using the DependencyKeyAttributes and
	// DependencyOperationName .
	DependencyConfig *DependencyConfig

	// This is a string-to-string map that contains information about the type of
	// object that this SLO is related to. It can include the following fields.
	//
	//   - Type designates the type of object that this SLO is related to.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	KeyAttributes map[string]string

	// If the SLO monitors either the LATENCY or AVAILABILITY metric that Application
	// Signals collects, this field displays which of those metrics is used.
	MetricType ServiceLevelIndicatorMetricType

	// If the SLO monitors a specific operation of the service, this field displays
	// that operation name.
	OperationName *string

	noSmithyDocumentSerde
}

// Use this structure to specify the information for the metric that a
// period-based SLO will monitor.
type ServiceLevelIndicatorMetricConfig struct {

	// Identifies the dependency using the DependencyKeyAttributes and
	// DependencyOperationName .
	DependencyConfig *DependencyConfig

	// If this SLO is related to a metric collected by Application Signals, you must
	// use this field to specify which service the SLO metric is related to. To do so,
	// you must specify at least the Type , Name , and Environment attributes.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	KeyAttributes map[string]string

	// If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric
	// math expression, use this structure to specify that metric or expression.
	MetricDataQueries []MetricDataQuery

	// The name of the CloudWatch metric to use for the SLO, when using a custom
	// metric rather than Application Signals standard metrics.
	MetricName *string

	// If the SLO is to monitor either the LATENCY or AVAILABILITY metric that
	// Application Signals collects, use this field to specify which of those metrics
	// is used.
	MetricType ServiceLevelIndicatorMetricType

	// If the SLO is to monitor a specific operation of the service, use this field to
	// specify the name of that operation.
	OperationName *string

	// The number of seconds to use as the period for SLO evaluation. Your
	// application's performance is compared to the SLI during each period. For each
	// period, the application is determined to have either achieved or not achieved
	// the necessary performance.
	PeriodSeconds *int32

	// The statistic to use for comparison to the threshold. It can be any CloudWatch
	// statistic or extended statistic. For more information about statistics, see [CloudWatch statistics definitions].
	//
	// [CloudWatch statistics definitions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html
	Statistic *string

	noSmithyDocumentSerde
}

// A structure containing information about one service level objective (SLO) that
// has been created in Application Signals. Creating SLOs can help you ensure your
// services are performing to the level that you expect. SLOs help you set and
// track a specific target level for the reliability and availability of your
// applications and services. Each SLO uses a service level indicator (SLI), which
// is a key performance metric, to calculate how much underperformance can be
// tolerated before the goal that you set for the SLO is not achieved.
type ServiceLevelObjective struct {

	// The ARN of this SLO.
	//
	// This member is required.
	Arn *string

	// The date and time that this SLO was created. When used in a raw HTTP Query API,
	// it is formatted as yyyy-MM-dd'T'HH:mm:ss . For example, 2019-07-01T23:59:59 .
	//
	// This member is required.
	CreatedTime *time.Time

	// This structure contains the attributes that determine the goal of an SLO. This
	// includes the time period for evaluation and the attainment threshold.
	//
	// This member is required.
	Goal *Goal

	// The time that this SLO was most recently updated. When used in a raw HTTP Query
	// API, it is formatted as yyyy-MM-dd'T'HH:mm:ss . For example, 2019-07-01T23:59:59
	// .
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// The name of this SLO.
	//
	// This member is required.
	Name *string

	// Each object in this array defines the length of the look-back window used to
	// calculate one burn rate metric for this SLO. The burn rate measures how fast the
	// service is consuming the error budget, relative to the attainment goal of the
	// SLO.
	BurnRateConfigurations []BurnRateConfiguration

	// The description that you created for this SLO.
	Description *string

	// Displays whether this is a period-based SLO or a request-based SLO.
	EvaluationType EvaluationType

	// Displays the SLI metric source type for this SLO. Supported types are:
	//
	//   - Service operation
	//
	//   - Service dependency
	//
	//   - CloudWatch metric
	MetricSourceType MetricSourceType

	// A structure containing information about the performance metric that this SLO
	// monitors, if this is a request-based SLO.
	RequestBasedSli *RequestBasedServiceLevelIndicator

	// A structure containing information about the performance metric that this SLO
	// monitors, if this is a period-based SLO.
	Sli *ServiceLevelIndicator

	noSmithyDocumentSerde
}

// A structure containing an SLO budget report that you have requested.
type ServiceLevelObjectiveBudgetReport struct {

	// The ARN of the SLO that this report is for.
	//
	// This member is required.
	Arn *string

	// The status of this SLO, as it relates to the error budget for the entire time
	// interval.
	//
	//   - OK means that the SLO had remaining budget above the warning threshold, as
	//   of the time that you specified in TimeStamp .
	//
	//   - WARNING means that the SLO's remaining budget was below the warning
	//   threshold, as of the time that you specified in TimeStamp .
	//
	//   - BREACHED means that the SLO's budget was exhausted, as of the time that you
	//   specified in TimeStamp .
	//
	//   - INSUFFICIENT_DATA means that the specified start and end times were before
	//   the SLO was created, or that attainment data is missing.
	//
	// This member is required.
	BudgetStatus ServiceLevelObjectiveBudgetStatus

	// The name of the SLO that this report is for.
	//
	// This member is required.
	Name *string

	// A number between 0 and 100 that represents the success percentage of your
	// application compared to the goal set by the SLO.
	//
	// If this is a period-based SLO, the number is the percentage of time periods
	// that the service has attained the SLO's attainment goal, as of the time of the
	// request.
	//
	// If this is a request-based SLO, the number is the number of successful requests
	// divided by the number of total requests, multiplied by 100, during the time
	// range that you specified in your request.
	Attainment *float64

	// This field is displayed only for request-based SLOs. It displays the number of
	// failed requests that can be tolerated before any more successful requests occur,
	// and still have the application meet its SLO goal.
	//
	// This number can go up and down between different reports, based on both how
	// many successful requests and how many failed requests occur in that time.
	BudgetRequestsRemaining *int32

	// The budget amount remaining before the SLO status becomes BREACHING , at the
	// time specified in the Timestemp parameter of the request. If this value is
	// negative, then the SLO is already in BREACHING status.
	//
	// This field is included only if the SLO is a period-based SLO.
	BudgetSecondsRemaining *int32

	// Displays whether this budget report is for a period-based SLO or a
	// request-based SLO.
	EvaluationType EvaluationType

	// This structure contains the attributes that determine the goal of an SLO. This
	// includes the time period for evaluation and the attainment threshold.
	Goal *Goal

	// This structure contains information about the performance metric that a
	// request-based SLO monitors.
	RequestBasedSli *RequestBasedServiceLevelIndicator

	// A structure that contains information about the performance metric that this
	// SLO monitors.
	Sli *ServiceLevelIndicator

	// This field is displayed only for request-based SLOs. It displays the total
	// number of failed requests that can be tolerated during the time range between
	// the start of the interval and the time stamp supplied in the budget report
	// request. It is based on the total number of requests that occurred, and the
	// percentage specified in the attainment goal. If the number of failed requests
	// matches this number or is higher, then this SLO is currently breaching.
	//
	// This number can go up and down between reports with different time stamps,
	// based on both how many total requests occur.
	TotalBudgetRequests *int32

	// The total number of seconds in the error budget for the interval. This field is
	// included only if the SLO is a period-based SLO.
	TotalBudgetSeconds *int32

	noSmithyDocumentSerde
}

// A structure containing information about one error that occurred during a [BatchGetServiceLevelObjectiveBudgetReport]
// operation.
//
// [BatchGetServiceLevelObjectiveBudgetReport]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_BatchGetServiceLevelObjectiveBudgetReport.html
type ServiceLevelObjectiveBudgetReportError struct {

	// The ARN of the SLO that this error is related to.
	//
	// This member is required.
	Arn *string

	// The error code for this error.
	//
	// This member is required.
	ErrorCode *string

	// The message for this error.
	//
	// This member is required.
	ErrorMessage *string

	// The name of the SLO that this error is related to.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A structure that contains identifying information for a service level objective
// entity.
type ServiceLevelObjectiveEntity struct {

	// The ARN of the service level objective. The SLO must be provided with ARN for
	// cross-account access.
	SloArn *string

	// The name of the service level objective.
	SloName *string

	noSmithyDocumentSerde
}

// A structure that contains information about one service level objective (SLO)
// created in Application Signals.
type ServiceLevelObjectiveSummary struct {

	// The ARN of this service level objective.
	//
	// This member is required.
	Arn *string

	// The name of the service level objective.
	//
	// This member is required.
	Name *string

	// The date and time that this service level objective was created. It is
	// expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
	CreatedTime *time.Time

	// Identifies the dependency using the DependencyKeyAttributes and
	// DependencyOperationName .
	DependencyConfig *DependencyConfig

	// Displays whether this is a period-based SLO or a request-based SLO.
	EvaluationType EvaluationType

	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this service level objective is for.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	KeyAttributes map[string]string

	// Displays the SLI metric source type for this SLO. Supported types are:
	//
	//   - Service operation
	//
	//   - Service dependency
	//
	//   - CloudWatch metric
	MetricSourceType MetricSourceType

	// If this service level objective is specific to a single operation, this field
	// displays the name of that operation.
	OperationName *string

	noSmithyDocumentSerde
}

// This structure contains information about an operation discovered by
// Application Signals. An operation is a specific function performed by a service
// that was discovered by Application Signals, and is often an API that is called
// by an upstream dependent.
type ServiceOperation struct {

	// An array of structures that each contain information about one metric
	// associated with this service operation that was discovered by Application
	// Signals.
	//
	// This member is required.
	MetricReferences []MetricReference

	// The name of the operation, discovered by Application Signals.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A structure that contains identifying information for a service operation
// entity.
type ServiceOperationEntity struct {

	// The type of metric associated with this service operation.
	MetricType *string

	// The name of the operation.
	Operation *string

	// The service entity that contains this operation.
	Service *ServiceEntity

	noSmithyDocumentSerde
}

// A structure that contains information about the current state of a service,
// including its latest change events such as deployments and other state-changing
// activities.
type ServiceState struct {

	// An array containing the most recent change events for this service, such as
	// deployments, with information about when they occurred and who initiated them.
	//
	// This member is required.
	LatestChangeEvents []ChangeEvent

	// The key attributes that identify this service, including Type, Name, and
	// Environment information.
	//
	// This member is required.
	Service map[string]string

	// The attribute filters that were applied when retrieving this service state
	// information.
	AttributeFilters []AttributeFilter

	noSmithyDocumentSerde
}

// This structure contains information about one of your services that was
// discovered by Application Signals
type ServiceSummary struct {

	// This is a string-to-string map that help identify the objects discovered by
	// Application Signals. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	// This member is required.
	KeyAttributes map[string]string

	// An array of structures that each contain information about one metric
	// associated with this service.
	//
	// This member is required.
	MetricReferences []MetricReference

	// This structure contains one or more string-to-string maps that help identify
	// this service. It can include platform attributes, application attributes, and
	// telemetry attributes.
	//
	// Platform attributes contain information the service's platform.
	//
	//   - PlatformType defines the hosted-in platform.
	//
	//   - EKS.Cluster is the name of the Amazon EKS cluster.
	//
	//   - K8s.Cluster is the name of the self-hosted Kubernetes cluster.
	//
	//   - K8s.Namespace is the name of the Kubernetes namespace in either Amazon EKS
	//   or Kubernetes clusters.
	//
	//   - K8s.Workload is the name of the Kubernetes workload in either Amazon EKS or
	//   Kubernetes clusters.
	//
	//   - K8s.Node is the name of the Kubernetes node in either Amazon EKS or
	//   Kubernetes clusters.
	//
	//   - K8s.Pod is the name of the Kubernetes pod in either Amazon EKS or Kubernetes
	//   clusters.
	//
	//   - EC2.AutoScalingGroup is the name of the Amazon EC2 Auto Scaling group.
	//
	//   - EC2.InstanceId is the ID of the Amazon EC2 instance.
	//
	//   - Host is the name of the host, for all platform types.
	//
	// Application attributes contain information about the application.
	//
	//   - AWS.Application is the application's name in Amazon Web Services Service
	//   Catalog AppRegistry.
	//
	//   - AWS.Application.ARN is the application's ARN in Amazon Web Services Service
	//   Catalog AppRegistry.
	//
	// Telemetry attributes contain telemetry information.
	//
	//   - Telemetry.SDK is the fingerprint of the OpenTelemetry SDK version for
	//   instrumented services.
	//
	//   - Telemetry.Agent is the fingerprint of the agent used to collect and send
	//   telemetry data.
	//
	//   - Telemetry.Source Specifies the point of application where the telemetry was
	//   collected or specifies what was used for the source of telemetry data.
	AttributeMaps []map[string]string

	// An array of service groups that this service belongs to, based on the
	// configured grouping attributes.
	ServiceGroups []ServiceGroup

	noSmithyDocumentSerde
}

// A key-value pair associated with a resource. Tags can help you organize and
// categorize your resources.
type Tag struct {

	// A string that you can use to assign a value. The combination of tag keys and
	// values can help you organize and categorize your resources.
	//
	// This member is required.
	Key *string

	// The value for the specified tag key.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The object that defines the time length of an exclusion window.
type Window struct {

	// The number of time units for the exclusion window length.
	//
	// This member is required.
	Duration *int32

	// The unit of time for the exclusion window duration. Valid values: MINUTE, HOUR,
	// DAY, MONTH.
	//
	// This member is required.
	DurationUnit DurationUnit

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAuditTargetEntity()                      {}
func (*UnknownUnionMember) isInterval()                               {}
func (*UnknownUnionMember) isMonitoredRequestCountMetricDataQueries() {}
