// Code generated by smithy-go-codegen DO NOT EDIT.

package apprunner

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of the associated App Runner services using an auto scaling
// configuration.
func (c *Client) ListServicesForAutoScalingConfiguration(ctx context.Context, params *ListServicesForAutoScalingConfigurationInput, optFns ...func(*Options)) (*ListServicesForAutoScalingConfigurationOutput, error) {
	if params == nil {
		params = &ListServicesForAutoScalingConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServicesForAutoScalingConfiguration", params, optFns, c.addOperationListServicesForAutoScalingConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServicesForAutoScalingConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServicesForAutoScalingConfigurationInput struct {

	// The Amazon Resource Name (ARN) of the App Runner auto scaling configuration
	// that you want to list the services for.
	//
	// The ARN can be a full auto scaling configuration ARN, or a partial ARN ending
	// with either .../name  or .../name/revision . If a revision isn't specified, the
	// latest active revision is used.
	//
	// This member is required.
	AutoScalingConfigurationArn *string

	// The maximum number of results to include in each response (result page). It's
	// used for a paginated request.
	//
	// If you don't specify MaxResults , the request retrieves all available results in
	// a single response.
	MaxResults *int32

	// A token from a previous result page. It's used for a paginated request. The
	// request retrieves the next result page. All other parameter values must be
	// identical to the ones specified in the initial request.
	//
	// If you don't specify NextToken , the request retrieves the first result page.
	NextToken *string

	noSmithyDocumentSerde
}

type ListServicesForAutoScalingConfigurationOutput struct {

	// A list of service ARN records. In a paginated request, the request returns up
	// to MaxResults records for each call.
	//
	// This member is required.
	ServiceArnList []string

	// The token that you can pass in a subsequent request to get the next result
	// page. It's returned in a paginated request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServicesForAutoScalingConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListServicesForAutoScalingConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListServicesForAutoScalingConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServicesForAutoScalingConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListServicesForAutoScalingConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServicesForAutoScalingConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListServicesForAutoScalingConfigurationPaginatorOptions is the paginator
// options for ListServicesForAutoScalingConfiguration
type ListServicesForAutoScalingConfigurationPaginatorOptions struct {
	// The maximum number of results to include in each response (result page). It's
	// used for a paginated request.
	//
	// If you don't specify MaxResults , the request retrieves all available results in
	// a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListServicesForAutoScalingConfigurationPaginator is a paginator for
// ListServicesForAutoScalingConfiguration
type ListServicesForAutoScalingConfigurationPaginator struct {
	options   ListServicesForAutoScalingConfigurationPaginatorOptions
	client    ListServicesForAutoScalingConfigurationAPIClient
	params    *ListServicesForAutoScalingConfigurationInput
	nextToken *string
	firstPage bool
}

// NewListServicesForAutoScalingConfigurationPaginator returns a new
// ListServicesForAutoScalingConfigurationPaginator
func NewListServicesForAutoScalingConfigurationPaginator(client ListServicesForAutoScalingConfigurationAPIClient, params *ListServicesForAutoScalingConfigurationInput, optFns ...func(*ListServicesForAutoScalingConfigurationPaginatorOptions)) *ListServicesForAutoScalingConfigurationPaginator {
	if params == nil {
		params = &ListServicesForAutoScalingConfigurationInput{}
	}

	options := ListServicesForAutoScalingConfigurationPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListServicesForAutoScalingConfigurationPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListServicesForAutoScalingConfigurationPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListServicesForAutoScalingConfiguration page.
func (p *ListServicesForAutoScalingConfigurationPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListServicesForAutoScalingConfigurationOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListServicesForAutoScalingConfiguration(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListServicesForAutoScalingConfigurationAPIClient is a client that implements
// the ListServicesForAutoScalingConfiguration operation.
type ListServicesForAutoScalingConfigurationAPIClient interface {
	ListServicesForAutoScalingConfiguration(context.Context, *ListServicesForAutoScalingConfigurationInput, ...func(*Options)) (*ListServicesForAutoScalingConfigurationOutput, error)
}

var _ ListServicesForAutoScalingConfigurationAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListServicesForAutoScalingConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServicesForAutoScalingConfiguration",
	}
}
