// Code generated by smithy-go-codegen DO NOT EDIT.

package appsync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appsync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List the resolvers that are associated with a specific function.
func (c *Client) ListResolversByFunction(ctx context.Context, params *ListResolversByFunctionInput, optFns ...func(*Options)) (*ListResolversByFunctionOutput, error) {
	if params == nil {
		params = &ListResolversByFunctionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResolversByFunction", params, optFns, c.addOperationListResolversByFunctionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResolversByFunctionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListResolversByFunctionInput struct {

	// The API ID.
	//
	// This member is required.
	ApiId *string

	// The function ID.
	//
	// This member is required.
	FunctionId *string

	// The maximum number of results that you want the request to return.
	MaxResults int32

	// An identifier that was returned from the previous call to this operation, which
	// you can use to return the next set of items in the list.
	NextToken *string

	noSmithyDocumentSerde
}

type ListResolversByFunctionOutput struct {

	// An identifier that you can use to return the next set of items in the list.
	NextToken *string

	// The list of resolvers.
	Resolvers []types.Resolver

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResolversByFunctionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListResolversByFunction{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListResolversByFunction{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResolversByFunction"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListResolversByFunctionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResolversByFunction(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListResolversByFunctionPaginatorOptions is the paginator options for
// ListResolversByFunction
type ListResolversByFunctionPaginatorOptions struct {
	// The maximum number of results that you want the request to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResolversByFunctionPaginator is a paginator for ListResolversByFunction
type ListResolversByFunctionPaginator struct {
	options   ListResolversByFunctionPaginatorOptions
	client    ListResolversByFunctionAPIClient
	params    *ListResolversByFunctionInput
	nextToken *string
	firstPage bool
}

// NewListResolversByFunctionPaginator returns a new
// ListResolversByFunctionPaginator
func NewListResolversByFunctionPaginator(client ListResolversByFunctionAPIClient, params *ListResolversByFunctionInput, optFns ...func(*ListResolversByFunctionPaginatorOptions)) *ListResolversByFunctionPaginator {
	if params == nil {
		params = &ListResolversByFunctionInput{}
	}

	options := ListResolversByFunctionPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResolversByFunctionPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResolversByFunctionPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResolversByFunction page.
func (p *ListResolversByFunctionPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResolversByFunctionOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListResolversByFunction(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListResolversByFunctionAPIClient is a client that implements the
// ListResolversByFunction operation.
type ListResolversByFunctionAPIClient interface {
	ListResolversByFunction(context.Context, *ListResolversByFunctionInput, ...func(*Options)) (*ListResolversByFunctionOutput, error)
}

var _ ListResolversByFunctionAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListResolversByFunction(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResolversByFunction",
	}
}
