// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Recovers the saved resource identified by an Amazon Resource Name (ARN).
func (c *Client) StartRestoreJob(ctx context.Context, params *StartRestoreJobInput, optFns ...func(*Options)) (*StartRestoreJobOutput, error) {
	if params == nil {
		params = &StartRestoreJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartRestoreJob", params, optFns, c.addOperationStartRestoreJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartRestoreJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartRestoreJobInput struct {

	// A set of metadata key-value pairs.
	//
	// You can get configuration metadata about a resource at the time it was backed
	// up by calling GetRecoveryPointRestoreMetadata . However, values in addition to
	// those provided by GetRecoveryPointRestoreMetadata might be required to restore
	// a resource. For example, you might need to provide a new resource name if the
	// original already exists.
	//
	// For more information about the metadata for each resource, see the following:
	//
	// [Metadata for Amazon Aurora]
	//
	// [Metadata for Amazon DocumentDB]
	//
	// [Metadata for CloudFormation]
	//
	// [Metadata for Amazon DynamoDB]
	//
	// [Metadata for Amazon EBS]
	//
	// [Metadata for Amazon EC2]
	//
	// [Metadata for Amazon EFS]
	//
	// [Metadata for Amazon FSx]
	//
	// [Metadata for Amazon Neptune]
	//
	// [Metadata for Amazon RDS]
	//
	// [Metadata for Amazon Redshift]
	//
	// [Metadata for Storage Gateway]
	//
	// [Metadata for Amazon S3]
	//
	// [Metadata for Amazon Timestream]
	//
	// [Metadata for virtual machines]
	//
	// [Metadata for Amazon Aurora]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-aur.html#aur-restore-cli
	// [Metadata for Amazon RDS]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-rds.html#rds-restore-cli
	// [Metadata for Storage Gateway]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-storage-gateway.html#restoring-sgw-cli
	// [Metadata for Amazon EC2]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-ec2.html#restoring-ec2-cli
	// [Metadata for Amazon Timestream]: https://docs.aws.amazon.com/aws-backup/latest/devguide/timestream-restore.html#timestream-restore-api
	// [Metadata for Amazon EBS]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-ebs.html#ebs-restore-cli
	// [Metadata for Amazon Redshift]: https://docs.aws.amazon.com/aws-backup/latest/devguide/redshift-restores.html#redshift-restore-api
	// [Metadata for Amazon DynamoDB]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-dynamodb.html#ddb-restore-cli
	// [Metadata for Amazon Neptune]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-nep.html#nep-restore-cli
	// [Metadata for Amazon S3]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-s3.html#s3-restore-cli
	// [Metadata for Amazon EFS]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-efs.html#efs-restore-cli
	// [Metadata for virtual machines]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-vm.html#vm-restore-cli
	// [Metadata for CloudFormation]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-application-stacks.html#restoring-cfn-cli
	// [Metadata for Amazon FSx]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-fsx.html#fsx-restore-cli
	// [Metadata for Amazon DocumentDB]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-docdb.html#docdb-restore-cli
	//
	// This member is required.
	Metadata map[string]string

	// An ARN that uniquely identifies a recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45
	// .
	//
	// This member is required.
	RecoveryPointArn *string

	// This is an optional parameter. If this equals True , tags included in the backup
	// will be copied to the restored resource.
	//
	// This can only be applied to backups created through Backup.
	CopySourceTagsToRestoredResource bool

	// The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the
	// target resource; for example: arn:aws:iam::123456789012:role/S3Access .
	IamRoleArn *string

	// A customer-chosen string that you can use to distinguish between otherwise
	// identical calls to StartRestoreJob . Retrying a successful request with the same
	// idempotency token results in a success message with no action taken.
	IdempotencyToken *string

	// Starts a job to restore a recovery point for one of the following resources:
	//
	//   - Aurora - Amazon Aurora
	//
	//   - DocumentDB - Amazon DocumentDB
	//
	//   - CloudFormation - CloudFormation
	//
	//   - DynamoDB - Amazon DynamoDB
	//
	//   - EBS - Amazon Elastic Block Store
	//
	//   - EC2 - Amazon Elastic Compute Cloud
	//
	//   - EFS - Amazon Elastic File System
	//
	//   - FSx - Amazon FSx
	//
	//   - Neptune - Amazon Neptune
	//
	//   - RDS - Amazon Relational Database Service
	//
	//   - Redshift - Amazon Redshift
	//
	//   - Storage Gateway - Storage Gateway
	//
	//   - S3 - Amazon Simple Storage Service
	//
	//   - Timestream - Amazon Timestream
	//
	//   - VirtualMachine - Virtual machines
	ResourceType *string

	noSmithyDocumentSerde
}

type StartRestoreJobOutput struct {

	// Uniquely identifies the job that restores a recovery point.
	RestoreJobId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartRestoreJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartRestoreJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartRestoreJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartRestoreJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartRestoreJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartRestoreJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartRestoreJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartRestoreJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartRestoreJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartRestoreJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartRestoreJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartRestoreJobInput ")
	}

	if input.IdempotencyToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.IdempotencyToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartRestoreJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartRestoreJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartRestoreJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartRestoreJob",
	}
}
