// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Starts scanning jobs for specific resources.
func (c *Client) StartScanJob(ctx context.Context, params *StartScanJobInput, optFns ...func(*Options)) (*StartScanJobOutput, error) {
	if params == nil {
		params = &StartScanJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartScanJob", params, optFns, c.addOperationStartScanJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartScanJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartScanJobInput struct {

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created.
	//
	// Pattern: ^[a-zA-Z0-9\-\_]{2,50}$
	//
	// This member is required.
	BackupVaultName *string

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access .
	//
	// This member is required.
	IamRoleArn *string

	// Specifies the malware scanner used during the scan job. Currently only supports
	// GUARDDUTY .
	//
	// This member is required.
	MalwareScanner types.MalwareScanner

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point. This
	// is your target recovery point for a full scan. If you are running an incremental
	// scan, this will be your a recovery point which has been created after your base
	// recovery point selection.
	//
	// This member is required.
	RecoveryPointArn *string

	// Specifies the scan type use for the scan job.
	//
	// Includes:
	//
	//   - FULL_SCAN will scan the entire data lineage within the backup.
	//
	//   - INCREMENTAL_SCAN will scan the data difference between the target recovery
	//   point and base recovery point ARN.
	//
	// This member is required.
	ScanMode types.ScanMode

	// Specified the IAM scanner role ARN.
	//
	// This member is required.
	ScannerRoleArn *string

	// A customer-chosen string that you can use to distinguish between otherwise
	// identical calls to StartScanJob . Retrying a successful request with the same
	// idempotency token results in a success message with no action taken.
	IdempotencyToken *string

	// An ARN that uniquely identifies the base recovery point to be used for
	// incremental scanning.
	ScanBaseRecoveryPointArn *string

	noSmithyDocumentSerde
}

type StartScanJobOutput struct {

	// The date and time that a backup job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	//
	// This member is required.
	CreationDate *time.Time

	// Uniquely identifies a request to Backup to back up a resource.
	//
	// This member is required.
	ScanJobId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartScanJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartScanJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartScanJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartScanJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartScanJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartScanJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartScanJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartScanJob",
	}
}
