// Code generated by smithy-go-codegen DO NOT EDIT.

package backupsearch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backupsearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operation returns a list of search jobs belonging to an account.
func (c *Client) ListSearchJobs(ctx context.Context, params *ListSearchJobsInput, optFns ...func(*Options)) (*ListSearchJobsOutput, error) {
	if params == nil {
		params = &ListSearchJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSearchJobs", params, optFns, c.addOperationListSearchJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSearchJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSearchJobsInput struct {

	// Include this parameter to filter list by search job status.
	ByStatus types.SearchJobState

	// The maximum number of resource list items to be returned.
	MaxResults *int32

	// The next item following a partial list of returned search jobs.
	//
	// For example, if a request is made to return MaxResults number of backups,
	// NextToken allows you to return more items in your list starting at the location
	// pointed to by the next token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSearchJobsOutput struct {

	// The search jobs among the list, with details of the returned search jobs.
	//
	// This member is required.
	SearchJobs []types.SearchJobSummary

	// The next item following a partial list of returned backups included in a search
	// job.
	//
	// For example, if a request is made to return MaxResults number of backups,
	// NextToken allows you to return more items in your list starting at the location
	// pointed to by the next token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSearchJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSearchJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSearchJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSearchJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSearchJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSearchJobsPaginatorOptions is the paginator options for ListSearchJobs
type ListSearchJobsPaginatorOptions struct {
	// The maximum number of resource list items to be returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSearchJobsPaginator is a paginator for ListSearchJobs
type ListSearchJobsPaginator struct {
	options   ListSearchJobsPaginatorOptions
	client    ListSearchJobsAPIClient
	params    *ListSearchJobsInput
	nextToken *string
	firstPage bool
}

// NewListSearchJobsPaginator returns a new ListSearchJobsPaginator
func NewListSearchJobsPaginator(client ListSearchJobsAPIClient, params *ListSearchJobsInput, optFns ...func(*ListSearchJobsPaginatorOptions)) *ListSearchJobsPaginator {
	if params == nil {
		params = &ListSearchJobsInput{}
	}

	options := ListSearchJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSearchJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSearchJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSearchJobs page.
func (p *ListSearchJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSearchJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSearchJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSearchJobsAPIClient is a client that implements the ListSearchJobs
// operation.
type ListSearchJobsAPIClient interface {
	ListSearchJobs(context.Context, *ListSearchJobsInput, ...func(*Options)) (*ListSearchJobsOutput, error)
}

var _ ListSearchJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSearchJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSearchJobs",
	}
}
