// Code generated by smithy-go-codegen DO NOT EDIT.

package batch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/batch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of Batch jobs that require a specific consumable resource.
func (c *Client) ListJobsByConsumableResource(ctx context.Context, params *ListJobsByConsumableResourceInput, optFns ...func(*Options)) (*ListJobsByConsumableResourceOutput, error) {
	if params == nil {
		params = &ListJobsByConsumableResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListJobsByConsumableResource", params, optFns, c.addOperationListJobsByConsumableResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListJobsByConsumableResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListJobsByConsumableResourceInput struct {

	// The name or ARN of the consumable resource.
	//
	// This member is required.
	ConsumableResource *string

	// The filters to apply to the job list query. If used, only those jobs requiring
	// the specified consumable resource ( consumableResource ) and that match the
	// value of the filters are listed. The filter names and values can be:
	//
	//   - name: JOB_STATUS
	//
	// values: SUBMITTED | PENDING | RUNNABLE | STARTING | RUNNING | SUCCEEDED | FAILED
	//
	//   - name: JOB_NAME
	//
	// The values are case-insensitive matches for the job name. If a filter value
	//   ends with an asterisk (*), it matches any job name that begins with the string
	//   before the '*'.
	Filters []types.KeyValuesPair

	// The maximum number of results returned by ListJobsByConsumableResource in
	// paginated output. When this parameter is used, ListJobsByConsumableResource
	// only returns maxResults results in a single page and a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListJobsByConsumableResource request with the returned nextToken value.
	// This value can be between 1 and 100. If this parameter isn't used, then
	// ListJobsByConsumableResource returns up to 100 results and a nextToken value if
	// applicable.
	MaxResults *int32

	// The nextToken value returned from a previous paginated
	// ListJobsByConsumableResource request where maxResults was used and the results
	// exceeded the value of that parameter. Pagination continues from the end of the
	// previous results that returned the nextToken value. This value is null when
	// there are no more results to return.
	//
	// Treat this token as an opaque identifier that's only used to retrieve the next
	// items in a list and not for other programmatic purposes.
	NextToken *string

	noSmithyDocumentSerde
}

type ListJobsByConsumableResourceOutput struct {

	// The list of jobs that require the specified consumable resources.
	//
	// This member is required.
	Jobs []types.ListJobsByConsumableResourceSummary

	// The nextToken value to include in a future ListJobsByConsumableResource
	// request. When the results of a ListJobsByConsumableResource request exceed
	// maxResults , this value can be used to retrieve the next page of results. This
	// value is null when there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListJobsByConsumableResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListJobsByConsumableResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListJobsByConsumableResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListJobsByConsumableResource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListJobsByConsumableResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListJobsByConsumableResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListJobsByConsumableResourcePaginatorOptions is the paginator options for
// ListJobsByConsumableResource
type ListJobsByConsumableResourcePaginatorOptions struct {
	// The maximum number of results returned by ListJobsByConsumableResource in
	// paginated output. When this parameter is used, ListJobsByConsumableResource
	// only returns maxResults results in a single page and a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListJobsByConsumableResource request with the returned nextToken value.
	// This value can be between 1 and 100. If this parameter isn't used, then
	// ListJobsByConsumableResource returns up to 100 results and a nextToken value if
	// applicable.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListJobsByConsumableResourcePaginator is a paginator for
// ListJobsByConsumableResource
type ListJobsByConsumableResourcePaginator struct {
	options   ListJobsByConsumableResourcePaginatorOptions
	client    ListJobsByConsumableResourceAPIClient
	params    *ListJobsByConsumableResourceInput
	nextToken *string
	firstPage bool
}

// NewListJobsByConsumableResourcePaginator returns a new
// ListJobsByConsumableResourcePaginator
func NewListJobsByConsumableResourcePaginator(client ListJobsByConsumableResourceAPIClient, params *ListJobsByConsumableResourceInput, optFns ...func(*ListJobsByConsumableResourcePaginatorOptions)) *ListJobsByConsumableResourcePaginator {
	if params == nil {
		params = &ListJobsByConsumableResourceInput{}
	}

	options := ListJobsByConsumableResourcePaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListJobsByConsumableResourcePaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListJobsByConsumableResourcePaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListJobsByConsumableResource page.
func (p *ListJobsByConsumableResourcePaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListJobsByConsumableResourceOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListJobsByConsumableResource(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListJobsByConsumableResourceAPIClient is a client that implements the
// ListJobsByConsumableResource operation.
type ListJobsByConsumableResourceAPIClient interface {
	ListJobsByConsumableResource(context.Context, *ListJobsByConsumableResourceInput, ...func(*Options)) (*ListJobsByConsumableResourceOutput, error)
}

var _ ListJobsByConsumableResourceAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListJobsByConsumableResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListJobsByConsumableResource",
	}
}
