// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new workload estimate to model costs for a specific workload.
func (c *Client) CreateWorkloadEstimate(ctx context.Context, params *CreateWorkloadEstimateInput, optFns ...func(*Options)) (*CreateWorkloadEstimateOutput, error) {
	if params == nil {
		params = &CreateWorkloadEstimateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWorkloadEstimate", params, optFns, c.addOperationCreateWorkloadEstimateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWorkloadEstimateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWorkloadEstimateInput struct {

	//  A descriptive name for the workload estimate.
	//
	// This member is required.
	Name *string

	//  A unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string

	//  The type of pricing rates to use for the estimate.
	RateType types.WorkloadEstimateRateType

	//  The tags to apply to the workload estimate.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Mixin for common fields returned by CRUD APIs
type CreateWorkloadEstimateOutput struct {

	//  The unique identifier for the created workload estimate.
	//
	// This member is required.
	Id *string

	//  The currency of the estimated cost.
	CostCurrency types.CurrencyCode

	//  The timestamp when the workload estimate was created.
	CreatedAt *time.Time

	//  The timestamp when the workload estimate will expire.
	ExpiresAt *time.Time

	//  An error message if the workload estimate creation failed.
	FailureMessage *string

	//  The name of the created workload estimate.
	Name *string

	//  The timestamp of the pricing rates used for the estimate.
	RateTimestamp *time.Time

	//  The type of pricing rates used for the estimate.
	RateType types.WorkloadEstimateRateType

	//  The current status of the workload estimate.
	Status types.WorkloadEstimateStatus

	//  The total estimated cost for the workload.
	TotalCost *float64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWorkloadEstimateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateWorkloadEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateWorkloadEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWorkloadEstimate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateWorkloadEstimateMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWorkloadEstimateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWorkloadEstimate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateWorkloadEstimate struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateWorkloadEstimate) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateWorkloadEstimate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateWorkloadEstimateInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateWorkloadEstimateInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateWorkloadEstimateMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateWorkloadEstimate{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateWorkloadEstimate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWorkloadEstimate",
	}
}
