// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all bill scenarios for the account.
func (c *Client) ListBillScenarios(ctx context.Context, params *ListBillScenariosInput, optFns ...func(*Options)) (*ListBillScenariosOutput, error) {
	if params == nil {
		params = &ListBillScenariosInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBillScenarios", params, optFns, c.addOperationListBillScenariosMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBillScenariosOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBillScenariosInput struct {

	//  Filter bill scenarios based on the creation date.
	CreatedAtFilter *types.FilterTimestamp

	//  Filter bill scenarios based on the expiration date.
	ExpiresAtFilter *types.FilterTimestamp

	//  Filters to apply to the list of bill scenarios.
	Filters []types.ListBillScenariosFilter

	//  The maximum number of results to return per page.
	MaxResults *int32

	//  A token to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListBillScenariosOutput struct {

	//  The list of bill scenarios for the account.
	Items []types.BillScenarioSummary

	//  A token to retrieve the next page of results, if any.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBillScenariosMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListBillScenarios{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListBillScenarios{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBillScenarios"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListBillScenariosValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBillScenarios(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListBillScenariosPaginatorOptions is the paginator options for ListBillScenarios
type ListBillScenariosPaginatorOptions struct {
	//  The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBillScenariosPaginator is a paginator for ListBillScenarios
type ListBillScenariosPaginator struct {
	options   ListBillScenariosPaginatorOptions
	client    ListBillScenariosAPIClient
	params    *ListBillScenariosInput
	nextToken *string
	firstPage bool
}

// NewListBillScenariosPaginator returns a new ListBillScenariosPaginator
func NewListBillScenariosPaginator(client ListBillScenariosAPIClient, params *ListBillScenariosInput, optFns ...func(*ListBillScenariosPaginatorOptions)) *ListBillScenariosPaginator {
	if params == nil {
		params = &ListBillScenariosInput{}
	}

	options := ListBillScenariosPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBillScenariosPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBillScenariosPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBillScenarios page.
func (p *ListBillScenariosPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBillScenariosOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBillScenarios(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBillScenariosAPIClient is a client that implements the ListBillScenarios
// operation.
type ListBillScenariosAPIClient interface {
	ListBillScenarios(context.Context, *ListBillScenariosInput, ...func(*Options)) (*ListBillScenariosOutput, error)
}

var _ ListBillScenariosAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBillScenarios(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBillScenarios",
	}
}
