// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmrecommendedactions

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmrecommendedactions/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of recommended actions that match the filter criteria.
func (c *Client) ListRecommendedActions(ctx context.Context, params *ListRecommendedActionsInput, optFns ...func(*Options)) (*ListRecommendedActionsOutput, error) {
	if params == nil {
		params = &ListRecommendedActionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRecommendedActions", params, optFns, c.addOperationListRecommendedActionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRecommendedActionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRecommendedActionsInput struct {

	// The criteria that you want all returned recommended actions to match.
	Filter *types.RequestFilter

	// The maximum number of results to return in the response.
	MaxResults *int32

	// The pagination token that indicates the next set of results that you want to
	// retrieve.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRecommendedActionsOutput struct {

	// The list of recommended actions that satisfy the filter criteria.
	//
	// This member is required.
	RecommendedActions []types.RecommendedAction

	// The pagination token that indicates the next set of results that you want to
	// retrieve.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRecommendedActionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListRecommendedActions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListRecommendedActions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRecommendedActions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListRecommendedActionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRecommendedActions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRecommendedActionsPaginatorOptions is the paginator options for
// ListRecommendedActions
type ListRecommendedActionsPaginatorOptions struct {
	// The maximum number of results to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRecommendedActionsPaginator is a paginator for ListRecommendedActions
type ListRecommendedActionsPaginator struct {
	options   ListRecommendedActionsPaginatorOptions
	client    ListRecommendedActionsAPIClient
	params    *ListRecommendedActionsInput
	nextToken *string
	firstPage bool
}

// NewListRecommendedActionsPaginator returns a new ListRecommendedActionsPaginator
func NewListRecommendedActionsPaginator(client ListRecommendedActionsAPIClient, params *ListRecommendedActionsInput, optFns ...func(*ListRecommendedActionsPaginatorOptions)) *ListRecommendedActionsPaginator {
	if params == nil {
		params = &ListRecommendedActionsInput{}
	}

	options := ListRecommendedActionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRecommendedActionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRecommendedActionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRecommendedActions page.
func (p *ListRecommendedActionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRecommendedActionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRecommendedActions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRecommendedActionsAPIClient is a client that implements the
// ListRecommendedActions operation.
type ListRecommendedActionsAPIClient interface {
	ListRecommendedActions(context.Context, *ListRecommendedActionsInput, ...func(*Options)) (*ListRecommendedActionsOutput, error)
}

var _ ListRecommendedActionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRecommendedActions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRecommendedActions",
	}
}
