// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a batch inference job to invoke a model on multiple prompts. Format
// your data according to [Format your inference data]and upload it to an Amazon S3 bucket. For more
// information, see [Process multiple prompts with batch inference].
//
// The response returns a jobArn that you can use to stop or get details about the
// job.
//
// [Process multiple prompts with batch inference]: https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference.html
// [Format your inference data]: https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data
func (c *Client) CreateModelInvocationJob(ctx context.Context, params *CreateModelInvocationJobInput, optFns ...func(*Options)) (*CreateModelInvocationJobOutput, error) {
	if params == nil {
		params = &CreateModelInvocationJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateModelInvocationJob", params, optFns, c.addOperationCreateModelInvocationJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateModelInvocationJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateModelInvocationJobInput struct {

	// Details about the location of the input to the batch inference job.
	//
	// This member is required.
	InputDataConfig types.ModelInvocationJobInputDataConfig

	// A name to give the batch inference job.
	//
	// This member is required.
	JobName *string

	// The unique identifier of the foundation model to use for the batch inference
	// job.
	//
	// This member is required.
	ModelId *string

	// Details about the location of the output of the batch inference job.
	//
	// This member is required.
	OutputDataConfig types.ModelInvocationJobOutputDataConfig

	// The Amazon Resource Name (ARN) of the service role with permissions to carry
	// out and manage batch inference. You can use the console to create a default
	// service role or follow the steps at [Create a service role for batch inference].
	//
	// [Create a service role for batch inference]: https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html
	//
	// This member is required.
	RoleArn *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientRequestToken *string

	// Any tags to associate with the batch inference job. For more information, see [Tagging Amazon Bedrock resources].
	//
	// [Tagging Amazon Bedrock resources]: https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html
	Tags []types.Tag

	// The number of hours after which to force the batch inference job to time out.
	TimeoutDurationInHours *int32

	// The configuration of the Virtual Private Cloud (VPC) for the data in the batch
	// inference job. For more information, see [Protect batch inference jobs using a VPC].
	//
	// [Protect batch inference jobs using a VPC]: https://docs.aws.amazon.com/bedrock/latest/userguide/batch-vpc
	VpcConfig *types.VpcConfig

	noSmithyDocumentSerde
}

type CreateModelInvocationJobOutput struct {

	// The Amazon Resource Name (ARN) of the batch inference job.
	//
	// This member is required.
	JobArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateModelInvocationJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateModelInvocationJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateModelInvocationJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateModelInvocationJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateModelInvocationJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateModelInvocationJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateModelInvocationJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateModelInvocationJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateModelInvocationJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateModelInvocationJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateModelInvocationJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateModelInvocationJobInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateModelInvocationJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateModelInvocationJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateModelInvocationJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateModelInvocationJob",
	}
}
