// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the resulting assets from a completed Automated Reasoning policy
// build workflow, including build logs, quality reports, and generated policy
// artifacts.
func (c *Client) GetAutomatedReasoningPolicyBuildWorkflowResultAssets(ctx context.Context, params *GetAutomatedReasoningPolicyBuildWorkflowResultAssetsInput, optFns ...func(*Options)) (*GetAutomatedReasoningPolicyBuildWorkflowResultAssetsOutput, error) {
	if params == nil {
		params = &GetAutomatedReasoningPolicyBuildWorkflowResultAssetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAutomatedReasoningPolicyBuildWorkflowResultAssets", params, optFns, c.addOperationGetAutomatedReasoningPolicyBuildWorkflowResultAssetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAutomatedReasoningPolicyBuildWorkflowResultAssetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAutomatedReasoningPolicyBuildWorkflowResultAssetsInput struct {

	// The type of asset to retrieve (e.g., BUILD_LOG, QUALITY_REPORT,
	// POLICY_DEFINITION).
	//
	// This member is required.
	AssetType types.AutomatedReasoningPolicyBuildResultAssetType

	// The unique identifier of the build workflow whose result assets you want to
	// retrieve.
	//
	// This member is required.
	BuildWorkflowId *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy whose build
	// workflow assets you want to retrieve.
	//
	// This member is required.
	PolicyArn *string

	noSmithyDocumentSerde
}

type GetAutomatedReasoningPolicyBuildWorkflowResultAssetsOutput struct {

	// The unique identifier of the build workflow.
	//
	// This member is required.
	BuildWorkflowId *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy.
	//
	// This member is required.
	PolicyArn *string

	// The requested build workflow asset. This is a union type that returns only one
	// of the available asset types (logs, reports, or generated artifacts) based on
	// the specific asset type requested in the API call.
	BuildWorkflowAssets types.AutomatedReasoningPolicyBuildResultAssets

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAutomatedReasoningPolicyBuildWorkflowResultAssetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAutomatedReasoningPolicyBuildWorkflowResultAssets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAutomatedReasoningPolicyBuildWorkflowResultAssets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAutomatedReasoningPolicyBuildWorkflowResultAssets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAutomatedReasoningPolicyBuildWorkflowResultAssetsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAutomatedReasoningPolicyBuildWorkflowResultAssets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAutomatedReasoningPolicyBuildWorkflowResultAssets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAutomatedReasoningPolicyBuildWorkflowResultAssets",
	}
}
