// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the account-level enforced guardrail configurations.
func (c *Client) ListEnforcedGuardrailsConfiguration(ctx context.Context, params *ListEnforcedGuardrailsConfigurationInput, optFns ...func(*Options)) (*ListEnforcedGuardrailsConfigurationOutput, error) {
	if params == nil {
		params = &ListEnforcedGuardrailsConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEnforcedGuardrailsConfiguration", params, optFns, c.addOperationListEnforcedGuardrailsConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEnforcedGuardrailsConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEnforcedGuardrailsConfigurationInput struct {

	// Opaque continuation token of previous paginated response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEnforcedGuardrailsConfigurationOutput struct {

	// Array of AccountEnforcedGuardrailOutputConfiguration objects.
	//
	// This member is required.
	GuardrailsConfig []types.AccountEnforcedGuardrailOutputConfiguration

	// Opaque continuation token of previous paginated response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEnforcedGuardrailsConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEnforcedGuardrailsConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEnforcedGuardrailsConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEnforcedGuardrailsConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEnforcedGuardrailsConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListEnforcedGuardrailsConfigurationPaginatorOptions is the paginator options
// for ListEnforcedGuardrailsConfiguration
type ListEnforcedGuardrailsConfigurationPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEnforcedGuardrailsConfigurationPaginator is a paginator for
// ListEnforcedGuardrailsConfiguration
type ListEnforcedGuardrailsConfigurationPaginator struct {
	options   ListEnforcedGuardrailsConfigurationPaginatorOptions
	client    ListEnforcedGuardrailsConfigurationAPIClient
	params    *ListEnforcedGuardrailsConfigurationInput
	nextToken *string
	firstPage bool
}

// NewListEnforcedGuardrailsConfigurationPaginator returns a new
// ListEnforcedGuardrailsConfigurationPaginator
func NewListEnforcedGuardrailsConfigurationPaginator(client ListEnforcedGuardrailsConfigurationAPIClient, params *ListEnforcedGuardrailsConfigurationInput, optFns ...func(*ListEnforcedGuardrailsConfigurationPaginatorOptions)) *ListEnforcedGuardrailsConfigurationPaginator {
	if params == nil {
		params = &ListEnforcedGuardrailsConfigurationInput{}
	}

	options := ListEnforcedGuardrailsConfigurationPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEnforcedGuardrailsConfigurationPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEnforcedGuardrailsConfigurationPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEnforcedGuardrailsConfiguration page.
func (p *ListEnforcedGuardrailsConfigurationPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEnforcedGuardrailsConfigurationOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEnforcedGuardrailsConfiguration(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEnforcedGuardrailsConfigurationAPIClient is a client that implements the
// ListEnforcedGuardrailsConfiguration operation.
type ListEnforcedGuardrailsConfigurationAPIClient interface {
	ListEnforcedGuardrailsConfiguration(context.Context, *ListEnforcedGuardrailsConfigurationInput, ...func(*Options)) (*ListEnforcedGuardrailsConfigurationOutput, error)
}

var _ ListEnforcedGuardrailsConfigurationAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEnforcedGuardrailsConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEnforcedGuardrailsConfiguration",
	}
}
