// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a list of model copy jobs that you have submitted. You can filter the
// jobs to return based on one or more criteria. For more information, see [Copy models to be used in other regions]in the [Amazon Bedrock User Guide].
//
// [Copy models to be used in other regions]: https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html
// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html
func (c *Client) ListModelCopyJobs(ctx context.Context, params *ListModelCopyJobsInput, optFns ...func(*Options)) (*ListModelCopyJobsOutput, error) {
	if params == nil {
		params = &ListModelCopyJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListModelCopyJobs", params, optFns, c.addOperationListModelCopyJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListModelCopyJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListModelCopyJobsInput struct {

	// Filters for model copy jobs created after the specified time.
	CreationTimeAfter *time.Time

	// Filters for model copy jobs created before the specified time.
	CreationTimeBefore *time.Time

	// The maximum number of results to return in the response. If the total number of
	// results is greater than this value, use the token returned in the response in
	// the nextToken field when making another request to return the next batch of
	// results.
	MaxResults *int32

	// If the total number of results is greater than the maxResults value provided in
	// the request, enter the token returned in the nextToken field in the response in
	// this field to return the next batch of results.
	NextToken *string

	// The field to sort by in the returned list of model copy jobs.
	SortBy types.SortJobsBy

	// Specifies whether to sort the results in ascending or descending order.
	SortOrder types.SortOrder

	// Filters for model copy jobs in which the account that the source model belongs
	// to is equal to the value that you specify.
	SourceAccountEquals *string

	// Filters for model copy jobs in which the Amazon Resource Name (ARN) of the
	// source model to is equal to the value that you specify.
	SourceModelArnEquals *string

	// Filters for model copy jobs whose status matches the value that you specify.
	StatusEquals types.ModelCopyJobStatus

	// Filters for model copy jobs in which the name of the copied model contains the
	// string that you specify.
	TargetModelNameContains *string

	noSmithyDocumentSerde
}

type ListModelCopyJobsOutput struct {

	// A list of information about each model copy job.
	ModelCopyJobSummaries []types.ModelCopyJobSummary

	// If the total number of results is greater than the maxResults value provided in
	// the request, use this token when making another request in the nextToken field
	// to return the next batch of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListModelCopyJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListModelCopyJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListModelCopyJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListModelCopyJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListModelCopyJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListModelCopyJobsPaginatorOptions is the paginator options for ListModelCopyJobs
type ListModelCopyJobsPaginatorOptions struct {
	// The maximum number of results to return in the response. If the total number of
	// results is greater than this value, use the token returned in the response in
	// the nextToken field when making another request to return the next batch of
	// results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListModelCopyJobsPaginator is a paginator for ListModelCopyJobs
type ListModelCopyJobsPaginator struct {
	options   ListModelCopyJobsPaginatorOptions
	client    ListModelCopyJobsAPIClient
	params    *ListModelCopyJobsInput
	nextToken *string
	firstPage bool
}

// NewListModelCopyJobsPaginator returns a new ListModelCopyJobsPaginator
func NewListModelCopyJobsPaginator(client ListModelCopyJobsAPIClient, params *ListModelCopyJobsInput, optFns ...func(*ListModelCopyJobsPaginatorOptions)) *ListModelCopyJobsPaginator {
	if params == nil {
		params = &ListModelCopyJobsInput{}
	}

	options := ListModelCopyJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListModelCopyJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListModelCopyJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListModelCopyJobs page.
func (p *ListModelCopyJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListModelCopyJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListModelCopyJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListModelCopyJobsAPIClient is a client that implements the ListModelCopyJobs
// operation.
type ListModelCopyJobsAPIClient interface {
	ListModelCopyJobs(context.Context, *ListModelCopyJobsInput, ...func(*Options)) (*ListModelCopyJobsOutput, error)
}

var _ ListModelCopyJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListModelCopyJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListModelCopyJobs",
	}
}
