// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the annotations for an Automated Reasoning policy build workflow. This
// allows you to modify extracted rules, variables, and types before finalizing the
// policy.
func (c *Client) UpdateAutomatedReasoningPolicyAnnotations(ctx context.Context, params *UpdateAutomatedReasoningPolicyAnnotationsInput, optFns ...func(*Options)) (*UpdateAutomatedReasoningPolicyAnnotationsOutput, error) {
	if params == nil {
		params = &UpdateAutomatedReasoningPolicyAnnotationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAutomatedReasoningPolicyAnnotations", params, optFns, c.addOperationUpdateAutomatedReasoningPolicyAnnotationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAutomatedReasoningPolicyAnnotationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAutomatedReasoningPolicyAnnotationsInput struct {

	// The updated annotations containing modified rules, variables, and types for the
	// policy.
	//
	// This member is required.
	Annotations []types.AutomatedReasoningPolicyAnnotation

	// The unique identifier of the build workflow whose annotations you want to
	// update.
	//
	// This member is required.
	BuildWorkflowId *string

	// The hash value of the annotation set that you're updating. This is used for
	// optimistic concurrency control to prevent conflicting updates.
	//
	// This member is required.
	LastUpdatedAnnotationSetHash *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy whose
	// annotations you want to update.
	//
	// This member is required.
	PolicyArn *string

	noSmithyDocumentSerde
}

type UpdateAutomatedReasoningPolicyAnnotationsOutput struct {

	// The new hash value representing the updated state of the annotations.
	//
	// This member is required.
	AnnotationSetHash *string

	// The unique identifier of the build workflow.
	//
	// This member is required.
	BuildWorkflowId *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy.
	//
	// This member is required.
	PolicyArn *string

	// The timestamp when the annotations were updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAutomatedReasoningPolicyAnnotationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAutomatedReasoningPolicyAnnotations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAutomatedReasoningPolicyAnnotations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAutomatedReasoningPolicyAnnotations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAutomatedReasoningPolicyAnnotationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAutomatedReasoningPolicyAnnotations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAutomatedReasoningPolicyAnnotations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAutomatedReasoningPolicyAnnotations",
	}
}
