// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates a guardrail with the values you specify.
//
//   - Specify a name and optional description .
//
//   - Specify messages for when the guardrail successfully blocks a prompt or a
//     model response in the blockedInputMessaging and blockedOutputsMessaging fields.
//
//   - Specify topics for the guardrail to deny in the topicPolicyConfig object.
//     Each [GuardrailTopicConfig]object in the topicsConfig list pertains to one topic.
//
//   - Give a name and description so that the guardrail can properly identify the
//     topic.
//
//   - Specify DENY in the type field.
//
//   - (Optional) Provide up to five prompts that you would categorize as
//     belonging to the topic in the examples list.
//
//   - Specify filter strengths for the harmful categories defined in Amazon
//     Bedrock in the contentPolicyConfig object. Each [GuardrailContentFilterConfig]object in the filtersConfig
//     list pertains to a harmful category. For more information, see [Content filters]. For more
//     information about the fields in a content filter, see [GuardrailContentFilterConfig].
//
//   - Specify the category in the type field.
//
//   - Specify the strength of the filter for prompts in the inputStrength field
//     and for model responses in the strength field of the [GuardrailContentFilterConfig].
//
//   - (Optional) For security, include the ARN of a KMS key in the kmsKeyId field.
//
// [GuardrailContentFilterConfig]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html
// [Content filters]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-content-filters
// [GuardrailTopicConfig]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailTopicConfig.html
func (c *Client) UpdateGuardrail(ctx context.Context, params *UpdateGuardrailInput, optFns ...func(*Options)) (*UpdateGuardrailOutput, error) {
	if params == nil {
		params = &UpdateGuardrailInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateGuardrail", params, optFns, c.addOperationUpdateGuardrailMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateGuardrailOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateGuardrailInput struct {

	// The message to return when the guardrail blocks a prompt.
	//
	// This member is required.
	BlockedInputMessaging *string

	// The message to return when the guardrail blocks a model response.
	//
	// This member is required.
	BlockedOutputsMessaging *string

	// The unique identifier of the guardrail. This can be an ID or the ARN.
	//
	// This member is required.
	GuardrailIdentifier *string

	// A name for the guardrail.
	//
	// This member is required.
	Name *string

	// Updated configuration for Automated Reasoning policies associated with the
	// guardrail.
	AutomatedReasoningPolicyConfig *types.GuardrailAutomatedReasoningPolicyConfig

	// The content policy to configure for the guardrail.
	ContentPolicyConfig *types.GuardrailContentPolicyConfig

	// The contextual grounding policy configuration used to update a guardrail.
	ContextualGroundingPolicyConfig *types.GuardrailContextualGroundingPolicyConfig

	// The system-defined guardrail profile that you're using with your guardrail.
	// Guardrail profiles define the destination Amazon Web Services Regions where
	// guardrail inference requests can be automatically routed.
	//
	// For more information, see the [Amazon Bedrock User Guide].
	//
	// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html
	CrossRegionConfig *types.GuardrailCrossRegionConfig

	// A description of the guardrail.
	Description *string

	// The ARN of the KMS key with which to encrypt the guardrail.
	KmsKeyId *string

	// The sensitive information policy to configure for the guardrail.
	SensitiveInformationPolicyConfig *types.GuardrailSensitiveInformationPolicyConfig

	// The topic policy to configure for the guardrail.
	TopicPolicyConfig *types.GuardrailTopicPolicyConfig

	// The word policy to configure for the guardrail.
	WordPolicyConfig *types.GuardrailWordPolicyConfig

	noSmithyDocumentSerde
}

type UpdateGuardrailOutput struct {

	// The ARN of the guardrail.
	//
	// This member is required.
	GuardrailArn *string

	// The unique identifier of the guardrail
	//
	// This member is required.
	GuardrailId *string

	// The date and time at which the guardrail was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version of the guardrail.
	//
	// This member is required.
	Version *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateGuardrailMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateGuardrail{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateGuardrail{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateGuardrail"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateGuardrailValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateGuardrail(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateGuardrail(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateGuardrail",
	}
}
