// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about a specific browser session in Amazon
// Bedrock. This operation returns the session's configuration, current status,
// associated streams, and metadata.
//
// To get a browser session, you must specify both the browser identifier and the
// session ID. The response includes information about the session's viewport
// configuration, timeout settings, and stream endpoints.
//
// The following operations are related to GetBrowserSession :
//
// [StartBrowserSession]
//
// [ListBrowserSessions]
//
// [StopBrowserSession]
//
// [ListBrowserSessions]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListBrowserSessions.html
// [StopBrowserSession]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_StopBrowserSession.html
// [StartBrowserSession]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_StartBrowserSession.html
func (c *Client) GetBrowserSession(ctx context.Context, params *GetBrowserSessionInput, optFns ...func(*Options)) (*GetBrowserSessionOutput, error) {
	if params == nil {
		params = &GetBrowserSessionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetBrowserSession", params, optFns, c.addOperationGetBrowserSessionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetBrowserSessionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetBrowserSessionInput struct {

	// The unique identifier of the browser associated with the session.
	//
	// This member is required.
	BrowserIdentifier *string

	// The unique identifier of the browser session to retrieve.
	//
	// This member is required.
	SessionId *string

	noSmithyDocumentSerde
}

type GetBrowserSessionOutput struct {

	// The identifier of the browser.
	//
	// This member is required.
	BrowserIdentifier *string

	// The time at which the browser session was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The identifier of the browser session.
	//
	// This member is required.
	SessionId *string

	// The time at which the browser session was last updated.
	LastUpdatedAt *time.Time

	// The name of the browser session.
	Name *string

	// The artifact containing the session replay information.
	SessionReplayArtifact *string

	// The timeout period for the browser session in seconds.
	SessionTimeoutSeconds *int32

	// The current status of the browser session. Possible values include ACTIVE,
	// STOPPING, and STOPPED.
	Status types.BrowserSessionStatus

	// The streams associated with this browser session. These include the automation
	// stream and live view stream.
	Streams *types.BrowserSessionStream

	// The configuration that defines the dimensions of a browser viewport in a
	// browser session. The viewport determines the visible area of web content and
	// affects how web pages are rendered and displayed. Proper viewport configuration
	// ensures that web content is displayed correctly for the agent's browsing tasks.
	ViewPort *types.ViewPort

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetBrowserSessionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetBrowserSession{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetBrowserSession{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetBrowserSession"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetBrowserSessionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetBrowserSession(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetBrowserSession(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetBrowserSession",
	}
}
