// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the OAuth 2.0 token of the provided resource.
func (c *Client) GetResourceOauth2Token(ctx context.Context, params *GetResourceOauth2TokenInput, optFns ...func(*Options)) (*GetResourceOauth2TokenOutput, error) {
	if params == nil {
		params = &GetResourceOauth2TokenInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetResourceOauth2Token", params, optFns, c.addOperationGetResourceOauth2TokenMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetResourceOauth2TokenOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetResourceOauth2TokenInput struct {

	// The type of flow to be performed.
	//
	// This member is required.
	Oauth2Flow types.Oauth2FlowType

	// The name of the resource's credential provider.
	//
	// This member is required.
	ResourceCredentialProviderName *string

	// The OAuth scopes being requested.
	//
	// This member is required.
	Scopes []string

	// The identity token of the workload from which you want to retrieve the OAuth2
	// token.
	//
	// This member is required.
	WorkloadIdentityToken *string

	// A map of custom parameters to include in the authorization request to the
	// resource credential provider. These parameters are in addition to the standard
	// OAuth 2.0 flow parameters, and will not override them.
	CustomParameters map[string]string

	// An opaque string that will be sent back to the callback URL provided in
	// resourceOauth2ReturnUrl. This state should be used to protect the callback URL
	// of your application against CSRF attacks by ensuring the response corresponds to
	// the original request.
	CustomState *string

	// Indicates whether to always initiate a new three-legged OAuth (3LO) flow,
	// regardless of any existing session.
	ForceAuthentication *bool

	// The callback URL to redirect to after the OAuth 2.0 token retrieval is
	// complete. This URL must be one of the provided URLs configured for the workload
	// identity.
	ResourceOauth2ReturnUrl *string

	// Unique identifier for the user's authentication session for retrieving OAuth2
	// tokens. This ID tracks the authorization flow state across multiple requests and
	// responses during the OAuth2 authentication process.
	SessionUri *string

	noSmithyDocumentSerde
}

type GetResourceOauth2TokenOutput struct {

	// The OAuth 2.0 access token to use.
	AccessToken *string

	// The URL to initiate the authorization process, provided when the access token
	// requires user authorization.
	AuthorizationUrl *string

	// Status indicating whether the user's authorization session is in progress or
	// has failed. This helps determine the next steps in the OAuth2 authentication
	// flow.
	SessionStatus types.SessionStatus

	// Unique identifier for the user's authorization session for retrieving OAuth2
	// tokens. This matches the sessionId from the request and can be used to track the
	// session state.
	SessionUri *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetResourceOauth2TokenMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetResourceOauth2Token{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetResourceOauth2Token{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetResourceOauth2Token"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetResourceOauth2TokenValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetResourceOauth2Token(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetResourceOauth2Token(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetResourceOauth2Token",
	}
}
