// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains summary information about an actor in an AgentCore Memory resource.
type ActorSummary struct {

	// The unique identifier of the actor.
	//
	// This member is required.
	ActorId *string

	noSmithyDocumentSerde
}

// The configuration for a stream that enables programmatic control of a browser
// session in Amazon Bedrock. This stream provides a bidirectional communication
// channel for sending commands to the browser and receiving responses, allowing
// agents to automate web interactions such as navigation, form filling, and
// element clicking.
type AutomationStream struct {

	// The endpoint URL for the automation stream. This URL is used to establish a
	// WebSocket connection to the stream for sending commands and receiving responses.
	//
	// This member is required.
	StreamEndpoint *string

	// The current status of the automation stream. This indicates whether the stream
	// is available for use. Possible values include ACTIVE, CONNECTING, and
	// DISCONNECTED.
	//
	// This member is required.
	StreamStatus AutomationStreamStatus

	noSmithyDocumentSerde
}

// Contains information about an update to an automation stream.
type AutomationStreamUpdate struct {

	// The status of the automation stream.
	StreamStatus AutomationStreamStatus

	noSmithyDocumentSerde
}

// Contains information about a branch in an AgentCore Memory resource. Branches
// allow for organizing events into different conversation threads or paths.
type Branch struct {

	// The name of the branch.
	//
	// This member is required.
	Name *string

	// The identifier of the root event for this branch.
	RootEventId *string

	noSmithyDocumentSerde
}

// Contains filter criteria for branches when listing events.
type BranchFilter struct {

	// The name of the branch to filter by.
	//
	// This member is required.
	Name *string

	// Specifies whether to include parent branches in the results. Set to true to
	// include parent branches, or false to exclude them.
	IncludeParentBranches *bool

	noSmithyDocumentSerde
}

// The collection of streams associated with a browser session in Amazon Bedrock.
// These streams provide different ways to interact with and observe the browser
// session, including programmatic control and visual representation of the browser
// content.
type BrowserSessionStream struct {

	// The stream that enables programmatic control of the browser. This stream allows
	// agents to perform actions such as navigating to URLs, clicking elements, and
	// filling forms.
	//
	// This member is required.
	AutomationStream *AutomationStream

	// The stream that provides a visual representation of the browser content. This
	// stream allows agents to observe the current state of the browser, including
	// rendered web pages and visual elements.
	LiveViewStream *LiveViewStream

	noSmithyDocumentSerde
}

// A condensed representation of a browser session in Amazon Bedrock. This
// structure contains key information about a browser session, including
// identifiers, status, and timestamps, without the full details of the session
// configuration and streams.
type BrowserSessionSummary struct {

	// The unique identifier of the browser associated with the session. This
	// identifier specifies which browser environment is used for the session.
	//
	// This member is required.
	BrowserIdentifier *string

	// The timestamp when the browser session was created. This value is in ISO 8601
	// format.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the browser session. This identifier is used in
	// operations that interact with the session.
	//
	// This member is required.
	SessionId *string

	// The current status of the browser session. Possible values include ACTIVE,
	// STOPPING, and STOPPED.
	//
	// This member is required.
	Status BrowserSessionStatus

	// The timestamp when the browser session was last updated. This value is in ISO
	// 8601 format.
	LastUpdatedAt *time.Time

	// The name of the browser session. This name helps identify and manage the
	// session.
	Name *string

	noSmithyDocumentSerde
}

// The output produced by executing code in a code interpreter session in Amazon
// Bedrock. This structure contains the results of code execution, including
// textual output, structured data, and error information. Agents use these results
// to generate responses that incorporate computation, data analysis, and
// visualization.
type CodeInterpreterResult struct {

	// The textual content of the execution result. This includes standard output from
	// the code execution, such as print statements, console output, and text
	// representations of results.
	//
	// This member is required.
	Content []ContentBlock

	// Indicates whether the result represents an error. If true, the content contains
	// error messages or exception information. If false, the content contains
	// successful execution results.
	IsError *bool

	// The structured content of the execution result. This includes additional
	// metadata about the execution, such as execution time, memory usage, and
	// structured representations of output data. The format depends on the specific
	// code interpreter and execution context.
	StructuredContent *ToolResultStructuredContent

	noSmithyDocumentSerde
}

// A condensed representation of a code interpreter session in Amazon Bedrock.
// This structure contains key information about a code interpreter session,
// including identifiers, status, and timestamps, without the full details of the
// session configuration.
type CodeInterpreterSessionSummary struct {

	// The unique identifier of the code interpreter associated with the session. This
	// identifier specifies which code interpreter environment is used for the session.
	//
	// This member is required.
	CodeInterpreterIdentifier *string

	// The timestamp when the code interpreter session was created. This value is in
	// ISO 8601 format.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the code interpreter session. This identifier is used
	// in operations that interact with the session.
	//
	// This member is required.
	SessionId *string

	// The current status of the code interpreter session. Possible values include
	// ACTIVE, STOPPING, and STOPPED.
	//
	// This member is required.
	Status CodeInterpreterSessionStatus

	// The timestamp when the code interpreter session was last updated. This value is
	// in ISO 8601 format.
	LastUpdatedAt *time.Time

	// The name of the code interpreter session. This name helps identify and manage
	// the session.
	Name *string

	noSmithyDocumentSerde
}

// Contains output from a code interpreter stream.
//
// The following types satisfy this interface:
//
//	CodeInterpreterStreamOutputMemberResult
type CodeInterpreterStreamOutput interface {
	isCodeInterpreterStreamOutput()
}

// The output produced by executing code in a code interpreter session in Amazon
// Bedrock. This structure contains the results of code execution, including
// textual output, structured data, and error information. Agents use these results
// to generate responses that incorporate computation, data analysis, and
// visualization.
type CodeInterpreterStreamOutputMemberResult struct {
	Value CodeInterpreterResult

	noSmithyDocumentSerde
}

func (*CodeInterpreterStreamOutputMemberResult) isCodeInterpreterStreamOutput() {}

// Contains the content of a memory item.
//
// The following types satisfy this interface:
//
//	ContentMemberText
type Content interface {
	isContent()
}

// The text content of the memory item.
type ContentMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ContentMemberText) isContent() {}

// A block of content in a response.
type ContentBlock struct {

	// The type of content in the block.
	//
	// This member is required.
	Type ContentBlockType

	// The binary data content of the block.
	Data []byte

	// The description of the content block.
	Description *string

	// The MIME type of the content.
	MimeType *string

	// The name of the content block.
	Name *string

	// The resource associated with the content block.
	Resource *ResourceContent

	// The size of the content in bytes.
	Size *int64

	// The text content of the block.
	Text *string

	// The URI of the content.
	Uri *string

	noSmithyDocumentSerde
}

//	The contextual information associated with an evaluation, including span
//
// context details that identify the specific traces and sessions being evaluated
// within the agent's execution flow.
//
// The following types satisfy this interface:
//
//	ContextMemberSpanContext
type Context interface {
	isContext()
}

//	The span context information that uniquely identifies the trace and span being
//
// evaluated, including session ID, trace ID, and span ID for precise targeting
// within the agent's execution flow.
type ContextMemberSpanContext struct {
	Value SpanContext

	noSmithyDocumentSerde
}

func (*ContextMemberSpanContext) isContext() {}

// Contains conversational content for an event payload.
type Conversational struct {

	// The content of the conversation message.
	//
	// This member is required.
	Content Content

	// The role of the participant in the conversation (for example, "user" or
	// "assistant").
	//
	// This member is required.
	Role Role

	noSmithyDocumentSerde
}

//	The input data structure containing agent session spans in OpenTelemetry
//
// format. Supports traces from frameworks like Strands (AgentCore Runtime) and
// LangGraph with OpenInference instrumentation for comprehensive evaluation.
//
// The following types satisfy this interface:
//
//	EvaluationInputMemberSessionSpans
type EvaluationInput interface {
	isEvaluationInput()
}

//	The collection of spans representing agent execution traces within a session.
//
// Each span contains detailed information about tool calls, model interactions,
// and other agent activities that can be evaluated for quality and performance.
type EvaluationInputMemberSessionSpans struct {
	Value []document.Interface

	noSmithyDocumentSerde
}

func (*EvaluationInputMemberSessionSpans) isEvaluationInput() {}

//	The comprehensive result of an evaluation containing the score, explanation,
//
// evaluator metadata, and execution details. Provides both quantitative ratings
// and qualitative insights about agent performance.
type EvaluationResultContent struct {

	//  The contextual information associated with this evaluation result, including
	// span context details that identify the specific traces and sessions that were
	// evaluated.
	//
	// This member is required.
	Context Context

	//  The Amazon Resource Name (ARN) of the evaluator used to generate this result.
	// For custom evaluators, this is the full ARN; for built-in evaluators, this
	// follows the pattern Builtin.{EvaluatorName} .
	//
	// This member is required.
	EvaluatorArn *string

	//  The unique identifier of the evaluator that produced this result. This matches
	// the evaluatorId provided in the evaluation request and can be used to identify
	// which evaluator generated specific results.
	//
	// This member is required.
	EvaluatorId *string

	//  The human-readable name of the evaluator used for this evaluation. For
	// built-in evaluators, this is the descriptive name (e.g., "Helpfulness",
	// "Correctness"); for custom evaluators, this is the user-defined name.
	//
	// This member is required.
	EvaluatorName *string

	//  The error code indicating the type of failure that occurred during evaluation.
	// Used to programmatically identify and handle different categories of evaluation
	// errors.
	ErrorCode *string

	//  The error message describing what went wrong if the evaluation failed.
	// Provides detailed information about evaluation failures to help diagnose and
	// resolve issues with evaluator configuration or input data.
	ErrorMessage *string

	//  The detailed explanation provided by the evaluator describing the reasoning
	// behind the assigned score. This qualitative feedback helps understand why
	// specific ratings were given and provides actionable insights for improvement.
	Explanation *string

	//  The categorical label assigned by the evaluator when using a categorical
	// rating scale. This provides a human-readable description of the evaluation
	// result (e.g., "Excellent", "Good", "Poor") corresponding to the numerical value.
	// For numerical scales, this field is optional and provides a natural language
	// explanation of what the value means (e.g., value 0.5 = "Somewhat Helpful").
	Label *string

	//  The token consumption statistics for this evaluation, including input tokens,
	// output tokens, and total tokens used by the underlying language model during the
	// evaluation process.
	TokenUsage *TokenUsage

	//  The numerical score assigned by the evaluator according to its configured
	// rating scale. For numerical scales, this is a decimal value within the defined
	// range. This field is not allowed for categorical scales.
	Value *float64

	noSmithyDocumentSerde
}

//	The specification of which trace or span IDs to evaluate within the provided
//
// input data. Allows precise targeting of evaluation at different levels: tool
// calls, traces, or sessions.
//
// The following types satisfy this interface:
//
//	EvaluationTargetMemberSpanIds
//	EvaluationTargetMemberTraceIds
type EvaluationTarget interface {
	isEvaluationTarget()
}

//	The list of specific span IDs to evaluate within the provided traces. Used to
//
// target evaluation at individual tool calls or specific operations within the
// agent's execution flow.
type EvaluationTargetMemberSpanIds struct {
	Value []string

	noSmithyDocumentSerde
}

func (*EvaluationTargetMemberSpanIds) isEvaluationTarget() {}

//	The list of trace IDs to evaluate, representing complete request-response
//
// interactions. Used to evaluate entire conversation turns or specific agent
// interactions within a session.
type EvaluationTargetMemberTraceIds struct {
	Value []string

	noSmithyDocumentSerde
}

func (*EvaluationTargetMemberTraceIds) isEvaluationTarget() {}

// Contains information about an event in an AgentCore Memory resource.
type Event struct {

	// The identifier of the actor associated with the event.
	//
	// This member is required.
	ActorId *string

	// The unique identifier of the event.
	//
	// This member is required.
	EventId *string

	// The timestamp when the event occurred.
	//
	// This member is required.
	EventTimestamp *time.Time

	// The identifier of the AgentCore Memory resource containing the event.
	//
	// This member is required.
	MemoryId *string

	// The content payload of the event.
	//
	// This member is required.
	Payload []PayloadType

	// The identifier of the session containing the event.
	//
	// This member is required.
	SessionId *string

	// The branch information for the event.
	Branch *Branch

	// Metadata associated with an event.
	Metadata map[string]MetadataValue

	noSmithyDocumentSerde
}

// Filter expression for retrieving events based on metadata associated with an
// event.
type EventMetadataFilterExpression struct {

	// Left operand of the event metadata filter expression.
	//
	// This member is required.
	Left LeftExpression

	// Operator applied to the event metadata filter expression.
	//
	// This member is required.
	Operator OperatorType

	// Right operand of the event metadata filter expression.
	Right RightExpression

	noSmithyDocumentSerde
}

// Represents the metadata of a memory extraction job such as the message
// identifiers that compose this job.
type ExtractionJob struct {

	// The unique identifier of the extraction job.
	//
	// This member is required.
	JobId *string

	noSmithyDocumentSerde
}

// Filters for querying memory extraction jobs based on various criteria.
type ExtractionJobFilterInput struct {

	// The identifier of the actor. If specified, only extraction jobs with this actor
	// ID are returned.
	ActorId *string

	// The unique identifier of the session. If specified, only extraction jobs with
	// this session ID are returned.
	SessionId *string

	// The status of the extraction job. If specified, only extraction jobs with this
	// status are returned.
	Status ExtractionJobStatus

	// The memory strategy identifier to filter extraction jobs by. If specified, only
	// extraction jobs with this strategy ID are returned.
	StrategyId *string

	noSmithyDocumentSerde
}

// The list of messages that compose this extraction job.
//
// The following types satisfy this interface:
//
//	ExtractionJobMessagesMemberMessagesList
type ExtractionJobMessages interface {
	isExtractionJobMessages()
}

// The list of messages that compose this extraction job.
type ExtractionJobMessagesMemberMessagesList struct {
	Value []MessageMetadata

	noSmithyDocumentSerde
}

func (*ExtractionJobMessagesMemberMessagesList) isExtractionJobMessages() {}

// Metadata information associated with this extraction job.
type ExtractionJobMetadata struct {

	// The unique identifier for the extraction job.
	//
	// This member is required.
	JobID *string

	// The messages associated with the extraction job.
	//
	// This member is required.
	Messages ExtractionJobMessages

	// The identifier of the actor for this extraction job.
	ActorId *string

	// The cause of failure, if the job did not complete successfully.
	FailureReason *string

	// The identifier of the session for this extraction job.
	SessionId *string

	// The current status of the extraction job.
	Status ExtractionJobStatus

	// The identifier of the memory strategy for this extraction job.
	StrategyId *string

	noSmithyDocumentSerde
}

// Contains filter criteria for listing events.
type FilterInput struct {

	// The branch filter criteria to apply when listing events.
	Branch *BranchFilter

	// Event metadata filter criteria to apply when retrieving events.
	EventMetadata []EventMetadataFilterExpression

	noSmithyDocumentSerde
}

// A block of input content.
type InputContentBlock struct {

	// The path to the input content.
	//
	// This member is required.
	Path *string

	// The binary input content.
	Blob []byte

	// The text input content.
	Text *string

	noSmithyDocumentSerde
}

// Left expression of the event metadata filter.
//
// The following types satisfy this interface:
//
//	LeftExpressionMemberMetadataKey
type LeftExpression interface {
	isLeftExpression()
}

// Key associated with the metadata in an event.
type LeftExpressionMemberMetadataKey struct {
	Value string

	noSmithyDocumentSerde
}

func (*LeftExpressionMemberMetadataKey) isLeftExpression() {}

// The configuration for a stream that provides a visual representation of a
// browser session in Amazon Bedrock. This stream enables agents to observe the
// current state of the browser, including rendered web pages, visual elements, and
// the results of interactions.
type LiveViewStream struct {

	// The endpoint URL for the live view stream. This URL is used to establish a
	// connection to receive visual updates from the browser session.
	StreamEndpoint *string

	noSmithyDocumentSerde
}

// Contains the content of a memory record.
//
// The following types satisfy this interface:
//
//	MemoryContentMemberText
type MemoryContent interface {
	isMemoryContent()
}

// The text content of the memory record.
type MemoryContentMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*MemoryContentMemberText) isMemoryContent() {}

// Filters to apply to metadata associated with a memory. Specify the metadata key
// and value in the left and right fields and use the operator field to define the
// relationship to match.
type MemoryMetadataFilterExpression struct {

	// Left expression of the event metadata filter.
	//
	// This member is required.
	Left LeftExpression

	// The relationship between the metadata key and value to match when applying the
	// metadata filter.
	//
	// This member is required.
	Operator OperatorType

	// Right expression of the eventMetadata filter.
	Right RightExpression

	noSmithyDocumentSerde
}

// Contains information about a memory record in an AgentCore Memory resource.
type MemoryRecord struct {

	// The content of the memory record.
	//
	// This member is required.
	Content MemoryContent

	// The timestamp when the memory record was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the memory record.
	//
	// This member is required.
	MemoryRecordId *string

	// The identifier of the memory strategy associated with this record.
	//
	// This member is required.
	MemoryStrategyId *string

	// The namespaces associated with this memory record. Namespaces help organize and
	// categorize memory records.
	//
	// This member is required.
	Namespaces []string

	// A map of metadata key-value pairs associated with a memory record.
	Metadata map[string]MetadataValue

	noSmithyDocumentSerde
}

// Input structure to create a new memory record.
type MemoryRecordCreateInput struct {

	// The content to be stored within the memory record.
	//
	// This member is required.
	Content MemoryContent

	// A list of namespace identifiers that categorize or group the memory record.
	//
	// This member is required.
	Namespaces []string

	// A client-provided identifier for tracking this specific record creation request.
	//
	// This member is required.
	RequestIdentifier *string

	// Time at which the memory record was created.
	//
	// This member is required.
	Timestamp *time.Time

	// The ID of the memory strategy that defines how this memory record is grouped.
	MemoryStrategyId *string

	noSmithyDocumentSerde
}

// Input structure to delete an existing memory record.
type MemoryRecordDeleteInput struct {

	// The unique ID of the memory record to be deleted.
	//
	// This member is required.
	MemoryRecordId *string

	noSmithyDocumentSerde
}

// Output information returned after processing a memory record operation.
type MemoryRecordOutput struct {

	// The unique ID associated to the memory record.
	//
	// This member is required.
	MemoryRecordId *string

	// The status of the memory record operation (e.g., SUCCEEDED, FAILED).
	//
	// This member is required.
	Status MemoryRecordStatus

	// The error code returned when the memory record operation fails.
	ErrorCode *int32

	// A human-readable error message describing why the memory record operation
	// failed.
	ErrorMessage *string

	// The client-provided identifier that was used to track this record operation.
	RequestIdentifier *string

	noSmithyDocumentSerde
}

// Contains summary information about a memory record.
type MemoryRecordSummary struct {

	// The content of the memory record.
	//
	// This member is required.
	Content MemoryContent

	// The timestamp when the memory record was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the memory record.
	//
	// This member is required.
	MemoryRecordId *string

	// The identifier of the memory strategy associated with this record.
	//
	// This member is required.
	MemoryStrategyId *string

	// The namespaces associated with this memory record.
	//
	// This member is required.
	Namespaces []string

	// A map of metadata key-value pairs associated with a memory record.
	Metadata map[string]MetadataValue

	// The relevance score of the memory record when returned as part of a search
	// result. Higher values indicate greater relevance to the search query.
	Score *float64

	noSmithyDocumentSerde
}

// Input structure to update an existing memory record.
type MemoryRecordUpdateInput struct {

	// The unique ID of the memory record to be updated.
	//
	// This member is required.
	MemoryRecordId *string

	// Time at which the memory record was updated
	//
	// This member is required.
	Timestamp *time.Time

	// The content to be stored within the memory record.
	Content MemoryContent

	// The updated ID of the memory strategy that defines how this memory record is
	// grouped.
	MemoryStrategyId *string

	// The updated list of namespace identifiers for categorizing the memory record.
	Namespaces []string

	noSmithyDocumentSerde
}

// Metadata information associated with this message.
type MessageMetadata struct {

	// The identifier of the event associated with this message.
	//
	// This member is required.
	EventId *string

	// The position of this message within that event’s ordered list of messages.
	//
	// This member is required.
	MessageIndex *int32

	noSmithyDocumentSerde
}

// Value associated with the eventMetadata key.
//
// The following types satisfy this interface:
//
//	MetadataValueMemberStringValue
type MetadataValue interface {
	isMetadataValue()
}

// Value associated with the eventMetadata key.
type MetadataValueMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*MetadataValueMemberStringValue) isMetadataValue() {}

// Contains the payload content for an event.
//
// The following types satisfy this interface:
//
//	PayloadTypeMemberBlob
//	PayloadTypeMemberConversational
type PayloadType interface {
	isPayloadType()
}

// The binary content of the payload.
type PayloadTypeMemberBlob struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*PayloadTypeMemberBlob) isPayloadType() {}

// The conversational content of the payload.
type PayloadTypeMemberConversational struct {
	Value Conversational

	noSmithyDocumentSerde
}

func (*PayloadTypeMemberConversational) isPayloadType() {}

// Contains information about resource content.
type ResourceContent struct {

	// The type of resource content.
	//
	// This member is required.
	Type ResourceContentType

	// The binary resource content.
	Blob []byte

	// The MIME type of the resource content.
	MimeType *string

	// The text resource content.
	Text *string

	// The URI of the resource content.
	Uri *string

	noSmithyDocumentSerde
}

// Right expression of the eventMetadata filter.
//
// The following types satisfy this interface:
//
//	RightExpressionMemberMetadataValue
type RightExpression interface {
	isRightExpression()
}

// Value associated with the key in eventMetadata .
type RightExpressionMemberMetadataValue struct {
	Value MetadataValue

	noSmithyDocumentSerde
}

func (*RightExpressionMemberMetadataValue) isRightExpression() {}

// Contains search criteria for retrieving memory records.
type SearchCriteria struct {

	// The search query to use for finding relevant memory records.
	//
	// This member is required.
	SearchQuery *string

	// The memory strategy identifier to filter memory records by.
	MemoryStrategyId *string

	// Filters to apply to metadata associated with a memory.
	MetadataFilters []MemoryMetadataFilterExpression

	// The maximum number of top-scoring memory records to return. This value is used
	// for semantic search ranking.
	TopK *int32

	noSmithyDocumentSerde
}

// Contains summary information about a session in an AgentCore Memory resource.
type SessionSummary struct {

	// The identifier of the actor associated with the session.
	//
	// This member is required.
	ActorId *string

	// The timestamp when the session was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the session.
	//
	// This member is required.
	SessionId *string

	noSmithyDocumentSerde
}

//	The contextual information that uniquely identifies a span within the
//
// distributed tracing system. Contains session, trace, and span identifiers used
// to correlate evaluation results with specific agent execution points.
type SpanContext struct {

	//  The unique identifier of the session containing this span. Sessions represent
	// complete conversation flows and are detected using configurable
	// SessionTimeoutMinutes (default 15 minutes).
	//
	// This member is required.
	SessionId *string

	//  The unique identifier of the specific span being referenced. Spans represent
	// individual operations like tool calls, model invocations, or other discrete
	// actions within the agent's execution.
	SpanId *string

	//  The unique identifier of the trace containing this span. Traces represent
	// individual request-response interactions within a session and group related
	// spans together.
	TraceId *string

	noSmithyDocumentSerde
}

// Contains information about an update to a stream.
//
// The following types satisfy this interface:
//
//	StreamUpdateMemberAutomationStreamUpdate
type StreamUpdate interface {
	isStreamUpdate()
}

// The update to an automation stream.
type StreamUpdateMemberAutomationStreamUpdate struct {
	Value AutomationStreamUpdate

	noSmithyDocumentSerde
}

func (*StreamUpdateMemberAutomationStreamUpdate) isStreamUpdate() {}

//	The token consumption statistics for language model operations during
//
// evaluation. Provides detailed breakdown of input, output, and total tokens used
// for cost tracking and performance monitoring.
type TokenUsage struct {

	//  The number of tokens consumed for input processing during the evaluation.
	// Includes tokens from the evaluation prompt, agent traces, and any additional
	// context provided to the evaluator model.
	InputTokens *int32

	//  The number of tokens generated by the evaluator model in its response.
	// Includes tokens for the score, explanation, and any additional output produced
	// during the evaluation process.
	OutputTokens *int32

	//  The total number of tokens consumed during the evaluation, calculated as the
	// sum of input and output tokens. Used for cost calculation and rate limiting
	// within the service limits.
	TotalTokens *int32

	noSmithyDocumentSerde
}

// The collection of arguments that specify the operation to perform and its
// parameters when invoking a tool in Amazon Bedrock. Different tools require
// different arguments, and this structure provides a flexible way to pass the
// appropriate arguments to each tool type.
type ToolArguments struct {

	// Whether to clear the context for the tool.
	ClearContext *bool

	// The code to execute in a code interpreter session. This is the source code in
	// the specified programming language that will be executed by the code
	// interpreter.
	Code *string

	// The command to execute with the tool.
	Command *string

	// The content for the tool operation.
	Content []InputContentBlock

	// The directory path for the tool operation.
	DirectoryPath *string

	// The programming language of the code to execute. This tells the code
	// interpreter which language runtime to use for execution. Common values include
	// 'python', 'javascript', and 'r'.
	Language ProgrammingLanguage

	// The path for the tool operation.
	Path *string

	// The paths for the tool operation.
	Paths []string

	// The identifier of the task for the tool operation.
	TaskId *string

	noSmithyDocumentSerde
}

// Contains structured content from a tool result.
type ToolResultStructuredContent struct {

	// The execution time of the tool operation in milliseconds.
	ExecutionTime *float64

	// The exit code from the tool execution.
	ExitCode *int32

	// The standard error output from the tool execution.
	Stderr *string

	// The standard output from the tool execution.
	Stdout *string

	// The identifier of the task that produced the result.
	TaskId *string

	// The status of the task that produced the result.
	TaskStatus TaskStatus

	noSmithyDocumentSerde
}

// The OAuth2.0 token or user ID that was used to generate the workload access
// token used for initiating the user authorization flow to retrieve OAuth2.0
// tokens.
//
// The following types satisfy this interface:
//
//	UserIdentifierMemberUserId
//	UserIdentifierMemberUserToken
type UserIdentifier interface {
	isUserIdentifier()
}

// The ID of the user for whom you have retrieved a workload access token for
type UserIdentifierMemberUserId struct {
	Value string

	noSmithyDocumentSerde
}

func (*UserIdentifierMemberUserId) isUserIdentifier() {}

// The OAuth2.0 token issued by the user’s identity provider
type UserIdentifierMemberUserToken struct {
	Value string

	noSmithyDocumentSerde
}

func (*UserIdentifierMemberUserToken) isUserIdentifier() {}

// Stores information about a field passed inside a request that resulted in an
// exception.
type ValidationExceptionField struct {

	// A message describing why this field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The configuration that defines the dimensions of a browser viewport in a
// browser session. The viewport determines the visible area of web content and
// affects how web pages are rendered and displayed. Proper viewport configuration
// ensures that web content is displayed correctly for the agent's browsing tasks.
type ViewPort struct {

	// The height of the viewport in pixels. This value determines the vertical
	// dimension of the visible area. Valid values range from 600 to 1080 pixels.
	//
	// This member is required.
	Height *int32

	// The width of the viewport in pixels. This value determines the horizontal
	// dimension of the visible area. Valid values range from 800 to 1920 pixels.
	//
	// This member is required.
	Width *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCodeInterpreterStreamOutput() {}
func (*UnknownUnionMember) isContent()                     {}
func (*UnknownUnionMember) isContext()                     {}
func (*UnknownUnionMember) isEvaluationInput()             {}
func (*UnknownUnionMember) isEvaluationTarget()            {}
func (*UnknownUnionMember) isExtractionJobMessages()       {}
func (*UnknownUnionMember) isLeftExpression()              {}
func (*UnknownUnionMember) isMemoryContent()               {}
func (*UnknownUnionMember) isMetadataValue()               {}
func (*UnknownUnionMember) isPayloadType()                 {}
func (*UnknownUnionMember) isRightExpression()             {}
func (*UnknownUnionMember) isStreamUpdate()                {}
func (*UnknownUnionMember) isUserIdentifier()              {}
