// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new policy engine within the AgentCore Policy system. A policy engine
// is a collection of policies that evaluates and authorizes agent tool calls. When
// associated with Gateways (each Gateway can be associated with at most one policy
// engine, but multiple Gateways can be associated with the same engine), the
// policy engine intercepts all agent requests and determines whether to allow or
// deny each action based on the defined policies. This is an asynchronous
// operation. Use the [GetPolicyEngine]operation to poll the status field to track completion.
//
// [GetPolicyEngine]: https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/API_GetPolicyEngine.html
func (c *Client) CreatePolicyEngine(ctx context.Context, params *CreatePolicyEngineInput, optFns ...func(*Options)) (*CreatePolicyEngineOutput, error) {
	if params == nil {
		params = &CreatePolicyEngineInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePolicyEngine", params, optFns, c.addOperationCreatePolicyEngineMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePolicyEngineOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePolicyEngineInput struct {

	// The customer-assigned immutable name for the policy engine. This name
	// identifies the policy engine and cannot be changed after creation.
	//
	// This member is required.
	Name *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you retry a request with the same client token, the service
	// returns the same response without creating a duplicate policy engine.
	ClientToken *string

	// A human-readable description of the policy engine's purpose and scope (1-4,096
	// characters). This helps administrators understand the policy engine's role in
	// the overall governance strategy. Document which Gateway this engine will be
	// associated with, what types of tools or workflows it governs, and the team or
	// service responsible for maintaining it. Clear descriptions are essential when
	// managing multiple policy engines across different services or environments.
	Description *string

	noSmithyDocumentSerde
}

type CreatePolicyEngineOutput struct {

	// The timestamp when the policy engine was created. This is automatically set by
	// the service and used for auditing and lifecycle management.
	//
	// This member is required.
	CreatedAt *time.Time

	// The customer-assigned name of the created policy engine. This matches the name
	// provided in the request and serves as the human-readable identifier.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the created policy engine. This globally
	// unique identifier can be used for cross-service references and IAM policy
	// statements.
	//
	// This member is required.
	PolicyEngineArn *string

	// The unique identifier for the created policy engine. This system-generated
	// identifier consists of the user name plus a 10-character generated suffix and is
	// used for all subsequent policy engine operations.
	//
	// This member is required.
	PolicyEngineId *string

	// The current status of the policy engine. A status of ACTIVE indicates the
	// policy engine is ready for use.
	//
	// This member is required.
	Status types.PolicyEngineStatus

	// Additional information about the policy engine status. This provides details
	// about any failures or the current state of the policy engine creation process.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when the policy engine was last updated. For newly created policy
	// engines, this matches the createdAt timestamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A human-readable description of the policy engine's purpose.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePolicyEngineMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreatePolicyEngine{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreatePolicyEngine{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePolicyEngine"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreatePolicyEngineMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePolicyEngineValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePolicyEngine(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreatePolicyEngine struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreatePolicyEngine) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreatePolicyEngine) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreatePolicyEngineInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreatePolicyEngineInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreatePolicyEngineMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreatePolicyEngine{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreatePolicyEngine(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePolicyEngine",
	}
}
