// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Deletes an existing policy engine from the AgentCore Policy system. The policy
// engine must not have any associated policies before deletion. Once deleted, the
// policy engine and all its configurations become unavailable for policy
// management and evaluation. This is an asynchronous operation. Use the
// GetPolicyEngine operation to poll the status field to track completion.
func (c *Client) DeletePolicyEngine(ctx context.Context, params *DeletePolicyEngineInput, optFns ...func(*Options)) (*DeletePolicyEngineOutput, error) {
	if params == nil {
		params = &DeletePolicyEngineInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeletePolicyEngine", params, optFns, c.addOperationDeletePolicyEngineMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeletePolicyEngineOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeletePolicyEngineInput struct {

	// The unique identifier of the policy engine to be deleted. This must be a valid
	// policy engine ID that exists within the account.
	//
	// This member is required.
	PolicyEngineId *string

	noSmithyDocumentSerde
}

type DeletePolicyEngineOutput struct {

	// The timestamp when the deleted policy engine was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The customer-assigned name of the deleted policy engine.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the deleted policy engine. This globally
	// unique identifier confirms which policy engine resource was successfully
	// removed.
	//
	// This member is required.
	PolicyEngineArn *string

	// The unique identifier of the policy engine being deleted. This confirms which
	// policy engine the deletion operation targets.
	//
	// This member is required.
	PolicyEngineId *string

	// The status of the policy engine deletion operation. This provides status about
	// any issues that occurred during the deletion process.
	//
	// This member is required.
	Status types.PolicyEngineStatus

	// Additional information about the deletion status. This provides details about
	// the deletion process or any issues that may have occurred.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when the deleted policy engine was last modified before deletion.
	// This tracks the final state of the policy engine before it was removed from the
	// system.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The human-readable description of the deleted policy engine.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeletePolicyEngineMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeletePolicyEngine{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeletePolicyEngine{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeletePolicyEngine"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeletePolicyEngineValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeletePolicyEngine(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeletePolicyEngine(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeletePolicyEngine",
	}
}
