// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets an Amazon Bedrock AgentCore Runtime.
func (c *Client) GetAgentRuntime(ctx context.Context, params *GetAgentRuntimeInput, optFns ...func(*Options)) (*GetAgentRuntimeOutput, error) {
	if params == nil {
		params = &GetAgentRuntimeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAgentRuntime", params, optFns, c.addOperationGetAgentRuntimeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAgentRuntimeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAgentRuntimeInput struct {

	// The unique identifier of the AgentCore Runtime to retrieve.
	//
	// This member is required.
	AgentRuntimeId *string

	// The version of the AgentCore Runtime to retrieve.
	AgentRuntimeVersion *string

	noSmithyDocumentSerde
}

type GetAgentRuntimeOutput struct {

	// The Amazon Resource Name (ARN) of the AgentCore Runtime.
	//
	// This member is required.
	AgentRuntimeArn *string

	// The unique identifier of the AgentCore Runtime.
	//
	// This member is required.
	AgentRuntimeId *string

	// The name of the AgentCore Runtime.
	//
	// This member is required.
	AgentRuntimeName *string

	// The version of the AgentCore Runtime.
	//
	// This member is required.
	AgentRuntimeVersion *string

	// The timestamp when the AgentCore Runtime was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The timestamp when the AgentCore Runtime was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The life cycle configuration for the AgentCore Runtime.
	//
	// This member is required.
	LifecycleConfiguration *types.LifecycleConfiguration

	// The network configuration for the AgentCore Runtime.
	//
	// This member is required.
	NetworkConfiguration *types.NetworkConfiguration

	// The IAM role ARN that provides permissions for the AgentCore Runtime.
	//
	// This member is required.
	RoleArn *string

	// The current status of the AgentCore Runtime.
	//
	// This member is required.
	Status types.AgentRuntimeStatus

	// The artifact of the AgentCore Runtime.
	AgentRuntimeArtifact types.AgentRuntimeArtifact

	// The authorizer configuration for the AgentCore Runtime.
	AuthorizerConfiguration types.AuthorizerConfiguration

	// The description of the AgentCore Runtime.
	Description *string

	// Environment variables set in the AgentCore Runtime environment.
	EnvironmentVariables map[string]string

	// The reason for failure if the AgentCore Runtime is in a failed state.
	FailureReason *string

	// The protocol configuration for an agent runtime. This structure defines how the
	// agent runtime communicates with clients.
	ProtocolConfiguration *types.ProtocolConfiguration

	// Configuration for HTTP request headers that will be passed through to the
	// runtime.
	RequestHeaderConfiguration types.RequestHeaderConfiguration

	// The workload identity details for the AgentCore Runtime.
	WorkloadIdentityDetails *types.WorkloadIdentityDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAgentRuntimeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAgentRuntime{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAgentRuntime{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAgentRuntime"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAgentRuntimeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAgentRuntime(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAgentRuntime(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAgentRuntime",
	}
}
