// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about a custom browser.
func (c *Client) GetBrowser(ctx context.Context, params *GetBrowserInput, optFns ...func(*Options)) (*GetBrowserOutput, error) {
	if params == nil {
		params = &GetBrowserInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetBrowser", params, optFns, c.addOperationGetBrowserMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetBrowserOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetBrowserInput struct {

	// The unique identifier of the browser to retrieve.
	//
	// This member is required.
	BrowserId *string

	noSmithyDocumentSerde
}

type GetBrowserOutput struct {

	// The Amazon Resource Name (ARN) of the browser.
	//
	// This member is required.
	BrowserArn *string

	// The unique identifier of the browser.
	//
	// This member is required.
	BrowserId *string

	// The timestamp when the browser was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The timestamp when the browser was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the browser.
	//
	// This member is required.
	Name *string

	// The network configuration for a browser. This structure defines how the browser
	// connects to the network.
	//
	// This member is required.
	NetworkConfiguration *types.BrowserNetworkConfiguration

	// The current status of the browser.
	//
	// This member is required.
	Status types.BrowserStatus

	// The browser signing configuration that shows whether cryptographic agent
	// identification is enabled for web bot authentication.
	BrowserSigning *types.BrowserSigningConfigOutput

	// The description of the browser.
	Description *string

	// The IAM role ARN that provides permissions for the browser.
	ExecutionRoleArn *string

	// The reason for failure if the browser is in a failed state.
	FailureReason *string

	// The recording configuration for a browser. This structure defines how browser
	// sessions are recorded.
	Recording *types.RecordingConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetBrowserMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetBrowser{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetBrowser{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetBrowser"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetBrowserValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetBrowser(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetBrowser(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetBrowser",
	}
}
