// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Retrieves detailed information about an evaluator, including its
//
// configuration, status, and metadata. Works with both built-in and custom
// evaluators.
func (c *Client) GetEvaluator(ctx context.Context, params *GetEvaluatorInput, optFns ...func(*Options)) (*GetEvaluatorOutput, error) {
	if params == nil {
		params = &GetEvaluatorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEvaluator", params, optFns, c.addOperationGetEvaluatorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEvaluatorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEvaluatorInput struct {

	//  The unique identifier of the evaluator to retrieve. Can be a built-in
	// evaluator ID (e.g., Builtin.Helpfulness) or a custom evaluator ID.
	//
	// This member is required.
	EvaluatorId *string

	noSmithyDocumentSerde
}

type GetEvaluatorOutput struct {

	//  The timestamp when the evaluator was created.
	//
	// This member is required.
	CreatedAt *time.Time

	//  The Amazon Resource Name (ARN) of the evaluator.
	//
	// This member is required.
	EvaluatorArn *string

	//  The configuration of the evaluator, including LLM-as-a-Judge settings for
	// custom evaluators.
	//
	// This member is required.
	EvaluatorConfig types.EvaluatorConfig

	//  The unique identifier of the evaluator.
	//
	// This member is required.
	EvaluatorId *string

	//  The name of the evaluator.
	//
	// This member is required.
	EvaluatorName *string

	//  The evaluation level ( TOOL_CALL , TRACE , or SESSION ) that determines the
	// scope of evaluation.
	//
	// This member is required.
	Level types.EvaluatorLevel

	//  The current status of the evaluator.
	//
	// This member is required.
	Status types.EvaluatorStatus

	//  The timestamp when the evaluator was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	//  The description of the evaluator.
	Description *string

	//  Whether the evaluator is locked for modification due to being referenced by
	// active online evaluation configurations.
	LockedForModification *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEvaluatorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetEvaluator{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetEvaluator{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEvaluator"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetEvaluatorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEvaluator(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEvaluator(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEvaluator",
	}
}
