// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Retrieves detailed information about an online evaluation configuration,
//
// including its rules, data sources, evaluators, and execution status.
func (c *Client) GetOnlineEvaluationConfig(ctx context.Context, params *GetOnlineEvaluationConfigInput, optFns ...func(*Options)) (*GetOnlineEvaluationConfigOutput, error) {
	if params == nil {
		params = &GetOnlineEvaluationConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetOnlineEvaluationConfig", params, optFns, c.addOperationGetOnlineEvaluationConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetOnlineEvaluationConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetOnlineEvaluationConfigInput struct {

	//  The unique identifier of the online evaluation configuration to retrieve.
	//
	// This member is required.
	OnlineEvaluationConfigId *string

	noSmithyDocumentSerde
}

type GetOnlineEvaluationConfigOutput struct {

	//  The timestamp when the online evaluation configuration was created.
	//
	// This member is required.
	CreatedAt *time.Time

	//  The data source configuration specifying CloudWatch log groups and service
	// names to monitor.
	//
	// This member is required.
	DataSourceConfig types.DataSourceConfig

	//  The list of evaluators applied during online evaluation.
	//
	// This member is required.
	Evaluators []types.EvaluatorReference

	//  The execution status indicating whether the online evaluation is currently
	// running.
	//
	// This member is required.
	ExecutionStatus types.OnlineEvaluationExecutionStatus

	//  The Amazon Resource Name (ARN) of the online evaluation configuration.
	//
	// This member is required.
	OnlineEvaluationConfigArn *string

	//  The unique identifier of the online evaluation configuration.
	//
	// This member is required.
	OnlineEvaluationConfigId *string

	//  The name of the online evaluation configuration.
	//
	// This member is required.
	OnlineEvaluationConfigName *string

	//  The evaluation rule containing sampling configuration, filters, and session
	// settings.
	//
	// This member is required.
	Rule *types.Rule

	//  The status of the online evaluation configuration.
	//
	// This member is required.
	Status types.OnlineEvaluationConfigStatus

	//  The timestamp when the online evaluation configuration was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	//  The description of the online evaluation configuration.
	Description *string

	//  The Amazon Resource Name (ARN) of the IAM role used for evaluation execution.
	EvaluationExecutionRoleArn *string

	//  The reason for failure if the online evaluation configuration execution
	// failed.
	FailureReason *string

	//  The output configuration specifying where evaluation results are written.
	OutputConfig *types.OutputConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetOnlineEvaluationConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetOnlineEvaluationConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetOnlineEvaluationConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetOnlineEvaluationConfig"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetOnlineEvaluationConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetOnlineEvaluationConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetOnlineEvaluationConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetOnlineEvaluationConfig",
	}
}
