// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all custom code interpreters in your account.
func (c *Client) ListCodeInterpreters(ctx context.Context, params *ListCodeInterpretersInput, optFns ...func(*Options)) (*ListCodeInterpretersOutput, error) {
	if params == nil {
		params = &ListCodeInterpretersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCodeInterpreters", params, optFns, c.addOperationListCodeInterpretersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCodeInterpretersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCodeInterpretersInput struct {

	// The maximum number of results to return in the response.
	MaxResults *int32

	// A token to retrieve the next page of results.
	NextToken *string

	// The type of code interpreters to list.
	Type types.ResourceType

	noSmithyDocumentSerde
}

type ListCodeInterpretersOutput struct {

	// The list of code interpreter summaries.
	//
	// This member is required.
	CodeInterpreterSummaries []types.CodeInterpreterSummary

	// A token to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCodeInterpretersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCodeInterpreters{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCodeInterpreters{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCodeInterpreters"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCodeInterpreters(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCodeInterpretersPaginatorOptions is the paginator options for
// ListCodeInterpreters
type ListCodeInterpretersPaginatorOptions struct {
	// The maximum number of results to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCodeInterpretersPaginator is a paginator for ListCodeInterpreters
type ListCodeInterpretersPaginator struct {
	options   ListCodeInterpretersPaginatorOptions
	client    ListCodeInterpretersAPIClient
	params    *ListCodeInterpretersInput
	nextToken *string
	firstPage bool
}

// NewListCodeInterpretersPaginator returns a new ListCodeInterpretersPaginator
func NewListCodeInterpretersPaginator(client ListCodeInterpretersAPIClient, params *ListCodeInterpretersInput, optFns ...func(*ListCodeInterpretersPaginatorOptions)) *ListCodeInterpretersPaginator {
	if params == nil {
		params = &ListCodeInterpretersInput{}
	}

	options := ListCodeInterpretersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCodeInterpretersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCodeInterpretersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCodeInterpreters page.
func (p *ListCodeInterpretersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCodeInterpretersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCodeInterpreters(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCodeInterpretersAPIClient is a client that implements the
// ListCodeInterpreters operation.
type ListCodeInterpretersAPIClient interface {
	ListCodeInterpreters(context.Context, *ListCodeInterpretersInput, ...func(*Options)) (*ListCodeInterpretersOutput, error)
}

var _ ListCodeInterpretersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCodeInterpreters(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCodeInterpreters",
	}
}
