// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Lists all available evaluators, including both builtin evaluators provided by
//
// the service and custom evaluators created by the user.
func (c *Client) ListEvaluators(ctx context.Context, params *ListEvaluatorsInput, optFns ...func(*Options)) (*ListEvaluatorsOutput, error) {
	if params == nil {
		params = &ListEvaluatorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEvaluators", params, optFns, c.addOperationListEvaluatorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEvaluatorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEvaluatorsInput struct {

	//  The maximum number of evaluators to return in a single response.
	MaxResults *int32

	//  The pagination token from a previous request to retrieve the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEvaluatorsOutput struct {

	//  The list of evaluator summaries containing basic information about each
	// evaluator.
	//
	// This member is required.
	Evaluators []types.EvaluatorSummary

	//  The pagination token to use in a subsequent request to retrieve the next page
	// of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEvaluatorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEvaluators{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEvaluators{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEvaluators"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEvaluators(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListEvaluatorsPaginatorOptions is the paginator options for ListEvaluators
type ListEvaluatorsPaginatorOptions struct {
	//  The maximum number of evaluators to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEvaluatorsPaginator is a paginator for ListEvaluators
type ListEvaluatorsPaginator struct {
	options   ListEvaluatorsPaginatorOptions
	client    ListEvaluatorsAPIClient
	params    *ListEvaluatorsInput
	nextToken *string
	firstPage bool
}

// NewListEvaluatorsPaginator returns a new ListEvaluatorsPaginator
func NewListEvaluatorsPaginator(client ListEvaluatorsAPIClient, params *ListEvaluatorsInput, optFns ...func(*ListEvaluatorsPaginatorOptions)) *ListEvaluatorsPaginator {
	if params == nil {
		params = &ListEvaluatorsInput{}
	}

	options := ListEvaluatorsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEvaluatorsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEvaluatorsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEvaluators page.
func (p *ListEvaluatorsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEvaluatorsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEvaluators(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEvaluatorsAPIClient is a client that implements the ListEvaluators
// operation.
type ListEvaluatorsAPIClient interface {
	ListEvaluators(context.Context, *ListEvaluatorsInput, ...func(*Options)) (*ListEvaluatorsOutput, error)
}

var _ ListEvaluatorsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEvaluators(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEvaluators",
	}
}
