// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Initiates the AI-powered generation of Cedar policies from natural language
// descriptions within the AgentCore Policy system. This feature enables both
// technical and non-technical users to create policies by describing their
// authorization requirements in plain English, which is then automatically
// translated into formal Cedar policy statements. The generation process analyzes
// the natural language input along with the Gateway's tool context to produce
// validated policy options. Generated policy assets are automatically deleted
// after 7 days, so you should review and create policies from the generated assets
// within this timeframe. Once created, policies are permanent and not subject to
// this expiration. Generated policies should be reviewed and tested in log-only
// mode before deploying to production. Use this when you want to describe policy
// intent naturally rather than learning Cedar syntax, though generated policies
// may require refinement for complex scenarios.
func (c *Client) StartPolicyGeneration(ctx context.Context, params *StartPolicyGenerationInput, optFns ...func(*Options)) (*StartPolicyGenerationOutput, error) {
	if params == nil {
		params = &StartPolicyGenerationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartPolicyGeneration", params, optFns, c.addOperationStartPolicyGenerationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartPolicyGenerationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartPolicyGenerationInput struct {

	// The natural language description of the desired policy behavior. This content
	// is processed by AI to generate corresponding Cedar policy statements that match
	// the described intent.
	//
	// This member is required.
	Content types.Content

	// A customer-assigned name for the policy generation request. This helps track
	// and identify generation operations, especially when running multiple generations
	// simultaneously.
	//
	// This member is required.
	Name *string

	// The identifier of the policy engine that provides the context for policy
	// generation. This engine's schema and tool context are used to ensure generated
	// policies are valid and applicable.
	//
	// This member is required.
	PolicyEngineId *string

	// The resource information that provides context for policy generation. This
	// helps the AI understand the target resources and generate appropriate access
	// control rules.
	//
	// This member is required.
	Resource types.Resource

	// A unique, case-sensitive identifier to ensure the idempotency of the request.
	// The AWS SDK automatically generates this token, so you don't need to provide it
	// in most cases. If you retry a request with the same client token, the service
	// returns the same response without starting a duplicate generation.
	ClientToken *string

	noSmithyDocumentSerde
}

type StartPolicyGenerationOutput struct {

	// The timestamp when the policy generation request was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The customer-assigned name for the policy generation request.
	//
	// This member is required.
	Name *string

	// The identifier of the policy engine associated with the started policy
	// generation.
	//
	// This member is required.
	PolicyEngineId *string

	// The ARN of the created policy generation request.
	//
	// This member is required.
	PolicyGenerationArn *string

	// The unique identifier assigned to the policy generation request for tracking
	// progress.
	//
	// This member is required.
	PolicyGenerationId *string

	// The resource information associated with the policy generation request.
	//
	// This member is required.
	Resource types.Resource

	// The initial status of the policy generation request.
	//
	// This member is required.
	Status types.PolicyGenerationStatus

	// Additional information about the generation status.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when the policy generation was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Initial findings from the policy generation process.
	Findings *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartPolicyGenerationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartPolicyGeneration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartPolicyGeneration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartPolicyGeneration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartPolicyGenerationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartPolicyGenerationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartPolicyGeneration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartPolicyGeneration struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartPolicyGeneration) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartPolicyGeneration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartPolicyGenerationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartPolicyGenerationInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartPolicyGenerationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartPolicyGeneration{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartPolicyGeneration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartPolicyGeneration",
	}
}
