// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing API key credential provider.
func (c *Client) UpdateApiKeyCredentialProvider(ctx context.Context, params *UpdateApiKeyCredentialProviderInput, optFns ...func(*Options)) (*UpdateApiKeyCredentialProviderOutput, error) {
	if params == nil {
		params = &UpdateApiKeyCredentialProviderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateApiKeyCredentialProvider", params, optFns, c.addOperationUpdateApiKeyCredentialProviderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateApiKeyCredentialProviderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateApiKeyCredentialProviderInput struct {

	// The new API key to use for authentication. This value replaces the existing API
	// key and is encrypted and stored securely.
	//
	// This member is required.
	ApiKey *string

	// The name of the API key credential provider to update.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type UpdateApiKeyCredentialProviderOutput struct {

	// The Amazon Resource Name (ARN) of the API key secret in AWS Secrets Manager.
	//
	// This member is required.
	ApiKeySecretArn *types.Secret

	// The timestamp when the API key credential provider was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The Amazon Resource Name (ARN) of the API key credential provider.
	//
	// This member is required.
	CredentialProviderArn *string

	// The timestamp when the API key credential provider was last updated.
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// The name of the API key credential provider.
	//
	// This member is required.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateApiKeyCredentialProviderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateApiKeyCredentialProvider{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateApiKeyCredentialProvider{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateApiKeyCredentialProvider"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateApiKeyCredentialProviderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateApiKeyCredentialProvider(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateApiKeyCredentialProvider(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateApiKeyCredentialProvider",
	}
}
